/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.trackers;

import de.maggicraft.ism.analytics.server.ECategory;
import de.maggicraft.ism.analytics.trackers.IDownloadTracker;
import de.maggicraft.ism.analytics.trackers.TrackingEvent;
import de.maggicraft.ism.analytics.util.EMeasure;
import de.maggicraft.manalytics.request.EventHit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class TrackAddProject
extends TrackingEvent
implements IDownloadTracker {
    @NotNull
    private final AtomicLong mTimeTotal = new AtomicLong();
    private String mProjectURL;
    private int mProjectUnit;
    private long mTimeDownload = -1L;
    private long mTimeConvert = -1L;
    private int mStructuresConverted = -1;
    private int mCountedBlocks = -1;

    public TrackAddProject() {
        super(EMeasure.TRACK_PROJECT);
        ((EventHit)this.mRequest).eventCategory(ECategory.CATEGORY_WORLD.getName());
    }

    public TrackAddProject(@NotNull String pProjectURL, int pProjectUnit) {
        super(EMeasure.TRACK_PROJECT, ECategory.CATEGORY_WORLD, "Add Project", pProjectURL);
        this.mProjectURL = pProjectURL;
        this.mProjectUnit = pProjectUnit;
    }

    private void checkGathered() {
        if (this.mTimeTotal.get() > -1L && this.mTimeDownload > -1L && this.mTimeConvert > -1L && this.mStructuresConverted > -1 && this.mCountedBlocks > -1) {
            this.gathered();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TrackAddProject{");
        sb.append("mTimeTotal=").append(this.mTimeTotal);
        sb.append(", mProjectURL='").append(this.mProjectURL).append('\'');
        sb.append(", mProjectUnit=").append(this.mProjectUnit);
        sb.append(", mTimeDownload=").append(this.mTimeDownload);
        sb.append(", mTimeConvert=").append(this.mTimeConvert);
        sb.append(", mStructuresConverted=").append(this.mStructuresConverted);
        sb.append(", mCountedBlocks=").append(this.mCountedBlocks);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void addTimeTotal(long pTimeTotal) {
        this.mTimeTotal.addAndGet(pTimeTotal);
        this.checkGathered();
    }

    @Override
    @NotNull
    public String getProjectURL() {
        return this.mProjectURL;
    }

    @Override
    public long getTimeTotal() {
        return this.mTimeTotal.get();
    }

    @Override
    public long getTimeDownload() {
        return this.mTimeDownload;
    }

    @Override
    public void setTimeDownload(long pTimeDownload) {
        this.mTimeDownload = pTimeDownload;
        this.checkGathered();
    }

    @Override
    public long getTimeConvert() {
        return this.mTimeConvert;
    }

    @Override
    public void setTimeConvert(long pTimeConvert) {
        this.mTimeConvert = pTimeConvert;
        this.checkGathered();
    }

    @Override
    public int getStructuresConverted() {
        return this.mStructuresConverted;
    }

    @Override
    public void setStructuresConverted(int pStructuresConverted) {
        this.mStructuresConverted = pStructuresConverted;
        this.checkGathered();
    }

    @Override
    public int getCountedBlocks() {
        return this.mCountedBlocks;
    }

    @Override
    public void setCountedBlocks(int pCountedBlocks) {
        this.mCountedBlocks = pCountedBlocks;
        this.checkGathered();
    }

    @Override
    public int getPID() {
        return this.mProjectUnit;
    }
}

