/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.trackers;

import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.trackers.ETrackerState;
import de.maggicraft.ism.analytics.trackers.ISendable;
import de.maggicraft.ism.analytics.trackers.TrackingEvent;
import de.maggicraft.ism.analytics.util.EGAType;
import de.maggicraft.ism.analytics.util.EMeasure;
import de.maggicraft.ism.analytics.util.EMetric;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.mioutil.json.IUID;
import org.jetbrains.annotations.NotNull;

public class TrackClose
implements ISendable {
    @NotNull
    private final TrackingEvent mISMStarted;
    @NotNull
    private final ECloseType mCloseType;

    private TrackClose(@NotNull ECloseType pCloseType) {
        this.mCloseType = pCloseType;
        this.mISMStarted = new TrackingEvent(EMeasure.TRACK_START, "ISM Close", null, pCloseType.getUID()){

            @Override
            public void send() {
                this.check(ETrackerState.GATHERED);
                this.setState(ETrackerState.SENDING);
                boolean sendAsynchronously = TrackClose.this.mCloseType == ECloseType.ISM_KEPT_OPEN_AUTOMATICALLY || TrackClose.this.mCloseType == ECloseType.ISM_KEPT_OPEN_MANUALLY || TrackClose.this.mCloseType == ECloseType.ABORT_CLOSING_ISM;
                ISMContainer.getAnalyticsManager().send(this, EGAType.TYPE_NORMAL, sendAsynchronously);
                this.check(ETrackerState.SENDING);
                this.setState(ETrackerState.SENT);
            }
        };
        this.mISMStarted.metric(EMetric.START_ISM, 1);
        this.mISMStarted.gathered();
    }

    public static void trackCloseEvent(@NotNull ECloseType pCloseType) {
        if (MAnalyticsSettings.isEnabled(EMeasure.TRACK_START)) {
            new TrackClose(pCloseType).send();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TrackStart{");
        sb.append("mISMStarted=").append(this.mISMStarted);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void send() {
        this.mISMStarted.send();
    }

    public static enum ECloseType implements IUID
    {
        ISM_CLOSED_AUTOMATICALLY("ismClosedAutomatically"),
        ISM_CLOSED_MANUALLY("ismClosedManually"),
        ISM_KEPT_OPEN_AUTOMATICALLY("ismKeptOpenAutomatically"),
        ISM_KEPT_OPEN_MANUALLY("ismKeptOpenManually"),
        CLOSE_ISM_KEEP_MC("closeISMKeepMC"),
        ABORT_CLOSING_ISM("abortClosingISM");

        @NotNull
        private final String mUID;

        private ECloseType(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

