/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.trackers;

import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.manager.MAnalyticsUtil;
import de.maggicraft.ism.analytics.trackers.TrackPageView;
import de.maggicraft.ism.analytics.util.EMeasure;
import de.maggicraft.ism.analytics.util.EUTMView;
import de.maggicraft.mgui.comp.MEditor;
import de.maggicraft.mgui.util.Util;
import java.awt.event.ActionListener;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class TrackControlledPage
extends TrackPageView {
    private TrackControlledPage(@NotNull String pURL, @NotNull String pTitle) {
        super(EMeasure.TRACK_OPENED_LINKS, pURL, pTitle);
    }

    public static void trackControlledPage(@NotNull String pURL, @NotNull String pTitle) {
        if (MAnalyticsSettings.isEnabled(EMeasure.TRACK_PLACE_STR)) {
            new TrackControlledPage(pURL, pTitle).send();
        }
    }

    public static void addTracker(@NotNull MEditor pEditor, @NotNull String pTitle) {
        pEditor.addHyperlinkListener(pEvent -> {
            String desc;
            if (pEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && ((desc = pEvent.getDescription()).startsWith("https://") || desc.startsWith("http://") || desc.startsWith("www."))) {
                TrackControlledPage.trackControlledPage(desc, pTitle);
            }
        });
    }

    @NotNull
    public static ActionListener utmURLAction(@NotNull String pSubUrl, @NotNull String pTitle, @NotNull EUTMView pTrackingCode) {
        return event -> {
            String utmURL = MAnalyticsUtil.getUTMUrl(pSubUrl, pTrackingCode);
            Util.openURL(utmURL);
            TrackControlledPage.trackControlledPage(utmURL, pTitle);
        };
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TrackControlledPage{");
        sb.append("mRequest=").append(this.mRequest);
        sb.append('}');
        return sb.toString();
    }
}

