/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.trackers;

import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.trackers.TrackingBase;
import de.maggicraft.ism.analytics.util.EMeasure;
import de.maggicraft.manalytics.request.ExceptionHit;
import org.jetbrains.annotations.NotNull;

public class TrackException
extends TrackingBase<ExceptionHit> {
    private final boolean mFatal;

    private TrackException(@NotNull Throwable pThrowable, boolean pFatal) {
        super(new ExceptionHit(), pFatal ? EMeasure.TRACK_ERROR : EMeasure.TRACK_EXCEPTION);
        this.mFatal = pFatal;
        StackTraceElement stack = pThrowable.getStackTrace()[0];
        String path = stack.getClassName() + '.' + stack.getMethodName() + ':' + stack.getLineNumber();
        String title = pThrowable.toString();
        ((ExceptionHit)this.mRequest).documentPath(path);
        ((ExceptionHit)this.mRequest).documentTitle(title);
        ((ExceptionHit)this.mRequest).exceptionFatal(pFatal);
        this.gathered();
    }

    private TrackException(@NotNull Throwable pThrowable, @NotNull String pDesc, boolean pFatal) {
        this(pThrowable, pFatal);
        ((ExceptionHit)this.mRequest).exceptionDescription(pDesc);
    }

    public static void trackException(@NotNull Throwable pThrowable, boolean pFatal) {
        if (MAnalyticsSettings.isEnabled(EMeasure.TRACK_EXCEPTION)) {
            new TrackException(pThrowable, pFatal).send();
        }
    }

    public static void trackException(@NotNull Throwable pThrowable, @NotNull String pDescription, boolean pFatal) {
        if (MAnalyticsSettings.isEnabled(EMeasure.TRACK_EXCEPTION)) {
            new TrackException(pThrowable, pDescription, pFatal);
        }
    }

    @Override
    public boolean isTrackable() {
        return this.mFatal && MAnalyticsSettings.isEnabled(EMeasure.TRACK_ERROR) || !this.mFatal && MAnalyticsSettings.isEnabled(EMeasure.TRACK_EXCEPTION);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TrackException{");
        sb.append("mFatal=").append(this.mFatal);
        sb.append(", mRequest=").append(this.mRequest);
        sb.append('}');
        return sb.toString();
    }
}

