/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.trackers;

import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.trackers.TrackingEvent;
import de.maggicraft.ism.analytics.util.EMeasure;
import de.maggicraft.ism.loader.ISMContainer;
import java.awt.Dimension;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class TrackResolution {
    private final AtomicBoolean IS_THREAD_RUNNING = new AtomicBoolean(false);
    private Dimension mCurDimension;
    private long mLasResChange;

    @NotNull
    public static TrackingEvent std(@NotNull Dimension pDimension) {
        TrackingEvent event = new TrackingEvent(EMeasure.TRACK_RESOLUTION, "Resolution", "Resize", null);
        event.getRequest().viewportSize(pDimension.getWidth() + "x" + pDimension.getHeight());
        event.gathered();
        return event;
    }

    public void trackResolution() {
        if (!MAnalyticsSettings.isEnabled(EMeasure.TRACK_RESOLUTION)) {
            return;
        }
        this.mLasResChange = System.currentTimeMillis();
        if (!this.IS_THREAD_RUNNING.getAndSet(true)) {
            new Thread(() -> {
                try {
                    while (System.currentTimeMillis() - this.mLasResChange < 7500L) {
                        try {
                            Thread.sleep(2600L);
                        }
                        catch (InterruptedException pE) {
                            ISMContainer.getLogger().logNoAnalytics(pE);
                        }
                        this.mCurDimension = ISMContainer.getStrExplorer().getFrame().getSize();
                    }
                    TrackResolution.std(this.mCurDimension).send();
                }
                finally {
                    this.IS_THREAD_RUNNING.set(false);
                }
            }).start();
        }
    }

    @NotNull
    public Optional<Dimension> getCurDimension() {
        return Optional.ofNullable(this.mCurDimension);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TrackResolution{");
        sb.append("IS_THREAD_RUNNING=").append(this.IS_THREAD_RUNNING);
        sb.append(", mCurDimension=").append(this.mCurDimension);
        sb.append(", mLasResChange=").append(this.mLasResChange);
        sb.append('}');
        return sb.toString();
    }
}

