/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.trackers;

import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.trackers.ISendable;
import de.maggicraft.ism.analytics.trackers.TrackPageView;
import de.maggicraft.ism.analytics.trackers.TrackingEvent;
import de.maggicraft.ism.analytics.util.EDimension;
import de.maggicraft.ism.analytics.util.EMeasure;
import de.maggicraft.ism.analytics.util.EMetric;
import de.maggicraft.ism.analytics.util.ESearchMode;
import de.maggicraft.ism.analytics.util.IDimension;
import de.maggicraft.ism.loader.ISMContainer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TrackSearch
implements ISendable {
    public static final String[] SEARCH_SRC = new String[]{"project", "title", "tags", "url"};
    public static final String[] SEARCH_BLOCKS = new String[]{"all_blocks", "<1.000", "1.000-10.000", "10.000-100.000", "100.000-1.000.000", ">1.000.000"};
    public static final String[] SEARCH_AREA = new String[]{"all_areas", "tiny", "small", "medium", "large", "huge"};
    public static final String[] SEARCH_SORT = new String[]{"rank", "blocks", "area", "downloads", "views", "favorites", "diamonds", "comments", "updated", "posted"};
    @NotNull
    private final List<ISendable> mSendables = new LinkedList<ISendable>();

    private TrackSearch(@NotNull String pQuery, @NotNull ESearchMode pType, boolean pTag, int pSrc, int pBlocks, int pArea, int pSort, boolean pDesc, int pResultQuantity, int pTime) {
        String cat = "Search";
        TrackingEvent type = new TrackingEvent(EMeasure.TRACK_SEARCH, "Search", "search type", pTag ? "tag" : "direct search");
        type.gathered();
        TrackingEvent source = new TrackingEvent(EMeasure.TRACK_SEARCH, "Search", "source", SEARCH_SRC[pSrc]);
        source.gathered();
        TrackingEvent search = new TrackingEvent(EMeasure.TRACK_SEARCH, "Search", "blocks", SEARCH_BLOCKS[pBlocks]);
        search.gathered();
        TrackingEvent area = new TrackingEvent(EMeasure.TRACK_SEARCH, "Search", "area", SEARCH_AREA[pArea]);
        area.gathered();
        this.mSendables.add(type);
        this.mSendables.add(source);
        this.mSendables.add(search);
        this.mSendables.add(area);
        TrackingEvent eventSort = new TrackingEvent(EMeasure.TRACK_SEARCH, "Search", "sorting", SEARCH_SORT[pSort]);
        eventSort.dimension((IDimension)EDimension.FREE_TEXT, pDesc ? "descending" : "ascending");
        eventSort.gathered();
        this.mSendables.add(eventSort);
        try {
            String url = '/' + pType.getName() + "?q=" + URLEncoder.encode(pQuery, "UTF-8");
            TrackPageView view = new TrackPageView(EMeasure.TRACK_SEARCH, url);
            view.metric(EMetric.RESULTS_QUANTITY, pResultQuantity);
            view.metric(EMetric.TIME_ONE, pTime);
            view.gathered();
            this.mSendables.add(view);
        }
        catch (UnsupportedEncodingException pE) {
            ISMContainer.getLogger().logNoAnalytics(pE);
        }
    }

    public static void trackSearch(@NotNull String pQuery, @NotNull ESearchMode pType, boolean pTag, int pSrc, int pBlocks, int pArea, int pSort, boolean pDesc, int pResultQuantity, int pTime) {
        if (MAnalyticsSettings.isEnabled(EMeasure.TRACK_SEARCH)) {
            new TrackSearch(pQuery, pType, pTag, pSrc, pBlocks, pArea, pSort, pDesc, pResultQuantity, pTime).send();
        }
    }

    @Override
    public void send() {
        for (ISendable sendable : this.mSendables) {
            sendable.send();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TrackSearch{");
        sb.append("mSendables=").append(this.mSendables);
        sb.append('}');
        return sb.toString();
    }
}

