/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.trackers;

import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.trackers.ISendable;
import de.maggicraft.ism.analytics.trackers.TrackingEvent;
import de.maggicraft.ism.analytics.util.EDimension;
import de.maggicraft.ism.analytics.util.EMeasure;
import de.maggicraft.ism.analytics.util.EMetric;
import de.maggicraft.ism.analytics.util.IDimension;
import de.maggicraft.ism.loader.ISMContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackStart
implements ISendable {
    @NotNull
    private final TrackingEvent mISMStarted;
    @Nullable
    private TrackingEvent mVersionChanged;

    private TrackStart(boolean pIsLegal) {
        int started = (Integer)MAnalyticsSettings.SETTING_STARTED.getValue();
        String lastISMVersion = (String)MAnalyticsSettings.SETTING_LAST_ISM_VERSION.getValue();
        String lastMCVersion = (String)MAnalyticsSettings.SETTING_LAST_MC_VERSION.getValue();
        if (!lastISMVersion.equals(ISMContainer.getVersionHolder().getISMVersion()) || !lastMCVersion.equals(ISMContainer.getVersionHolder().getMinecraftVersion())) {
            this.mVersionChanged = new TrackingEvent(EMeasure.TRACK_START, "Version Changed", null, ISMContainer.getVersionHolder().getISMVersion());
            this.mVersionChanged.dimension((IDimension)EDimension.LAST_ISM_VERSION, lastISMVersion);
            this.mVersionChanged.dimension((IDimension)EDimension.FREE_TEXT, lastMCVersion);
            this.mVersionChanged.gathered();
            MAnalyticsSettings.SETTING_LAST_ISM_VERSION.setValue(ISMContainer.getVersionHolder().getISMVersion());
            MAnalyticsSettings.SETTING_LAST_MC_VERSION.setValue(ISMContainer.getVersionHolder().getMinecraftVersion());
        }
        this.mISMStarted = new TrackingEvent(EMeasure.TRACK_START, "ISM Start", null, Integer.toString(started));
        this.mISMStarted.metric(EMetric.START_ISM, 1);
        this.mISMStarted.metric(EMetric.RESULTS_QUANTITY, pIsLegal);
        this.mISMStarted.gathered();
        MAnalyticsSettings.SETTING_STARTED.setValue(++started);
    }

    public static void trackStart(boolean pIsLegal) {
        if (MAnalyticsSettings.isEnabled(EMeasure.TRACK_START)) {
            new TrackStart(pIsLegal).send();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TrackStart{");
        sb.append("mISMStarted=").append(this.mISMStarted);
        sb.append(", mVersionChanged=").append(this.mVersionChanged);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void send() {
        if (this.mVersionChanged != null) {
            this.mVersionChanged.send();
        }
        this.mISMStarted.send();
    }
}

