/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.trackers;

import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.trackers.ETrackerState;
import de.maggicraft.ism.analytics.trackers.ITrackable;
import de.maggicraft.ism.analytics.util.EGAType;
import de.maggicraft.ism.analytics.util.EMeasure;
import de.maggicraft.ism.analytics.util.EMetric;
import de.maggicraft.ism.analytics.util.IDimension;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.manalytics.request.GoogleAnalyticsRequest;
import de.maggicraft.mcommons.state_machine.IState;
import de.maggicraft.mcommons.state_machine.IStateMachine;
import org.jetbrains.annotations.NotNull;

public class TrackingBase<T extends GoogleAnalyticsRequest<T>>
implements ITrackable,
IStateMachine<ETrackerState> {
    @NotNull
    protected final T mRequest;
    @NotNull
    private final EMeasure mMeasure;
    @NotNull
    private ETrackerState mState = ETrackerState.GATHERING;
    @NotNull
    private EGAType mGAType = EGAType.TYPE_NORMAL;

    public TrackingBase(@NotNull T pRequest, @NotNull EMeasure pMeasure) {
        this.mRequest = pRequest;
        this.mMeasure = pMeasure;
    }

    public void dimension(@NotNull IDimension pMetric, int pValue) {
        ((GoogleAnalyticsRequest)this.mRequest).customDimension((Integer)pMetric.getUID(), Integer.toString(pValue));
    }

    public void dimension(@NotNull IDimension pMetric, @NotNull String pValue) {
        ((GoogleAnalyticsRequest)this.mRequest).customDimension((Integer)pMetric.getUID(), pValue);
    }

    public void metric(@NotNull EMetric pMetric, boolean pValue) {
        ((GoogleAnalyticsRequest)this.mRequest).customMetric(pMetric.getUID(), pValue ? "1" : "0");
    }

    public void metric(@NotNull EMetric pMetric, int pValue) {
        ((GoogleAnalyticsRequest)this.mRequest).customMetric(pMetric.getUID(), Integer.toString(pValue));
    }

    public void metric(@NotNull EMetric pMetric, long pValue) {
        ((GoogleAnalyticsRequest)this.mRequest).customMetric(pMetric.getUID(), Long.toString(pValue));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TrackingBase{");
        sb.append("mRequest=").append(this.mRequest);
        sb.append(", mMeasure=").append(this.mMeasure);
        sb.append(", mState=").append(this.mState);
        sb.append(", mGAType=").append(this.mGAType);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void send() {
        this.check(ETrackerState.GATHERED);
        this.mState = ETrackerState.SENDING;
        ISMContainer.getAnalyticsManager().send(this, this.mGAType);
        this.check(ETrackerState.SENDING);
        this.mState = ETrackerState.SENT;
    }

    @Override
    public boolean isTrackable() {
        return MAnalyticsSettings.isEnabled(this.mMeasure);
    }

    public void setGAType(@NotNull EGAType pGAType) {
        this.mGAType = pGAType;
    }

    @NotNull
    public TrackingBase gathered() {
        this.mState = ETrackerState.GATHERED;
        return this;
    }

    public void setState(@NotNull ETrackerState pState) {
        this.mState = pState;
    }

    @Override
    @NotNull
    public GoogleAnalyticsRequest getRequest() {
        return this.mRequest;
    }

    @Override
    @NotNull
    public EMeasure getMeasure() {
        return this.mMeasure;
    }

    @Override
    @NotNull
    public IState getState() {
        return this.mState;
    }
}

