/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.util;

import de.maggicraft.ism.analytics.trackers.TrackView;
import de.maggicraft.ism.analytics.util.IViewEvent;
import de.maggicraft.ism.analytics.util.IViewEventStack;
import org.jetbrains.annotations.Nullable;

public class MViewEventStack
implements IViewEventStack {
    @Nullable
    private IViewEvent mCurrent;
    private long mTimeTMP;
    private long mTimeViewed;

    @Override
    public synchronized void focus(boolean pIsFocused) {
        if (pIsFocused) {
            this.mTimeTMP = System.currentTimeMillis();
        } else if (this.mTimeTMP != 0L) {
            this.mTimeViewed += System.currentTimeMillis() - this.mTimeTMP;
            this.mTimeTMP = 0L;
        }
    }

    @Override
    public void addView(@Nullable IViewEvent pCurrent) {
        if (this.mCurrent != null) {
            this.focus(false);
            TrackView.trackView(this.mCurrent.getURL());
        }
        this.mTimeTMP = System.currentTimeMillis();
        this.mTimeViewed = 0L;
        this.mCurrent = pCurrent;
    }

    @Override
    public long getTimeViewed() {
        return this.mTimeViewed;
    }
}

