/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.app_state;

import de.maggicraft.ism.app_state.EAppState;
import de.maggicraft.ism.app_state.IAppState;
import de.maggicraft.ism.app_state.IMCSideStateServer;
import de.maggicraft.ism.loader.MCContainer;
import de.maggicraft.mcommons.event.IVoidObserver;
import de.maggicraft.mcommons.state_machine.IState;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ISMSideState
implements IAppState {
    @NotNull
    private final Map<EAppState, Collection<IVoidObserver>> mObservers = new EnumMap<EAppState, Collection<IVoidObserver>>(EAppState.class);
    @NotNull
    private EAppState mState = EAppState.RUNNING;

    @Override
    public void initialize() {
        this.registerObserver(EAppState.CLOSED, MCContainer::deinitializeServerFunctionality);
        this.notifyObservers(EAppState.RUNNING);
        new Thread(() -> {
            try {
                MCContainer.getISMLoaderServer().requiredMCSideStateServer();
                IMCSideStateServer ismSideState = (IMCSideStateServer)MCContainer.getRegistry().lookup("mcSideState");
                while (true) {
                    ismSideState.isISMSideRunning();
                    Thread.sleep(1500L);
                }
            }
            catch (InterruptedException | NotBoundException | RemoteException pE) {
                this.setState(EAppState.CLOSED);
                return;
            }
        }).start();
    }

    @Override
    public void setState(@NotNull EAppState pState) {
        if (pState == EAppState.RUNNING) {
            this.check(EAppState.RUNNING);
        } else if (pState == EAppState.CLOSING) {
            this.check(EAppState.RUNNING);
        } else if (pState == EAppState.CLOSED) {
            this.check(new EAppState[]{EAppState.RUNNING, EAppState.CLOSING});
        }
        this.mState = pState;
        this.notifyObservers(this.mState);
    }

    @Override
    @NotNull
    public Map<EAppState, Collection<IVoidObserver>> getObservers() {
        return this.mObservers;
    }

    @Override
    @NotNull
    public IState getState() {
        return this.mState;
    }
}

