/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.app_state;

import de.maggicraft.ism.analytics.trackers.TrackClose;
import de.maggicraft.ism.config.EFeature;
import de.maggicraft.ism.gui.MTrackableDialog;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.ism.views.EViewSetting;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MSwitcher;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.view.MDialog;
import de.maggicraft.mgui.view.util.EWindowSize;
import java.awt.Frame;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MCClosedDialog
extends MTrackableDialog {
    private MSwitcher mAsk;

    public MCClosedDialog() {
        super((Frame)ISMContainer.getStrExplorer().getFrame(), EWindowSize.FOUR);
        this.title("mcClosed");
    }

    @Override
    public void init(@NotNull MDialog pDialog) {
        new MText(MPos.pos(pDialog, "||m,[[p<60>")).title("mcClosed");
        MButton bClose = new MButton(MPos.pos(pDialog, "[[p,]]s")).addAction(pEvent -> this.handleClose()).title("closeISM");
        new MButton(MPos.pos(pDialog, "]]p,]]s")).addAction(pEvent -> this.handleContinue()).defButton().title("continueISM");
        this.mAsk = new MSwitcher(MPos.pos("V[[p,][p", bClose), false).title("rememberDecision", new MTip());
    }

    private void handleClose() {
        if (this.mAsk.isSelected()) {
            CSettings.SETTING_MINECRAFT_CLOSED.setValue("closeISM");
            MCClosedDialog.updateSettingsView();
        }
        TrackClose.trackCloseEvent(TrackClose.ECloseType.ISM_CLOSED_MANUALLY);
        ISMContainer.getStrExplorer().getFrame().dispose();
        System.exit(0);
    }

    private void handleContinue() {
        if (this.mAsk.isSelected()) {
            CSettings.SETTING_MINECRAFT_CLOSED.setValue("keepISMOpen");
            MCClosedDialog.updateSettingsView();
            EFeature.disableMCRequired();
        }
        this.dispose();
        TrackClose.trackCloseEvent(TrackClose.ECloseType.ISM_KEPT_OPEN_MANUALLY);
        ISMContainer.deinitializeServerFunctionality();
    }

    private static void updateSettingsView() {
        if (ViewManager.isCurrent(ViewManager.VIEW_SETTINGS) && ViewManager.VIEW_SETTINGS.getState() == EViewSetting.SETTINGS_GENERAL) {
            ViewManager.VIEW_SETTINGS.updateMCClosed();
        }
    }

    @Override
    public void afterInit() {
        SwingUtilities.invokeLater(this::afterDisplay);
    }

    @Override
    @NotNull
    protected String getURI() {
        return "minecraft-closed";
    }
}

