/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.app_state;

import de.maggicraft.ism.analytics.trackers.TrackClose;
import de.maggicraft.ism.app_state.EAppState;
import de.maggicraft.ism.app_state.IAppState;
import de.maggicraft.ism.app_state.IISMSideStateServer;
import de.maggicraft.ism.app_state.MCClosedDialog;
import de.maggicraft.ism.config.EFeature;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.mcommons.event.IVoidObserver;
import de.maggicraft.mcommons.state_machine.IState;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MCSideState
implements IAppState {
    @NotNull
    private final Map<EAppState, Collection<IVoidObserver>> mObservers = new EnumMap<EAppState, Collection<IVoidObserver>>(EAppState.class);
    @NotNull
    private EAppState mState = EAppState.RUNNING;

    @Override
    public void initialize() {
        this.registerObserver(EAppState.CLOSED, MCSideState::handleCloseEvent);
        this.notifyObservers(EAppState.RUNNING);
        new Thread(() -> {
            try {
                ISMContainer.getMCLoaderServer().requiredISMSideStateServer();
                IISMSideStateServer mcSideState = (IISMSideStateServer)ISMContainer.getRegistry().lookup("ismSideState");
                while (true) {
                    mcSideState.isMCSideRunning();
                    Thread.sleep(1500L);
                }
            }
            catch (InterruptedException | NotBoundException | RemoteException pE) {
                this.setState(EAppState.CLOSED);
                return;
            }
        }).start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleCloseEvent() {
        if (ISMContainer.getStrExplorer().getFrame().isVisible()) {
            String setting = (String)CSettings.SETTING_MINECRAFT_CLOSED.getValue();
            if (setting.equals("ask")) {
                new MCClosedDialog().visible();
                return;
            } else if (setting.equals("closeISM")) {
                ISMContainer.getStrExplorer().getFrame().dispose();
                TrackClose.trackCloseEvent(TrackClose.ECloseType.ISM_CLOSED_AUTOMATICALLY);
                System.exit(0);
                return;
            } else {
                if (!setting.equals("keepISMOpen")) throw new IllegalArgumentException();
                EFeature.disableMCRequired();
                TrackClose.trackCloseEvent(TrackClose.ECloseType.ISM_CLOSED_AUTOMATICALLY);
                ISMContainer.deinitializeServerFunctionality();
            }
            return;
        } else {
            System.exit(0);
        }
    }

    @Override
    public void setState(@NotNull EAppState pState) {
        if (pState == EAppState.RUNNING) {
            this.check(EAppState.RUNNING);
        } else if (pState == EAppState.CLOSING) {
            this.check(EAppState.RUNNING);
        } else if (pState == EAppState.CLOSED) {
            this.check(new EAppState[]{EAppState.RUNNING, EAppState.CLOSING});
        }
        this.mState = pState;
        this.notifyObservers(this.mState);
    }

    @Override
    @NotNull
    public Map<EAppState, Collection<IVoidObserver>> getObservers() {
        return this.mObservers;
    }

    @Override
    @NotNull
    public IState getState() {
        return this.mState;
    }
}

