/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.config;

import de.maggicraft.ism.config.EFeature;
import de.maggicraft.ism.config.IConfigManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.ReadableUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ConfigManager
implements IConfigManager {
    private String mMinecraftVersion;
    private String mISMVersion;
    private String mModID;

    @Override
    public void initialize() {
        try {
            InputStream stream = ConfigManager.class.getResourceAsStream("/assets/ism/lang/config.json");
            JSONObject json = (JSONObject)new JSONParser().parse(new InputStreamReader(stream));
            for (EFeature feature : EFeature.values()) {
                feature.setSupported(ReadableUtil.getBool(json, feature));
                feature.setUsable(true);
            }
            this.mMinecraftVersion = ReadableUtil.getString(json, EConfigManagerKey.MINECRAFT_VERSION);
            this.mISMVersion = ReadableUtil.getString(json, EConfigManagerKey.ISM_VERSION);
            this.mModID = ReadableUtil.getString(json, EConfigManagerKey.MOD_ID);
        }
        catch (IOException | ParseException pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    @Override
    @NotNull
    public String getMinecraftVersion() {
        return this.mMinecraftVersion;
    }

    @Override
    @NotNull
    public String getISMVersion() {
        return this.mISMVersion;
    }

    @Override
    @NotNull
    public String getModID() {
        return this.mModID;
    }

    private static enum EConfigManagerKey implements IUID
    {
        MINECRAFT_VERSION("minecraftVersion"),
        ISM_VERSION("ismVersion"),
        MOD_ID("modID");

        @NotNull
        private final String mUID;

        private EConfigManagerKey(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

