/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.config;

import de.maggicraft.ism.config.EFeatureObserverType;
import de.maggicraft.mcommons.event.IVoidObserver;
import de.maggicraft.mcommons.event.IVoidTypeObservable;
import de.maggicraft.mioutil.json.IUID;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum EFeature implements IUID,
IVoidTypeObservable<EFeatureObserverType>
{
    BASIC_FEATURE("basicFeature", false),
    PROJECT_LISTS("projectLists", false),
    SCAN_STRUCTURES("scanStructures", true),
    PLACE_STRUCTURES("placeStructures", true),
    REPOSITION_STRUCTURES("repositionStructures", true),
    REMOVE_STRUCTURES("removeStructures", true),
    PLACE_SHAPES("placeShapes", true),
    RECENTLY_PLACED("recentlyPlaced", false),
    STRUCTURES("structures", false),
    COLLECTIONS("collections", false),
    CREATORS("creators", false),
    LOCAL_STRUCTURES("localStructures", false);

    @NotNull
    private final Map<EFeatureObserverType, Collection<IVoidObserver>> mObservers = new EnumMap<EFeatureObserverType, Collection<IVoidObserver>>(EFeatureObserverType.class);
    @NotNull
    private final String mUID;
    @Nullable
    private Boolean mSupported = null;
    @Nullable
    private Boolean mUsable = null;
    @Nullable
    private Boolean mEnabled = null;
    private final boolean mRequiresMC;

    public static void disableMCRequired() {
        for (EFeature feature : EFeature.values()) {
            if (!feature.mRequiresMC) continue;
            feature.setUsable(false);
        }
    }

    private EFeature(String pUID, boolean pRequiresMC) {
        this.mUID = pUID;
        this.mRequiresMC = pRequiresMC;
    }

    public boolean isEnabled() {
        return this.mEnabled == null ? false : this.mEnabled;
    }

    public void setSupported(@NotNull Boolean pSupported) {
        this.setEnabled(pSupported, this.mUsable);
    }

    public void setUsable(@NotNull Boolean pUsable) {
        this.setEnabled(this.mSupported, pUsable);
    }

    private void setEnabled(@Nullable Boolean pSupported, @Nullable Boolean pUsable) {
        boolean enabled = pSupported != null && pUsable != null && pSupported != false && pUsable != false;
        boolean oldEnabled = this.mEnabled != null && this.mEnabled != false;
        this.mUsable = pUsable;
        this.mSupported = pSupported;
        if (enabled != oldEnabled) {
            this.mEnabled = enabled;
            this.notifyObservers(enabled ? EFeatureObserverType.FEATURE_ENABLED : EFeatureObserverType.FEATURE_DISABLED);
        }
    }

    @Override
    @NotNull
    public String getUID() {
        return this.mUID;
    }

    @Override
    @NotNull
    public Map<EFeatureObserverType, Collection<IVoidObserver>> getObservers() {
        return this.mObservers;
    }
}

