/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.database;

import de.maggicraft.ism.database.DataProject;
import de.maggicraft.ism.database.ICollection;
import de.maggicraft.ism.database.MData;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class DataCollection
extends DataProject
implements ICollection {
    private final int mTotalBlocks;

    @Contract(pure=true)
    public DataCollection(int pPID) {
        super(pPID);
        this.mTotalBlocks = MData.totalBlocks(this.mPID);
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        if (!super.equals(pO)) {
            return false;
        }
        DataCollection that = (DataCollection)pO;
        return this.mTotalBlocks == that.mTotalBlocks;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mTotalBlocks);
    }

    @Override
    public String toString() {
        return "DataCollection{mTotalBlocks=" + this.mTotalBlocks + "} " + super.toString();
    }

    @Override
    @NotNull
    public String getName(int pIndex) {
        return this.getStructures().get(pIndex).getName();
    }

    @Override
    public int getTotalBlocks() {
        return this.mTotalBlocks;
    }

    @Override
    public int getQuan() {
        return this.getStructures().size();
    }
}

