/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.database;

import de.maggicraft.ism.database.DataCreators;
import de.maggicraft.ism.database.ICreator;
import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.results.ResCol;
import de.maggicraft.ism.results.ResProject;
import de.maggicraft.ism.search.IResSearch;
import de.maggicraft.mgui.util.ImgUtil;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class DataCreator
implements ICreator {
    @NotNull
    private static final String URL_AVATAR = "https://static.planetminecraft.com/files/avatar/";
    @NotNull
    private static final String URL_BANNER = "https://static.planetminecraft.com/files/profile_banner/";
    @NotNull
    private final int[] mStrUnits;
    @NotNull
    private final String mName;
    @NotNull
    private final String mURL;
    private final int mCID;
    private final int mLevels;
    private final int mSubs;
    private ArrayList<IResSearch> mSearchRes;
    private ImageIcon mAvatar;
    private ImageIcon mBanner;
    private int mBlocks = -1;
    private int mViews = -1;
    private int mComments = -1;
    private int mDiamonds = -1;
    private int mDownloads = -1;
    private int mFavorites = -1;

    @Contract(pure=true)
    public DataCreator(int pCID) {
        this.mCID = pCID;
        this.mStrUnits = MData.creatorStructuresArr(this.mCID);
        this.mName = MData.creatorName(this.mCID);
        this.mURL = MData.creatorURL(this.mCID);
        this.mSubs = MData.creatorSubs(this.mCID);
        this.mLevels = MData.creatorLevels(this.mCID);
    }

    @Override
    @NotNull
    public List<IResSearch> getSearchRes() {
        if (this.mSearchRes == null) {
            this.mSearchRes = new ArrayList(this.mStrUnits.length);
            for (int str : this.mStrUnits) {
                boolean isCollection = MData.projectIsCollection(str);
                this.mSearchRes.add(isCollection ? new ResCol(str, true) : new ResProject(str, true));
            }
        }
        return this.mSearchRes;
    }

    @Override
    @NotNull
    public ImageIcon getAvatar() {
        if (this.mAvatar == null) {
            this.mAvatar = this.loadAvatar();
        }
        return this.mAvatar;
    }

    @Override
    @NotNull
    public ImageIcon getBanner() {
        if (this.mBanner == null) {
            this.mBanner = this.loadBanner();
        }
        return this.mBanner;
    }

    @NotNull
    private ImageIcon loadAvatar() {
        String imgUrl = DataCreators.sAvatar.get(this.mCID);
        Optional<Object> img = Optional.empty();
        if (!imgUrl.equals(".") && (img = SharedUtil.loadImg(URL_AVATAR + DataCreators.sId.get(this.mCID) + imgUrl)).isPresent()) {
            img = Optional.of(ImgUtil.makeScaled((BufferedImage)img.get(), 120, 120));
        }
        return img.map(ImgUtil::getImg).orElse(MData.ICON_DEFAULT_AVATAR);
    }

    private ImageIcon loadBanner() {
        String imgUrl = DataCreators.BANNER_CODES[DataCreators.sBanners.get(this.mCID)];
        if (imgUrl.charAt(0) == '_') {
            imgUrl = DataCreators.sId.get(this.mCID) + imgUrl;
        }
        imgUrl = URL_BANNER + imgUrl;
        Optional<BufferedImage> img = SharedUtil.loadImg(imgUrl);
        return img.map(ImgUtil::getImg).orElse(MData.ICON_DEFAULT_AVATAR);
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        DataCreator that = (DataCreator)pO;
        return this.mCID == that.mCID && this.getBlocks() == that.getBlocks() && this.getViews() == that.getViews() && this.getComments() == that.getComments() && this.getDiamonds() == that.getDiamonds() && this.getDownloads() == that.getDownloads() && this.getFavorites() == that.getFavorites() && this.mLevels == that.mLevels && this.mSubs == that.mSubs && Arrays.equals(this.getStrPIDs(), that.getStrPIDs()) && this.mName.equals(that.mName) && this.mURL.equals(that.mURL);
    }

    public int hashCode() {
        int result = Objects.hash(this.mName, this.mURL, this.mCID, this.getBlocks(), this.getViews(), this.getComments(), this.getDiamonds(), this.getDownloads(), this.getFavorites(), this.mLevels, this.mSubs);
        result = 31 * result + Arrays.hashCode(this.getStrPIDs());
        return result;
    }

    public String toString() {
        return "DataCreator{mStrUnits=" + Arrays.toString(this.mStrUnits) + ", mName='" + this.mName + '\'' + ", mURL='" + this.mURL + '\'' + ", mCID=" + this.mCID + ", mLevels=" + this.mLevels + ", mSubs=" + this.mSubs + ", mBlocks=" + this.mBlocks + ", mViews=" + this.mViews + ", mComments=" + this.mComments + ", mDiamonds=" + this.mDiamonds + ", mDownloads=" + this.mDownloads + ", mFavorites=" + this.mFavorites + '}';
    }

    @Override
    @NotNull
    public String getName() {
        return this.mName;
    }

    @Override
    @NotNull
    public String getURL() {
        return this.mURL;
    }

    @Override
    public int getLevels() {
        return this.mLevels;
    }

    @Override
    public int getSubs() {
        return this.mSubs;
    }

    @Override
    public int getBlocks() {
        if (this.mBlocks == -1) {
            this.mBlocks = MData.totalBlocks(this.mStrUnits);
        }
        return this.mBlocks;
    }

    @Override
    public int getViews() {
        if (this.mViews == -1) {
            this.mViews = MData.totalViews(this.mStrUnits);
        }
        return this.mViews;
    }

    @Override
    public int getDownloads() {
        if (this.mDownloads == -1) {
            this.mDownloads = MData.totalDownloads(this.mStrUnits);
        }
        return this.mDownloads;
    }

    @Override
    public int getFavorites() {
        if (this.mFavorites == -1) {
            this.mFavorites = MData.totalFavorites(this.mStrUnits);
        }
        return this.mFavorites;
    }

    @Override
    public int getDiamonds() {
        if (this.mDiamonds == -1) {
            this.mDiamonds = MData.totalDiamonds(this.mStrUnits);
        }
        return this.mDiamonds;
    }

    @Override
    public int getComments() {
        if (this.mComments == -1) {
            this.mComments = MData.totalComments(this.mStrUnits);
        }
        return this.mComments;
    }

    @Override
    public int getCID() {
        return this.mCID;
    }

    @Override
    @NotNull
    public int[] getStrPIDs() {
        return this.mStrUnits;
    }
}

