/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.database;

import de.maggicraft.ism.database.CData;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.mioutil.cbstream.CBInputStream;
import de.maggicraft.mioutil.compr.Compressed;
import de.maggicraft.mioutil.compr.CompressedText;
import de.maggicraft.mioutil.compr.CompressedUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class DataCreators {
    public static final String ASSETS = "/assets/ism/";
    public static final String ASSETS_LANG = "/assets/ism/lang/";
    static final String[] BANNER_CODES = new String[]{"_0.gif", "_0.jpg", "_0.png", "_1.gif", "_1.jpg", "_1.png", "_10.jpg", "_10.png", "_11.jpg", "_13.jpg", "_13.png", "_14.jpg", "_14.png", "_15.png", "_16.jpg", "_16.png", "_18.jpg", "_18.png", "_2.gif", "_2.jpg", "_2.png", "_20.png", "_21.png", "_28.gif", "_3.gif", "_3.jpg", "_3.png", "_31.png", "_32.png", "_4.gif", "_4.jpg", "_4.png", "_5.gif", "_5.jpg", "_5.png", "_58.jpg", "_6.jpg", "_6.png", "_7.jpg", "_7.png", "_70.jpg", "_8.gif", "_8.jpg", "_8.png", "_9.jpg", "_9.png", "defaults/0.jpg", "defaults/1.jpg", "defaults/10.jpg", "defaults/11.jpg", "defaults/2.jpg", "defaults/3.jpg", "defaults/4.jpg", "defaults/5.jpg", "defaults/6.jpg", "defaults/7.jpg", "defaults/8.jpg", "defaults/9.jpg"};
    private static int sCreatorQuantity;
    static CompressedText sAvatar;
    static Compressed sBanners;
    static CompressedText sCreatorStrs;
    static CompressedText sId;
    static CompressedText sCreators;
    static Compressed sLevels;
    static Compressed sSubs;

    public static void init() {
        try {
            int i;
            char ch;
            String path = "/assets/ism/lang/cres.strexplorer";
            CBInputStream in = new CBInputStream(CData.class.getResourceAsStream(path));
            in.readChar();
            in.readChar();
            sCreatorQuantity = in.readChar();
            char levelBits = in.readChar();
            char subBits = in.readChar();
            if (in.readChar() != '\ufffe') {
                throw new IllegalArgumentException();
            }
            StringBuilder sb = new StringBuilder();
            while ((ch = in.readChar()) != '\uffff') {
                sb.append(ch);
            }
            String[] parts = sb.toString().split("\ufffd");
            if (parts.length != 4) {
                throw new IllegalArgumentException();
            }
            sAvatar = new CompressedText(parts[0].toCharArray(), sCreatorQuantity);
            sCreatorStrs = new CompressedText(parts[1].toCharArray(), sCreatorQuantity);
            sId = new CompressedText(parts[2].toCharArray(), sCreatorQuantity);
            sCreators = new CompressedText(parts[3].toCharArray(), sCreatorQuantity);
            sLevels = new Compressed(sCreatorQuantity, (int)levelBits);
            sSubs = new Compressed(sCreatorQuantity, (int)subBits);
            for (i = 0; i < sCreatorQuantity; ++i) {
                sb = new StringBuilder();
                while ((ch = in.readChar()) != '\uffff') {
                    sb.append(ch);
                }
                DataCreators.initCreator(i, sb.toString());
            }
            sAvatar.resetTable();
            sCreatorStrs.resetTable();
            sId.resetTable();
            sCreators.resetTable();
            sBanners = new Compressed(sCreatorQuantity, CompressedUtil.bitLength(BANNER_CODES.length));
            path = "/assets/ism/lang/banners.strexplorer";
            in = new CBInputStream(CData.class.getResourceAsStream(path));
            for (i = 0; i < sCreatorQuantity; ++i) {
                sBanners.set(i, (int)in.readChar());
            }
        }
        catch (IOException pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    private static void initCreator(int pCID, @NotNull String pText) {
        String[] parts = pText.split("\ufffe");
        sAvatar.set(pCID, parts[0]);
        sCreatorStrs.set(pCID, parts[1]);
        sId.set(pCID, parts[2]);
        sCreators.set(pCID, parts[3]);
        sLevels.set(pCID, (int)parts[4].charAt(0));
        sSubs.set(pCID, (int)parts[5].charAt(0));
    }

    static int getCreatorQuantity() {
        return sCreatorQuantity;
    }
}

