/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.database;

import de.maggicraft.ism.database.DataStructure;
import de.maggicraft.ism.database.ICreator;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.database.IStructure;
import de.maggicraft.ism.database.MData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataProject
implements IProject {
    protected final int mPID;
    @NotNull
    private final String[] mTags;
    @NotNull
    private final String mDatePosted;
    @NotNull
    private final String mTitle;
    @NotNull
    private final String mURL;
    private final int mComments;
    private final int mDiamonds;
    private final int mDownloads;
    private final int mFavorites;
    private final int mViews;
    private final boolean mIsCol;
    @NotNull
    private final String mDateUpdated;
    @Nullable
    private ArrayList<IStructure> mDataStructures;
    private String[] mContent;
    private String[] mImgTitles;
    private String[] mImgURLs;
    @Nullable
    private ICreator mCreator;
    private boolean mHasTitles;

    @Contract(pure=true)
    public DataProject(int pPID) {
        this.mPID = pPID;
        this.mTags = MData.projectTagsArr(pPID);
        this.mDownloads = MData.projectDownloads(pPID);
        this.mViews = MData.projectViews(pPID);
        this.mFavorites = MData.projectFavorites(pPID);
        this.mDiamonds = MData.projectDiamonds(pPID);
        this.mComments = MData.projectComments(pPID);
        this.mDatePosted = MData.projectPostedFormatted(this.mPID);
        this.mDateUpdated = MData.projectUpdatedFormatted(this.mPID);
        this.parseImages();
        this.mURL = MData.projectURL(pPID);
        this.mTitle = MData.projectTitle(pPID);
        this.mIsCol = MData.projectIsCollection(pPID);
    }

    private void parseImages() {
        this.mContent = MData.projectContentArr(this.mPID);
        this.mImgURLs = new String[this.mContent.length];
        this.mImgTitles = new String[this.mContent.length];
        this.mHasTitles = false;
        for (int i = 0; i < this.mContent.length; ++i) {
            String[] pic = this.mContent[i].split("\ufffb");
            this.mImgURLs[i] = pic[0];
            if (pic.length == 2 && !pic[1].isEmpty()) {
                this.mImgTitles[i] = pic[1];
                this.mHasTitles = true;
                continue;
            }
            this.mImgTitles[i] = "";
        }
    }

    @Override
    @NotNull
    public List<IStructure> getStructures() {
        if (this.mDataStructures == null) {
            String[] structures = MData.projectStructures(this.mPID);
            this.mDataStructures = new ArrayList(structures.length);
            for (String str : structures) {
                this.mDataStructures.add(new DataStructure(str, this.mIsCol));
            }
        }
        return this.mDataStructures;
    }

    @Override
    @NotNull
    public Set<String> getStructureNames() {
        HashSet<String> set = new HashSet<String>();
        for (IStructure structure : this.getStructures()) {
            set.add(structure.getName());
        }
        return set;
    }

    @Override
    @NotNull
    public ICreator getCreator() {
        if (this.mCreator == null) {
            this.mCreator = MData.getCreator(MData.creatorUnitByProject(this.mPID));
        }
        return this.mCreator;
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        DataProject that = (DataProject)pO;
        return this.mPID == that.mPID && this.mComments == that.mComments && this.mDiamonds == that.mDiamonds && this.mDownloads == that.mDownloads && this.mFavorites == that.mFavorites && this.mViews == that.mViews && this.mIsCol == that.mIsCol && this.mHasTitles == that.mHasTitles && Arrays.equals(this.getTags(), that.getTags()) && this.mDatePosted.equals(that.mDatePosted) && this.mTitle.equals(that.mTitle) && this.mURL.equals(that.mURL) && Objects.equals(this.mDateUpdated, that.mDateUpdated) && Objects.equals(this.mDataStructures, that.mDataStructures) && Arrays.equals(this.getContent(), that.getContent()) && Arrays.equals(this.getImgTitles(), that.getImgTitles()) && Arrays.equals(this.getImgURLs(), that.getImgURLs()) && Objects.equals(this.getCreator(), that.getCreator());
    }

    public int hashCode() {
        int result = Objects.hash(this.mPID, this.mDatePosted, this.mTitle, this.mURL, this.mComments, this.mDiamonds, this.mDownloads, this.mFavorites, this.mViews, this.mIsCol, this.mDateUpdated, this.mHasTitles);
        result = 31 * result + Arrays.hashCode(this.getTags());
        result = 31 * result + Arrays.hashCode(this.getContent());
        result = 31 * result + Arrays.hashCode(this.getImgTitles());
        result = 31 * result + Arrays.hashCode(this.getImgURLs());
        return result;
    }

    public String toString() {
        return "DataProject{mPID=" + this.mPID + ", mTags=" + Arrays.toString(this.mTags) + ", mDatePosted='" + this.mDatePosted + '\'' + ", mTitle='" + this.mTitle + '\'' + ", mURL='" + this.mURL + '\'' + ", mComments=" + this.mComments + ", mDiamonds=" + this.mDiamonds + ", mDownloads=" + this.mDownloads + ", mFavorites=" + this.mFavorites + ", mViews=" + this.mViews + ", mIsCol=" + this.mIsCol + ", mDateUpdated='" + this.mDateUpdated + '\'' + ", mDataStructures=" + this.mDataStructures + ", mContent=" + Arrays.toString(this.mContent) + ", mImgTitles=" + Arrays.toString(this.mImgTitles) + ", mImgURLs=" + Arrays.toString(this.mImgURLs) + ", mCreator=" + this.mCreator + ", mHasTitles=" + this.mHasTitles + '}';
    }

    @Override
    @NotNull
    public String[] getImgURLs() {
        return this.mImgURLs;
    }

    @Override
    @NotNull
    public String[] getImgTitles() {
        return this.mImgTitles;
    }

    @Override
    @NotNull
    public String[] getContent() {
        return this.mContent;
    }

    @Override
    @NotNull
    public String[] getTags() {
        return this.mTags;
    }

    @Override
    @NotNull
    public String getURL() {
        return this.mURL;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.mTitle;
    }

    @Override
    @NotNull
    public String getDatePosted() {
        return this.mDatePosted;
    }

    @Override
    @NotNull
    public String getDateUpdated() {
        return this.mDateUpdated;
    }

    @Override
    @NotNull
    public String getCreatorURL() {
        return this.getCreator().getURL();
    }

    @Override
    @NotNull
    public String getCreatorName() {
        return this.getCreator().getName();
    }

    @Override
    public int getPID() {
        return this.mPID;
    }

    @Override
    public int getComments() {
        return this.mComments;
    }

    @Override
    public int getDiamonds() {
        return this.mDiamonds;
    }

    @Override
    public int getDownloads() {
        return this.mDownloads;
    }

    @Override
    public int getFavorites() {
        return this.mFavorites;
    }

    @Override
    public int getViews() {
        return this.mViews;
    }

    @Override
    public boolean hasTitles() {
        return this.mHasTitles;
    }

    @Override
    public boolean hasUpdate() {
        return this.mDateUpdated != null;
    }

    @Override
    public boolean isCollection() {
        return this.mIsCol;
    }
}

