/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.database;

import de.maggicraft.ism.database.CData;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.mioutil.cbstream.CBInputStream;
import de.maggicraft.mioutil.compr.Compressed;
import de.maggicraft.mioutil.compr.CompressedText;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class DataProjects {
    public static final String ASSETS = "/assets/ism/";
    public static final String ASSETS_LANG = "/assets/ism/lang/";
    @NotNull
    static final Compressed[] COMPRESSEDS = new Compressed[7];
    static CompressedText sContent;
    static CompressedText sDates;
    static CompressedText sStrs;
    static CompressedText sTitles;
    static CompressedText sURL;
    static CompressedText sTags;
    static CompressedText sStrUrl;
    private static int sProjectQuantity;

    public static void init() {
        try {
            char ch;
            String path = "/assets/ism/lang/strs.strexplorer";
            CBInputStream in = new CBInputStream(CData.class.getResourceAsStream(path));
            in.readChar();
            CData.sFileID = in.readChar();
            sProjectQuantity = in.readChar();
            char commentBits = in.readChar();
            char creatorBits = in.readChar();
            char diamondBits = in.readChar();
            char downloadBits = in.readChar();
            char favoriteBits = in.readChar();
            char viewsBits = in.readChar();
            if (in.readChar() != '\ufffe') {
                throw new IllegalArgumentException();
            }
            StringBuilder sb = new StringBuilder();
            while ((ch = in.readChar()) != '\uffff') {
                sb.append(ch);
            }
            String[] parts = sb.toString().split("\ufffd");
            if (parts.length != 7) {
                throw new IllegalArgumentException();
            }
            sContent = new CompressedText(parts[0].toCharArray(), sProjectQuantity);
            sDates = new CompressedText(parts[1].toCharArray(), sProjectQuantity);
            sStrs = new CompressedText(parts[2].toCharArray(), sProjectQuantity);
            sStrUrl = new CompressedText(parts[3].toCharArray(), sProjectQuantity);
            sTags = new CompressedText(parts[4].toCharArray(), sProjectQuantity);
            sTitles = new CompressedText(parts[5].toCharArray(), sProjectQuantity);
            sURL = new CompressedText(parts[6].toCharArray(), sProjectQuantity);
            DataProjects.COMPRESSEDS[4] = new Compressed(sProjectQuantity, (int)commentBits);
            DataProjects.COMPRESSEDS[5] = new Compressed(sProjectQuantity, (int)creatorBits);
            DataProjects.COMPRESSEDS[3] = new Compressed(sProjectQuantity, (int)diamondBits);
            DataProjects.COMPRESSEDS[0] = new Compressed(sProjectQuantity, (int)downloadBits);
            DataProjects.COMPRESSEDS[2] = new Compressed(sProjectQuantity, (int)favoriteBits);
            DataProjects.COMPRESSEDS[1] = new Compressed(sProjectQuantity, (int)viewsBits);
            DataProjects.COMPRESSEDS[6] = new Compressed(sProjectQuantity, 1);
            for (int i = 0; i < sProjectQuantity; ++i) {
                sb = new StringBuilder();
                while ((ch = in.readChar()) != '\uffff') {
                    sb.append(ch);
                }
                DataProjects.initProject(i, sb.toString());
            }
            sContent.resetTable();
            sDates.resetTable();
            sStrs.resetTable();
            sTags.resetTable();
            sTitles.resetTable();
            sURL.resetTable();
            sStrUrl.resetTable();
        }
        catch (IOException pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    private static void initProject(int pPID, @NotNull String pText) {
        String[] parts = pText.split("\ufffe");
        sContent.set(pPID, parts[0]);
        sDates.set(pPID, parts[1]);
        sStrs.set(pPID, parts[2]);
        sStrUrl.set(pPID, parts[3]);
        sTags.set(pPID, parts[4]);
        sTitles.set(pPID, parts[5]);
        sURL.set(pPID, parts[6]);
        COMPRESSEDS[5].set(pPID, (int)parts[7].charAt(0));
        COMPRESSEDS[0].set(pPID, Integer.parseInt(parts[8]));
        COMPRESSEDS[1].set(pPID, Integer.parseInt(parts[9]));
        COMPRESSEDS[4].set(pPID, (int)parts[10].charAt(0));
        COMPRESSEDS[3].set(pPID, (int)parts[10].charAt(1));
        COMPRESSEDS[2].set(pPID, (int)parts[10].charAt(2));
        int col = 0;
        String str = parts[2];
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '\ufffc') continue;
            col = 1;
            break;
        }
        COMPRESSEDS[6].set(pPID, col);
    }

    public static CompressedText getTitles() {
        return sTitles;
    }

    public static CompressedText getURL() {
        return sURL;
    }

    public static CompressedText getTags() {
        return sTags;
    }

    public static int getProjectQuantity() {
        return sProjectQuantity;
    }
}

