/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.database;

import de.maggicraft.ism.database.IStructure;
import de.maggicraft.ism.world.util.Dim;
import de.maggicraft.ism.world.util.IDim;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class DataStructure
implements IStructure {
    @NotNull
    private final String mName;
    @NotNull
    private final IDim mDim;
    private final int mBlocks;

    @Contract(pure=true)
    public DataStructure(@NotNull String pName, @NotNull IDim pDim, int pBlocks) {
        this.mName = pName;
        this.mBlocks = pBlocks;
        this.mDim = pDim;
    }

    @Contract(pure=true)
    public DataStructure(@NotNull String pName, boolean pIsCol) {
        String[] parts = pName.split("\ufffb");
        this.mBlocks = Integer.parseInt(parts[0]);
        this.mDim = new Dim(parts[1].charAt(0), parts[1].charAt(1), parts[1].charAt(2));
        this.mName = parts[pIsCol ? 2 : 1];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DataStructure{");
        sb.append("mName='").append(this.mName).append('\'');
        sb.append(", mDim=").append(this.mDim);
        sb.append(", mBlocks=").append(this.mBlocks);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        DataStructure that = (DataStructure)pO;
        return this.mBlocks == that.mBlocks && this.mName.equals(that.mName) && this.mDim.equals(that.mDim);
    }

    public int hashCode() {
        return Objects.hash(this.mName, this.mDim, this.mBlocks);
    }

    @Override
    @NotNull
    public String getName() {
        return this.mName;
    }

    @Override
    @NotNull
    public IDim getDim() {
        return this.mDim;
    }

    @Override
    public int getBlocks() {
        return this.mBlocks;
    }
}

