/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.database;

import de.maggicraft.ism.database.CData;
import de.maggicraft.ism.database.DataCollection;
import de.maggicraft.ism.database.DataCreator;
import de.maggicraft.ism.database.DataCreators;
import de.maggicraft.ism.database.DataProject;
import de.maggicraft.ism.database.DataProjects;
import de.maggicraft.ism.database.ICollection;
import de.maggicraft.ism.database.ICreator;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.loader.ISMLoader;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.mgui.util.ImgUtil;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MData {
    @NotNull
    public static final ImageIcon ICON_DEFAULT_AVATAR;
    @NotNull
    private static final String[] TO_URL_REMOVE;

    private MData() {
    }

    @NotNull
    public static IProject getProject(int pPID) {
        return MData.projectIsCollection(pPID) ? MData.getCollection(pPID) : new DataProject(pPID);
    }

    @NotNull
    public static ICollection getCollection(int pPID) {
        return new DataCollection(pPID);
    }

    @NotNull
    public static ICreator getCreator(int pCID) {
        return new DataCreator(pCID);
    }

    @NotNull
    public static int[] creatorStructuresArr(int pCID) {
        String[] structures = DataCreators.sCreatorStrs.get(pCID).split("\ufffc");
        int[] strUnits = new int[structures.length];
        for (int i = 0; i < structures.length; ++i) {
            strUnits[i] = Integer.parseInt(structures[i]);
        }
        return strUnits;
    }

    public static String creatorName(int pCID) {
        return DataCreators.sCreators.get(pCID).split("\ufffc")[0];
    }

    @NotNull
    public static String creatorURL(int pCID) {
        return MData.nameToURL(MData.creatorName(pCID));
    }

    @NotNull
    private static String nameToURL(@NotNull String pName) {
        String url = pName.toLowerCase().replace(" ", "_");
        for (String str : TO_URL_REMOVE) {
            url = url.replace(str, "");
        }
        return url.replace("__", "_");
    }

    public static int creatorSubs(int pCID) {
        return DataCreators.sSubs.get(pCID);
    }

    public static int creatorLevels(int pCID) {
        return DataCreators.sLevels.get(pCID);
    }

    @Contract(pure=true)
    @NotNull
    public static String[] projectImgURLs(int pPID) {
        return DataProjects.sContent.get(pPID).split("\ufffc")[0].split("\ufffb");
    }

    @Contract(pure=true)
    @NotNull
    public static String[] projectContentArr(int pPID) {
        return DataProjects.sContent.get(pPID).split("\ufffc");
    }

    @Contract(pure=true)
    @NotNull
    public static String projectTitle(int pPID) {
        return DataProjects.sTitles.get(pPID);
    }

    @Contract(pure=true)
    @NotNull
    public static String projectURL(int pPID) {
        return DataProjects.sURL.get(pPID);
    }

    @Contract(pure=true)
    @NotNull
    public static String structureURL(int pPID) {
        return DataProjects.sStrUrl.get(pPID);
    }

    @Contract(pure=true)
    @NotNull
    public static String projectTags(int pPID) {
        return DataProjects.sTags.get(pPID);
    }

    @Contract(pure=true)
    @NotNull
    public static String[] projectTagsArr(int pPID) {
        return DataProjects.sTags.get(pPID).split("\ufffc");
    }

    @Contract(pure=true)
    @NotNull
    public static String[] projectStructures(int pPID) {
        return DataProjects.sStrs.get(pPID).split("\ufffc");
    }

    @Contract(pure=true)
    public static int projectType(int pPID) {
        return DataProjects.COMPRESSEDS[6].get(pPID);
    }

    @Contract(pure=true)
    @NotNull
    public static String projectPostedFormatted(int pPID) {
        return SharedUtil.formatDate(DataProjects.sDates.get(pPID).substring(0, 6));
    }

    @Contract(pure=true)
    @NotNull
    public static String projectUpdatedFormatted(int pPID) {
        String date = DataProjects.sDates.get(pPID);
        if (date.length() > 6) {
            return SharedUtil.formatDate(date.substring(6));
        }
        return SharedUtil.formatDate(date.substring(0, 6));
    }

    @Contract(pure=true)
    @NotNull
    public static String projectPostedRaw(int pPID) {
        return DataProjects.sDates.get(pPID).substring(0, 6);
    }

    @Contract(pure=true)
    @NotNull
    public static String projectUpdatedRaw(int pPID) {
        String date = DataProjects.sDates.get(pPID).substring(6);
        if (date.length() > 6) {
            return date.substring(6);
        }
        return date.substring(0, 6);
    }

    @Contract(pure=true)
    public static int projectDownloads(int pPID) {
        return DataProjects.COMPRESSEDS[0].get(pPID);
    }

    @Contract(pure=true)
    public static int projectViews(int pPID) {
        return DataProjects.COMPRESSEDS[1].get(pPID);
    }

    @Contract(pure=true)
    public static int projectFavorites(int pPID) {
        return DataProjects.COMPRESSEDS[2].get(pPID);
    }

    @Contract(pure=true)
    public static int projectDiamonds(int pPID) {
        return DataProjects.COMPRESSEDS[3].get(pPID);
    }

    @Contract(pure=true)
    public static int projectComments(int pPID) {
        return DataProjects.COMPRESSEDS[4].get(pPID);
    }

    @Contract(pure=true)
    public static int creatorUnitByProject(int pPID) {
        return DataProjects.COMPRESSEDS[5].get(pPID);
    }

    @Contract(pure=true)
    public static int get(int pCompressed, int pPID) {
        return DataProjects.COMPRESSEDS[pCompressed].get(pPID);
    }

    @Contract(pure=true)
    public static boolean projectIsCollection(int pPID) {
        return DataProjects.COMPRESSEDS[6].get(pPID) == 1;
    }

    public static int pidByURL(String pURL, int pPID) throws StorageException {
        String url = MData.projectURL(pPID);
        if (url.equals(pURL)) {
            return pPID;
        }
        try {
            return MData.pidByURL(pURL);
        }
        catch (StorageException pE) {
            String message = "missing project for pid: " + pPID + " and url: " + url;
            throw new StorageException(EStorageException.MISSING_PROJECT, message);
        }
    }

    public static int cidByURL(String pURL, int pCID) throws StorageException {
        String url = MData.creatorURL(pCID);
        if (url.equals(pURL)) {
            return pCID;
        }
        try {
            return MData.cidByURL(pURL);
        }
        catch (StorageException pE) {
            String message = "missing project for pid: " + pCID + " and url: " + url;
            throw new StorageException(EStorageException.MISSING_CREATOR, message);
        }
    }

    public static int pidByURL(String pURL) throws StorageException {
        for (int i = 0; i < MData.projectQuantity(); ++i) {
            if (!MData.projectURL(i).equals(pURL)) continue;
            return i;
        }
        String message = "missing project for url: " + pURL;
        throw new StorageException(EStorageException.MISSING_PROJECT, message);
    }

    public static int cidByURL(String pURL) throws StorageException {
        for (int i = 0; i < DataCreators.getCreatorQuantity(); ++i) {
            if (!MData.nameToURL(DataCreators.sCreators.get(i)).equals(pURL)) continue;
            return i;
        }
        String message = "missing creator for url: " + pURL;
        throw new StorageException(EStorageException.MISSING_CREATOR, message);
    }

    public static int totalBlocks(int ... pPIDs) {
        if (pPIDs.length == 0) {
            throw new IllegalArgumentException("too few arguments");
        }
        int total = 0;
        for (int pid : pPIDs) {
            total += MData.countBlocks(pid);
        }
        return total;
    }

    public static int countBlocks(int pPID) {
        String[] structures;
        int blocks = 0;
        for (String structure : structures = DataProjects.sStrs.get(pPID).split("\ufffc")) {
            blocks += Integer.parseInt(structure.split("\ufffb")[0]);
        }
        return blocks;
    }

    public static int totalDownloads(int ... pPIDs) {
        return MData.total(0, pPIDs);
    }

    public static int totalViews(int ... pPIDs) {
        return MData.total(1, pPIDs);
    }

    public static int totalFavorites(int ... pPIDs) {
        return MData.total(2, pPIDs);
    }

    public static int totalDiamonds(int ... pPIDs) {
        return MData.total(3, pPIDs);
    }

    public static int totalComments(int ... pPIDs) {
        return MData.total(4, pPIDs);
    }

    public static int total(int pCompressedIndex, @NotNull int[] pPIDs) {
        if (pPIDs.length == 0) {
            throw new IllegalArgumentException("too few arguments");
        }
        int res = 0;
        for (int pid : pPIDs) {
            res += DataProjects.COMPRESSEDS[pCompressedIndex].get(pid);
        }
        return res;
    }

    public static int creatorQuantity() {
        return DataCreators.getCreatorQuantity();
    }

    public static int projectQuantity() {
        return DataProjects.getProjectQuantity();
    }

    public static int getFileID() {
        return CData.getFileID();
    }

    static {
        TO_URL_REMOVE = new String[]{"/", "[", "]"};
        ISMLoader.INIT_ICON_CONSTANTS.initLazy();
        ICON_DEFAULT_AVATAR = ImgUtil.getAppIcon("default_avatar");
    }
}

