/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.favorites;

import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.favorites.IFavorite;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

@NotNull
public class Favorite
implements IFavorite {
    @NotNull
    private final String mURL;
    private final int mPID;

    public Favorite(@NotNull String pURL, int pPID) {
        this.mURL = pURL;
        this.mPID = pPID;
    }

    public Favorite(@NotNull JSONObject pJSON) throws StorageException {
        this.mURL = ReadableUtil.getString(pJSON, EFavoriteKeys.PROJECT_URL);
        this.mPID = MData.pidByURL(this.mURL, ReadableUtil.getInt(pJSON, EFavoriteKeys.PID));
    }

    public String toString() {
        return "Favorite{mURL='" + this.mURL + '\'' + ", mPID=" + this.mPID + '}';
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        Favorite favorite = (Favorite)pO;
        return this.mPID == favorite.mPID && this.mURL.equals(favorite.mURL);
    }

    public int hashCode() {
        return Objects.hash(this.mURL, this.mPID);
    }

    @Override
    @NotNull
    public String getURL() {
        return this.mURL;
    }

    @Override
    public int getPID() {
        return this.mPID;
    }

    @Override
    @NotNull
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        StorableUtil.put(json, (IUniqueID<String>)EFavoriteKeys.PID, this.mPID);
        StorableUtil.put(json, (IUniqueID<String>)EFavoriteKeys.PROJECT_URL, this.mURL);
        return json;
    }

    public static enum EFavoriteKeys implements IUID
    {
        PROJECT_URL("purl"),
        PID("pid");

        @NotNull
        private final String mUID;

        private EFavoriteKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

