/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.favorites;

import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.favorites.EFavoriteObservedOperation;
import de.maggicraft.ism.favorites.Favorite;
import de.maggicraft.ism.favorites.IFavorite;
import de.maggicraft.ism.favorites.IFavoritesManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.mcommons.event.IObserver;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mioutil.json.IReadableManager;
import de.maggicraft.mioutil.json.IStorableManager;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.io.File;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class FavoriteManager
implements IFavoritesManager,
IStorableManager<IFavorite>,
IReadableManager {
    @NotNull
    public static final String FAVORITE_FILE = "favorites.json";
    @NotNull
    private static final String FAVORITE_VERSION = "1";
    @NotNull
    private final Map<EFavoriteObservedOperation, Collection<IObserver<IFavorite>>> mObservers = new EnumMap<EFavoriteObservedOperation, Collection<IObserver<IFavorite>>>(EFavoriteObservedOperation.class);
    @NotNull
    private final File mFile;
    private Map<String, IFavorite> mFavorites;

    public FavoriteManager() {
        this.mFile = new File(MCon.appFolder(), FAVORITE_FILE);
    }

    public FavoriteManager(@NotNull String pPath) {
        this.mFile = new File(pPath, FAVORITE_FILE);
    }

    @Override
    public void initialize() {
        if (this.mFile.exists()) {
            this.read();
        } else {
            this.mFavorites = new HashMap<String, IFavorite>();
        }
    }

    @Override
    public void favor(@NotNull IProject pProject) {
        boolean favor;
        boolean bl = favor = !this.isFavorite(pProject);
        if (favor) {
            Favorite favorite = new Favorite(pProject.getURL(), pProject.getPID());
            this.mFavorites.put(pProject.getURL(), favorite);
            this.notifyObservers(EFavoriteObservedOperation.FAVORITE_ADDED, favorite);
        } else {
            IFavorite favorite = this.mFavorites.remove(pProject.getURL());
            if (favorite != null) {
                this.notifyObservers(EFavoriteObservedOperation.FAVORITE_REMOVED, favorite);
            }
        }
        this.store();
    }

    @Override
    public boolean isFavorite(@NotNull IProject pProject) {
        return this.mFavorites.get(pProject.getURL()) != null;
    }

    @Override
    public void storeHeader(@NotNull JSONObject pJSON) {
        StorableUtil.put(pJSON, (IUniqueID<String>)EManagerKey.VERSION, FAVORITE_VERSION);
    }

    @Override
    public void readHeader(@NotNull JSONObject pJSON) {
        String version = ReadableUtil.getString(pJSON, EManagerKey.VERSION);
        if (!version.equals(FAVORITE_VERSION)) {
            throw new IllegalArgumentException("version \"" + version + "\" not support");
        }
    }

    @Override
    public void readEntities(@NotNull JSONArray pJSONArray) {
        this.mFavorites = new HashMap<String, IFavorite>(pJSONArray.size() + 2);
        for (Object object : pJSONArray) {
            try {
                Favorite favorite = new Favorite((JSONObject)object);
                this.mFavorites.put(favorite.getURL(), favorite);
            }
            catch (StorageException pE) {
                ISMContainer.getLogger().log(pE);
            }
        }
    }

    @Override
    @NotNull
    public Map<EFavoriteObservedOperation, Collection<IObserver<IFavorite>>> getObservers() {
        return this.mObservers;
    }

    @Override
    @NotNull
    public Collection<IFavorite> getStorables() {
        return this.mFavorites.values();
    }

    @Override
    @NotNull
    public Collection<IFavorite> getFavorites() {
        return this.mFavorites.values();
    }

    @Override
    @NotNull
    public File getFile() {
        return this.mFile;
    }

    public static enum EManagerKey implements IUID
    {
        VERSION("vers");

        @NotNull
        private final String mUID;

        private EManagerKey(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

