/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui;

import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import org.jetbrains.annotations.NotNull;

public class MMenuButtonHorizontal
extends MButton {
    private boolean mActivated;

    MMenuButtonHorizontal(@NotNull MMPos pPos, @NotNull ActionListener pListener) {
        super(pPos, null);
        this.addAction(pListener);
        this.setForeground(MCon.colorText());
        this.setFont(MCon.fontTitle());
        this.setBorder(null);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent pEvent) {
                MMenuButtonHorizontal.this.setForeground(MCon.colorText().brighter());
            }

            @Override
            public void mouseExited(MouseEvent pEvent) {
                MMenuButtonHorizontal.this.setForeground(MCon.colorText());
            }
        });
    }

    @Override
    public int prefWidth() {
        return super.prefWidth() - 16;
    }

    @Override
    protected void paintComponent(@NotNull Graphics pG) {
        pG.setColor(MCon.colorFrame());
        pG.fillRect(0, 0, this.getWidth(), this.getHeight() - 3);
        if (this.mActivated) {
            pG.setColor(MCon.colorAccent());
            if (this.getPos() != null && this.getPos().isPrefH()) {
                int width = this.getPos().getPrefWidth() - 50 + 20;
                pG.fillRect(15, this.getHeight() - 3, width, 3);
            } else {
                pG.fillRect(0, this.getHeight() - 3, this.getWidth(), 3);
            }
        }
        super.paintComponent(pG);
    }

    void setActivated(boolean pActivated) {
        this.mActivated = pActivated;
    }
}

