/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui;

import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.schemes.types.MSchemeFont;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class MMenuButtonVertical
extends MButton {
    static final String[] MENU_TITLES = new String[]{"browse", "projectLists", "faved", "tutor", "set", "scanStr", "placeStr", "reposStr", "removeStr", "placeShape", "placed", "strs", "col", "cres", "loc"};
    static final MISMView[] MENU_VIEWS = new MISMView[]{ViewManager.VIEW_BROWSE, ViewManager.VIEW_PROJECT_LISTS, ViewManager.VIEW_FAVORITES, ViewManager.VIEW_TUTORIALS, ViewManager.VIEW_SETTINGS, ViewManager.VIEW_SCAN_STRUCTURE, ViewManager.VIEW_PLACE_STRUCTURE, ViewManager.VIEW_REPOS_STRUCTURE, ViewManager.VIEW_REMOVE_STRUCTURE, ViewManager.VIEW_PLACE_SHAPE, ViewManager.VIEW_PLACED, ViewManager.VIEW_PROJECTS, ViewManager.VIEW_COLLECTIONS, ViewManager.VIEW_CREATORS, ViewManager.VIEW_LOCAL_STRUCTURES};
    static final Font FONT = MSchemeFont.font(15, 1);
    private boolean mActivated;

    MMenuButtonVertical(@NotNull MMPos pPos, int pIndex) {
        super(pPos, null);
        this.addAction(pEvent -> ViewManager.displayLeftMenu(MENU_VIEWS[pIndex]));
        this.setHorizontalAlignment(10);
        this.setForeground(MCon.colorText());
        this.setFont(FONT);
        this.setBorder(null);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent pEvent) {
                MMenuButtonVertical.this.setForeground(MCon.colorText().brighter());
            }

            @Override
            public void mouseExited(MouseEvent pEvent) {
                MMenuButtonVertical.this.setForeground(MCon.colorText());
            }
        });
        this.title(MENU_TITLES[pIndex]);
    }

    @Override
    protected void paintComponent(@NotNull Graphics pG) {
        if (this.getModel().isPressed()) {
            pG.setColor(MCon.colorButtonPressed());
        } else if (this.getModel().isRollover()) {
            pG.setColor(MCon.colorButtonHover());
        } else {
            pG.setColor(this.mActivated ? MCon.colorButtonHover() : MCon.colorFrame());
        }
        pG.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.mActivated) {
            pG.setColor(MCon.colorAccent());
            pG.fillRect(0, 0, 5, this.getHeight());
        }
        super.paintComponent(pG);
    }

    void setActivated(boolean pActivated) {
        this.mActivated = pActivated;
    }
}

