/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui;

import de.maggicraft.ism.analytics.trackers.TrackView;
import de.maggicraft.mgui.view.MDialog;
import de.maggicraft.mgui.view.util.EWindowSize;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public abstract class MTrackableDialog
extends MDialog {
    @NotNull
    private final AtomicBoolean mClosed = new AtomicBoolean(false);
    private long mTimeInit;
    private long mTimeTMP;

    public MTrackableDialog(@NotNull Frame pOwner, @NotNull EWindowSize pWindowSize) {
        super(pOwner, pWindowSize);
        this.listeners();
    }

    @Override
    protected void beforeInit() {
        this.mTimeInit = System.currentTimeMillis();
    }

    @Override
    public void afterInit() {
    }

    protected void afterDisplay() {
        this.mTimeInit = System.currentTimeMillis() - this.mTimeInit;
        this.toFront();
    }

    @NotNull
    protected abstract String getURI();

    private void listeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent pEvent) {
                MTrackableDialog.this.push();
            }

            @Override
            public void windowClosed(WindowEvent pEvent) {
                MTrackableDialog.this.push();
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent pEvent) {
                MTrackableDialog.this.focus(true);
            }

            @Override
            public void windowLostFocus(WindowEvent pEvent) {
                MTrackableDialog.this.focus(false);
            }
        });
    }

    private synchronized void focus(boolean pIsFocused) {
        if (pIsFocused) {
            this.mTimeTMP = System.currentTimeMillis();
        } else if (this.mTimeTMP != 0L) {
            this.mTimeTMP = 0L;
        }
    }

    private void push() {
        if (this.mClosed.compareAndSet(false, true)) {
            return;
        }
        this.focus(false);
        TrackView.trackView(this.getURI());
    }
}

