/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui;

import de.maggicraft.ism.analytics.trackers.TrackControlledPage;
import de.maggicraft.ism.analytics.util.EUTMView;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.view.MPanel;
import de.maggicraft.mgui.view.MView;
import java.awt.Color;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class MViewStatus
extends MPanel {
    @NotNull
    private static final Color COLOR_GREEN = new Color(40, 140, 0);
    private static final int HEIGHT_UPDATE = 35;
    @NotNull
    private static final ConcurrentLinkedQueue<Runnable> QUEUE = new ConcurrentLinkedQueue();
    private static MViewStatus sInstance;
    @NotNull
    private final AtomicBoolean mIsSessionActive = new AtomicBoolean(false);
    private AtomicInteger mAddedStructures;
    private AtomicInteger mAllStructures;
    @NotNull
    private final MView mView;
    @NotNull
    private final MButton mUpdate;
    @NotNull
    private final MText mDownload;
    private boolean mUpdateShown = false;
    private boolean mDownloadShown = false;
    private int mPosHeight;

    public MViewStatus(MView pView, @NotNull MPos pPos) {
        super(pPos, MCon.colorFrame());
        this.mView = pView;
        new MPanel(MPos.pos(this, "[[<>m<>,[[<>1<>"), MCon.colorTitleLine());
        this.mUpdate = new MButton(MPos.pos(this, "[[<>m,]]<>35<15>")).addAction(pEvent -> TrackControlledPage.utmURLAction("", "", EUTMView.VIEW_UPDATE)).text("Update ISM");
        this.mDownload = new MText(MPos.pos(this, "[[m,[[p"));
        this.mUpdate.setVisible(false);
        this.mDownload.setVisible(false);
        sInstance = this;
        for (Runnable runnable : QUEUE) {
            runnable.run();
        }
    }

    public static void downloadAdding(int pStrQuantity) {
        if (sInstance == null) {
            QUEUE.add(() -> sInstance.downloadAddingImpl(pStrQuantity));
        } else {
            sInstance.downloadAddingImpl(pStrQuantity);
        }
    }

    public static void downloadAdded() {
        if (sInstance == null) {
            QUEUE.add(() -> sInstance.downloadAddedImpl());
        } else {
            sInstance.downloadAddedImpl();
        }
    }

    public static void showUpdate() {
        if (sInstance == null) {
            QUEUE.add(() -> sInstance.showUpdateImpl());
        } else {
            sInstance.showUpdateImpl();
        }
    }

    private void showUpdateImpl() {
        this.mUpdateShown = true;
        this.mUpdate.setVisible(true);
        this.mView.update();
    }

    private void downloadAddingImpl(int pStrQuantity) {
        if (pStrQuantity < 1) {
            throw new IllegalArgumentException("can't add negative quantity of structures");
        }
        if (!this.mIsSessionActive.get()) {
            this.mIsSessionActive.set(true);
            this.mAddedStructures = new AtomicInteger();
            this.mAllStructures = new AtomicInteger();
            this.mDownloadShown = true;
            this.mDownload.setVisible(true);
            this.mView.update();
        }
        this.mAllStructures.addAndGet(pStrQuantity);
        this.downloadUpdateDisplay();
    }

    private void downloadAddedImpl() {
        this.mAddedStructures.incrementAndGet();
        this.downloadUpdateDisplay();
    }

    private void downloadUpdateDisplay() {
        if (this.mDownload != null) {
            this.mDownload.text(this.downloadUpdateText());
            this.update();
        }
        if (this.mAddedStructures.get() == this.mAllStructures.get()) {
            this.downloadClear();
        } else if (this.mDownload != null) {
            this.mDownload.setForeground(MCon.colorText());
        }
        this.update();
    }

    private void downloadClear() {
        if (this.mDownload != null) {
            this.mDownload.setForeground(COLOR_GREEN);
        }
        this.mIsSessionActive.set(false);
        new Thread(() -> {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException pE) {
                ISMContainer.getLogger().log(pE);
            }
            if (!this.mIsSessionActive.get() && this.mDownload != null) {
                this.mDownload.text("");
                this.mDownloadShown = false;
                this.mDownload.setVisible(true);
                this.mView.update();
            }
        }).start();
    }

    public String downloadUpdateText() {
        if (this.mAddedStructures.get() == this.mAllStructures.get()) {
            if (this.mAllStructures.get() == 1) {
                return MLangManager.get("addedOne");
            }
            return MLangManager.rep("addedMultiple", this.mAllStructures);
        }
        if (this.mAllStructures.get() == 1) {
            return MLangManager.get("addingOne");
        }
        return MLangManager.rep("addingMultiple", this.mAddedStructures, this.mAllStructures);
    }

    @Override
    public void setBounds(int pX, int pY, int pWidth, int pHeight) {
        pHeight = !this.mUpdateShown && !this.mDownloadShown ? (short)0 : MCon.defaultGap();
        if (this.mUpdateShown && this.mDownloadShown) {
            pHeight += MCon.defaultGap();
        }
        if (this.mUpdateShown) {
            pHeight += 35 + MCon.defaultGap();
        }
        if (this.mDownloadShown && this.mDownload.getPos() != null) {
            pHeight += this.mDownload.getPos().getPrefHeight() + MCon.defaultGap();
        }
        if (this.mView.getY() <= 0) {
            pY = this.mPosHeight - pHeight - this.mView.getY();
        }
        super.setBounds(pX, pY, pWidth, pHeight);
    }

    void setPosHeight(int pPosHeight) {
        this.mPosHeight = pPosHeight;
    }
}

