/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui;

import de.maggicraft.ism.analytics.trackers.TrackExternalPage;
import de.maggicraft.ism.analytics.util.EUTMExternal;
import de.maggicraft.ism.database.ICollection;
import de.maggicraft.ism.database.ICreator;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.gui.CSharedCon;
import de.maggicraft.ism.gui.IFunction;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.storage.StorageManagerWrapper;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.menu.MMenu;
import de.maggicraft.mgui.menu.MMenuItem;
import de.maggicraft.mgui.menu.MPopupMenu;
import de.maggicraft.mgui.schemes.types.MSchemeFont;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mgui.util.Util;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class SharedUtil {
    @NotNull
    public static final ImageIcon ICON_PLACE = ImgUtil.getAppIcon("place");
    @NotNull
    public static final ImageIcon ICON_PLACE_HOVER = ImgUtil.getAppIcon("place_hover");
    @NotNull
    public static final ImageIcon ICON_PLACE_PRESSED = ImgUtil.getAppIcon("place_pressed");
    @NotNull
    public static final SimpleDateFormat DATE_FORMAT_FROM = new SimpleDateFormat("yyMMdd");
    @NotNull
    public static final SimpleDateFormat DATE_FORMAT_TO = new SimpleDateFormat("yyyy-MM-dd");
    @NotNull
    private static final SimpleDateFormat DATE_FORMAT_EXACT = new SimpleDateFormat("yyyy-MM-dd, kk:mm:ss");
    @NotNull
    private static final String URL_BASE = "https://www.planetminecraft.com/";
    @NotNull
    public static final String URL_PROJECT = "https://www.planetminecraft.com/project/";
    @NotNull
    public static final String URL_CRE = "https://www.planetminecraft.com/member/";
    @NotNull
    private static final Font FONT = MSchemeFont.font(15);
    @NotNull
    private static final Font FONT_HOVER = MSchemeFont.fontUnderline(FONT);

    private SharedUtil() {
    }

    public static void openProject(@NotNull IProject pProject, @NotNull EUTMExternal pUTM) {
        Util.openURL(URL_PROJECT + pProject.getURL());
        TrackExternalPage.trackExternalPage("pmc/project/" + pProject.getURL(), pProject.getTitle(), pUTM);
    }

    public static void openCreator(@NotNull ICreator pCreator, @NotNull EUTMExternal pUTM) {
        Util.openURL(URL_CRE + pCreator.getURL());
        TrackExternalPage.trackExternalPage("pmc/creator/" + pCreator.getURL(), pCreator.getName(), pUTM);
    }

    public static void addLink(final @NotNull JTextArea pText, final @NotNull Runnable pAction) {
        pText.setCursor(CSharedCon.CURSOR_HAND);
        pText.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent pEvent) {
                pAction.run();
            }

            @Override
            public void mouseEntered(MouseEvent pEvent) {
                pText.setFont(FONT_HOVER);
            }

            @Override
            public void mouseExited(MouseEvent pEvent) {
                pText.setFont(FONT);
            }
        });
    }

    @Contract(pure=true)
    public static synchronized String formatDate(@NotNull String pDate) {
        try {
            return DATE_FORMAT_TO.format(DATE_FORMAT_FROM.parse(pDate));
        }
        catch (ParseException pE) {
            ISMContainer.getLogger().log(pE);
            return pDate;
        }
    }

    @NotNull
    public static synchronized String formatExactDate(@NotNull Date pDate) {
        return DATE_FORMAT_EXACT.format(pDate);
    }

    @NotNull
    public static synchronized String formatDate(@NotNull Date pDate) {
        return DATE_FORMAT_TO.format(pDate);
    }

    public static String lang(@NotNull String pKey, String ... pAppend) {
        String text = MLangManager.get(pKey) + ": ";
        for (String s : pAppend) {
            text = text + s;
        }
        return text;
    }

    @NotNull
    public static Optional<BufferedImage> loadThumbnail(int pPID) {
        return SharedUtil.loadThumbnail(MData.projectImgURLs(pPID)[0]);
    }

    @NotNull
    public static Optional<BufferedImage> loadThumbnail(@NotNull String pURL) {
        Optional<BufferedImage> img = SharedUtil.loadImg("https://static.planetminecraft.com/files/resource_media/screenshot/" + pURL.substring(0, pURL.indexOf(46)) + "_thumb.jpg");
        if (img.isPresent()) {
            return img;
        }
        return SharedUtil.loadImg("https://static.planetminecraft.com/files/resource_media/screenshot/" + pURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Optional<BufferedImage> loadImg(@NotNull String pURL) {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)new URL(pURL).openConnection();
            urlConnection.addRequestProperty("User-Agent", "Mozilla/4.76");
            InputStream is = urlConnection.getInputStream();
            Optional<BufferedImage> optional = Optional.of(ImageIO.read(is));
            return optional;
        }
        catch (IOException iOException) {
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return Optional.empty();
    }

    @NotNull
    public static MPopupMenu moreStr(@NotNull IProject pProject, @NotNull Container pCon, boolean pToProject, boolean pShowCre) {
        MPopupMenu menu = new MPopupMenu();
        String titleFav = ISMContainer.getFavoritesManager().isFavorite(pProject) ? "remFav" : "addFav";
        MMenuItem menuFav = new MMenuItem(pEvent -> ISMContainer.getFavoritesManager().favor(pProject)).title(titleFav);
        menu.add(menuFav);
        SharedUtil.menuPlaceStructure(menu, pProject);
        MMenuItem menuAdd = new MMenuItem(pEvent -> StorageManagerWrapper.toggleProject(pEvent, pProject));
        menu.addMenuListener(() -> {
            menuFav.title(ISMContainer.getFavoritesManager().isFavorite(pProject) ? "remFav" : "addFav");
            menuAdd.title(ISMContainer.getStorageManager().isProjectAdded(pProject) ? "remLib" : "addLib");
        });
        menu.add(menuAdd);
        menu.addSep();
        EUTMExternal utm = pShowCre ? EUTMExternal.EXT_MENU_CRE : EUTMExternal.EXT_MENU_PROJECT;
        SharedUtil.menuCreator(menu, pProject, utm, pShowCre);
        menu.addSep();
        SharedUtil.menuProject(menu, pProject, utm, pToProject);
        menu.addToContainer(pCon);
        return menu;
    }

    private static void menuPlaceStructure(@NotNull MPopupMenu pMenu, @NotNull IProject pProject) {
        if (pProject instanceof ICollection) {
            ICollection collection = (ICollection)pProject;
            MMenu subPlace = pMenu.addSub(MLangManager.get("me.place"));
            for (int i = 0; i < collection.getQuan(); ++i) {
                String name = collection.getName(i);
                subPlace.add(new MMenuItem(pEvent -> StorageManagerWrapper.displayPlaceStructure(pEvent, collection, name)).text(MLangManager.get("me.plc") + ' ' + name));
            }
        } else {
            MMenuItem item = new MMenuItem(pEvent -> StorageManagerWrapper.displayPlaceStructure(pEvent, pProject)).title("place");
            pMenu.add(item);
        }
    }

    private static void menuCreator(@NotNull MPopupMenu pMenu, @NotNull IProject pProject, @NotNull EUTMExternal pUTM, boolean pShowCre) {
        MMenuItem openCreator = new MMenuItem(pEvent -> SharedUtil.openCreator(pProject.getCreator(), pUTM));
        openCreator.text(MLangManager.get("me.openCre1") + ' ' + pProject.getCreatorName() + MLangManager.get("me.openCre2"));
        pMenu.add(openCreator);
        if (!pShowCre) {
            MMenuItem itemOpen = new MMenuItem(pEvent -> ViewManager.displayDetail(pProject.getCreator()));
            itemOpen.text(MLangManager.get("me.goCre") + ' ' + pProject.getCreatorName());
            pMenu.add(itemOpen);
        }
    }

    private static void menuProject(@NotNull MPopupMenu pMenu, @NotNull IProject pProject, @NotNull EUTMExternal pUTM, boolean pToProject) {
        pMenu.add(new MMenuItem(pEvent -> SharedUtil.openProject(pProject, pUTM)).title("openProj"));
        if (pToProject) {
            pMenu.add(new MMenuItem(pEvent -> ViewManager.displayDetail(pProject)).title("goProj"));
        }
    }

    public static <R> R loadResource(@NotNull String pURL, IFunction<InputStream, R> pFunction, R pDefaultValue) {
        try {
            URL url = new URL(pURL);
            return SharedUtil.loadResource(url, pFunction, pDefaultValue);
        }
        catch (MalformedURLException pE) {
            ISMContainer.getLogger().log(pE);
            return pDefaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R loadResource(@NotNull URL pURL, IFunction<InputStream, R> pFunction, R pDefaultValue) {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)pURL.openConnection();
            urlConnection.addRequestProperty("User-Agent", "Mozilla/4.76");
            InputStream inputStream = urlConnection.getInputStream();
            R returnValue = pFunction.apply(inputStream);
            inputStream.close();
            R r = returnValue;
            return r;
        }
        catch (UnknownHostException pE) {
            ISMContainer.getLogger().log("no connection for URL \"" + pURL.getPath() + '\"', pE);
        }
        catch (FileNotFoundException pE) {
            ISMContainer.getLogger().log("file not found for URL \"" + pURL.getPath() + '\"', pE);
        }
        catch (SocketTimeoutException pE) {
            ISMContainer.getLogger().log("timeout for URL\"" + pURL.getPath() + '\"', pE);
        }
        catch (Exception pE) {
            ISMContainer.getLogger().log(pE);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return pDefaultValue;
    }
}

