/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui;

import de.maggicraft.ism.analytics.manager.MAnalyticsUtil;
import de.maggicraft.ism.analytics.trackers.TrackClose;
import de.maggicraft.ism.analytics.trackers.TrackResolution;
import de.maggicraft.ism.app_state.EAppState;
import de.maggicraft.ism.app_state.ISMCloseDialog;
import de.maggicraft.ism.gui.MLeftMenu;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.view.MDialog;
import de.maggicraft.mgui.view.MFrame;
import de.maggicraft.mgui.view.MScroll;
import de.maggicraft.mgui.view.MSplit;
import de.maggicraft.mgui.view.util.EWindowSize;
import de.maggicraft.mgui.view.util.MWinStore;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class StrExplorerWindow
extends MFrame {
    @NotNull
    public static final String SET_NAME = "MainFrame";
    @NotNull
    private final Semaphore mLock = new Semaphore(1);
    @NotNull
    private final AtomicBoolean mIsActivate = new AtomicBoolean(false);
    private MSplit mSplit;
    private MLeftMenu mMenu;

    public StrExplorerWindow() {
        super(new MWinStore(4).start(EWindowSize.SIX).store(SET_NAME).addSetting(CSettings.SET_NAME), true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent pE) {
                if (ISMContainer.getMCSideState().getState() == EAppState.CLOSED) {
                    StrExplorerWindow.this.mIsActivate.set(false);
                    ViewManager.pushLastEvent();
                    System.exit(0);
                } else if (((Boolean)CSettings.SETTING_WARN_CLOSE_ISM.getValue()).booleanValue()) {
                    TrackClose.trackCloseEvent(TrackClose.ECloseType.CLOSE_ISM_KEEP_MC);
                    ISMContainer.getISMSideState().appClosed();
                    StrExplorerWindow.this.mIsActivate.set(false);
                    ViewManager.pushLastEvent();
                    System.exit(0);
                } else {
                    MDialog dialog = new ISMCloseDialog().visible();
                    SwingUtilities.invokeLater(dialog::toFront);
                }
            }
        });
        final TrackResolution trackResolution = new TrackResolution();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent pEvent) {
                trackResolution.trackResolution();
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent pEvent) {
                ISMContainer.getAnalyticsManager().getViewEventStack().focus(true);
            }

            @Override
            public void windowLostFocus(WindowEvent pEvent) {
                ISMContainer.getAnalyticsManager().getViewEventStack().focus(false);
            }
        });
        this.setDefaultCloseOperation(0);
    }

    public void openLazy() {
        SwingUtilities.invokeLater(() -> {
            try {
                this.mLock.acquire();
            }
            catch (InterruptedException pE) {
                ISMContainer.getLogger().log(pE);
            }
            if (this.mIsActivate.getAndSet(true)) {
                this.toFront();
            } else {
                MAnalyticsUtil.consentDialog();
            }
            this.mLock.release();
        });
    }

    public boolean isDisplayed() {
        return this.mIsActivate.get();
    }

    @Override
    public void init(@NotNull MFrame pView) {
        this.title("mainFrame");
        this.mSplit = new MSplit(MPos.pos(pView, "||<>m<>,||<>m<>"), MLeftMenu.getPrefWidth()){

            @Override
            public void setDividerLocation(int pLocation) {
                super.setDividerLocation(Math.min(MLeftMenu.getPrefWidth(), pLocation));
            }
        }.name("split");
        this.mMenu = new MLeftMenu(this.mSplit);
        MScroll scroll = new MScroll(MPos.pos(this.mSplit, "||<>m<>,||<>m<>")).name("scrollRight");
        ViewManager.init(scroll, this.mMenu);
        this.mSplit.addComp(this.mMenu, scroll, true);
    }

    @Override
    public void afterInit() {
        ViewManager.displayLeftMenu(ViewManager.VIEW_BROWSE);
        new Thread(() -> {
            for (int i = 0; i < 4; ++i) {
                try {
                    Thread.sleep(i * 75);
                }
                catch (InterruptedException pE) {
                    ISMContainer.getLogger().log(pE);
                }
                this.mSplit.resetToPreferredSizes();
            }
        }).start();
    }

    public MLeftMenu getLeftMenu() {
        return this.mMenu;
    }
}

