/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui;

import de.maggicraft.ism.database.ICreator;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.IViewManager;
import de.maggicraft.ism.gui.MLeftMenu;
import de.maggicraft.ism.gui.MTrackableDialogs;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.project_lists.MDetailProjectListsView;
import de.maggicraft.ism.project_lists.MProjectListsView;
import de.maggicraft.ism.search.SearchManager;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.str.IReadableStructure;
import de.maggicraft.ism.views.ITrackableView;
import de.maggicraft.ism.views.IViewDeinit;
import de.maggicraft.ism.views.IViewPos;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.ism.views.MViewBrowse;
import de.maggicraft.ism.views.MViewCollections;
import de.maggicraft.ism.views.MViewCreators;
import de.maggicraft.ism.views.MViewDetailCreator;
import de.maggicraft.ism.views.MViewDetailProject;
import de.maggicraft.ism.views.MViewFavorites;
import de.maggicraft.ism.views.MViewLocals;
import de.maggicraft.ism.views.MViewPlaceShape;
import de.maggicraft.ism.views.MViewPlaceStructure;
import de.maggicraft.ism.views.MViewPlaced;
import de.maggicraft.ism.views.MViewProjects;
import de.maggicraft.ism.views.MViewRemoveStructure;
import de.maggicraft.ism.views.MViewReposStructure;
import de.maggicraft.ism.views.MViewScanStructure;
import de.maggicraft.ism.views.MViewSearchRes;
import de.maggicraft.ism.views.MViewSettings;
import de.maggicraft.ism.views.MViewTutorials;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mgui.view.MScroll;
import de.maggicraft.mgui.view.MView;
import java.util.EnumMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewManager
implements IViewManager {
    public static final SearchManager SEARCH_MANAGER = new SearchManager();
    public static final MViewBrowse VIEW_BROWSE = new MViewBrowse();
    public static final MViewCollections VIEW_COLLECTIONS = new MViewCollections();
    public static final MViewCreators VIEW_CREATORS = new MViewCreators();
    public static final MViewDetailCreator VIEW_DETAIL_CREATOR = new MViewDetailCreator();
    public static final MViewDetailProject VIEW_DETAIL_PROJECT = new MViewDetailProject();
    public static final MDetailProjectListsView VIEW_DETAIL_PROJECT_LIST = new MDetailProjectListsView();
    public static final MViewFavorites VIEW_FAVORITES = new MViewFavorites();
    public static final MViewLocals VIEW_LOCAL_STRUCTURES = new MViewLocals();
    public static final MViewPlaced VIEW_PLACED = new MViewPlaced();
    public static final MViewPlaceShape VIEW_PLACE_SHAPE = new MViewPlaceShape();
    public static final MViewPlaceStructure VIEW_PLACE_STRUCTURE = new MViewPlaceStructure();
    public static final MViewRemoveStructure VIEW_REMOVE_STRUCTURE = new MViewRemoveStructure();
    public static final MViewReposStructure VIEW_REPOS_STRUCTURE = new MViewReposStructure();
    public static final MViewScanStructure VIEW_SCAN_STRUCTURE = new MViewScanStructure();
    public static final MViewSearchRes VIEW_SEARCH_RES = new MViewSearchRes();
    public static final MViewSettings VIEW_SETTINGS = new MViewSettings();
    public static final MProjectListsView VIEW_PROJECT_LISTS = new MProjectListsView();
    public static final MViewProjects VIEW_PROJECTS = new MViewProjects();
    public static final MViewTutorials VIEW_TUTORIALS = new MViewTutorials();
    private static final MISMView[] VIEWS = new MISMView[]{VIEW_BROWSE, VIEW_COLLECTIONS, VIEW_CREATORS, VIEW_DETAIL_CREATOR, VIEW_DETAIL_PROJECT, VIEW_DETAIL_PROJECT_LIST, VIEW_FAVORITES, VIEW_LOCAL_STRUCTURES, VIEW_PLACED, VIEW_PLACE_SHAPE, VIEW_PLACE_STRUCTURE, VIEW_REMOVE_STRUCTURE, VIEW_REPOS_STRUCTURE, VIEW_SCAN_STRUCTURE, VIEW_SEARCH_RES, VIEW_SETTINGS, VIEW_PROJECT_LISTS, VIEW_PROJECTS, VIEW_TUTORIALS};
    private static final MISMView[] UPDATE_VIEWS = new MISMView[]{VIEW_SCAN_STRUCTURE, VIEW_PLACE_STRUCTURE, VIEW_REPOS_STRUCTURE, VIEW_REMOVE_STRUCTURE, VIEW_PLACE_SHAPE, VIEW_PLACED};
    private static MScroll sScroll;
    private static MLeftMenu sLeftMenu;
    @Nullable
    private static ITrackableView sLast;
    private final EnumMap<EView, MISMView> mViews = new EnumMap(EView.class);

    public ViewManager() {
        for (MISMView view : VIEWS) {
            this.mViews.put(view.getView(), view);
        }
    }

    public static void updateView() {
        for (MISMView view : UPDATE_VIEWS) {
            if (!ViewManager.isCurrent(view)) continue;
            ViewManager.displayLeftMenu(view);
        }
    }

    public static void init(@NotNull MScroll pScroll, @NotNull MLeftMenu pLeftMenu) {
        sScroll = pScroll;
        sLeftMenu = pLeftMenu;
        sScroll.addViews(VIEWS);
    }

    public static void displayFrame(@NotNull MISMView pView) {
        ISMContainer.getStrExplorer().openLazy();
        SwingUtilities.invokeLater(() -> ViewManager.displayLeftMenu(pView));
    }

    public static void displayDetail(ICreator pCreator) {
        VIEW_DETAIL_CREATOR.setCreator(pCreator);
        ViewManager.displayLeftMenu(VIEW_DETAIL_CREATOR);
    }

    public static void displayDetail(IProject pProject) {
        VIEW_DETAIL_PROJECT.setProject(pProject);
        ViewManager.displayLeftMenu(VIEW_DETAIL_PROJECT);
    }

    public static void displayPlaceStr(IReadableStructure pReadableStructure) throws StorageException {
        VIEW_PLACE_STRUCTURE.setPlaceable(pReadableStructure);
        ViewManager.displayLeftMenu(VIEW_PLACE_STRUCTURE);
    }

    public static void displayLeftMenu(@NotNull MISMView pView, Object pMode) {
        ViewManager.handleViewEvent(pView);
        sLeftMenu.updateAccent(pView);
        sScroll.displayView(pView, pMode);
    }

    public static void displayLeftMenu(@NotNull MISMView pView) {
        ViewManager.handleViewEvent(pView);
        sLeftMenu.updateAccent(pView);
        sScroll.displayView(pView);
    }

    public static synchronized void handleViewEvent(@NotNull ITrackableView pView) {
        if (sLast != null) {
            sLast.getViewEvent().setURL(sLast.getURI());
        }
        sLast = pView;
        pView.eventInit();
        ISMContainer.getAnalyticsManager().getViewEventStack().addView(pView.getViewEvent());
    }

    public static void pushLastEvent() {
        sLast.getViewEvent().setURL(sLast.getURI());
        ISMContainer.getAnalyticsManager().getViewEventStack().addView(null);
        sLast = null;
    }

    public static boolean isCurrent(@NotNull MView pView) {
        return sScroll.getCurView() == pView;
    }

    public static MScroll getScroll() {
        return sScroll;
    }

    @Override
    public boolean isCurrent(@NotNull EView pView) {
        return sScroll.getCurView() == this.mViews.get(pView);
    }

    @Override
    public void setPos(@NotNull EView pView, @NotNull IPos pPos, int pDir) {
        MISMView view = this.mViews.get(pView);
        if (!(view instanceof IViewPos)) {
            throw new IllegalArgumentException("no instance of IViewPos");
        }
        ((IViewPos)((Object)view)).setPos(pPos, pDir);
    }

    @Override
    public void setPosGreen(@NotNull IPos pPos) {
        VIEW_SCAN_STRUCTURE.setPosGreen(pPos);
    }

    @Override
    public void setPosRed(@NotNull IPos pPos) {
        VIEW_SCAN_STRUCTURE.setPosRed(pPos);
    }

    @Override
    public void makeNote(@NotNull String pText, @NotNull String pURI) {
        MTrackableDialogs.makeNote(ISMContainer.getStrExplorer().getFrame(), pText, pURI);
    }

    @Override
    public void deinitializeObjects(@NotNull EView pView) {
        MISMView view = this.mViews.get(pView);
        if (!(view instanceof IViewDeinit)) {
            throw new IllegalArgumentException("no instance of IViewPlaced");
        }
        ((IViewDeinit)((Object)view)).deinitializeObjects();
    }

    @Override
    public void displayFrame(@NotNull EView pView) {
        ViewManager.displayFrame(this.mViews.get(pView));
    }

    @Override
    public void displayLeftMenu(@NotNull EView pView) {
        ViewManager.displayFrame(this.mViews.get(pView));
    }

    @Override
    public void displayLeftMenu(@NotNull EView pView, int pMode) {
        ViewManager.displayLeftMenu(this.mViews.get(pView), pMode);
    }

    static {
        sLast = null;
    }
}

