/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui;

import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.IViewManagerServer;
import de.maggicraft.ism.gui.IViewManagerWrapper;
import de.maggicraft.ism.loader.MCContainer;
import de.maggicraft.ism.world.util.IPos;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewManagerWrapper
implements IViewManagerWrapper {
    private IViewManagerServer mViewManager;

    @Override
    public void initialize() {
        try {
            MCContainer.getISMLoaderServer().requiredViewManager();
            this.mViewManager = (IViewManagerServer)MCContainer.getRegistry().lookup("viewManager");
        }
        catch (NotBoundException | RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public boolean isCurrent(@NotNull EView pView) {
        try {
            return this.mViewManager.isCurrent(pView);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setPos(@NotNull EView pView, @NotNull IPos pPos, int pDir) {
        try {
            this.mViewManager.setPos(pView, pPos, pDir);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public void setPosGreen(@Nullable IPos pPos) {
        try {
            this.mViewManager.setPosGreen(pPos);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public void setPosRed(@Nullable IPos pPos) {
        try {
            this.mViewManager.setPosRed(pPos);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public void makeNote(@NotNull String pText, @NotNull String pURI) {
        try {
            this.mViewManager.makeNote(pText, pURI);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public void deinitializeObjects(@NotNull EView pView) {
        try {
            this.mViewManager.deinitializeObjects(pView);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public void displayFrame(@NotNull EView pView) {
        try {
            this.mViewManager.displayFrame(pView);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public void displayLeftMenu(@NotNull EView pView, int pMode) {
        try {
            this.mViewManager.displayLeftMenu(pView, pMode);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public void displayLeftMenu(@NotNull EView pView) {
        try {
            this.mViewManager.displayLeftMenu(pView);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public void openWindowLazy() {
        try {
            this.mViewManager.openWindowLazy();
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }
}

