/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.loader;

import de.maggicraft.ism.loader.ISMSideStarter;
import de.maggicraft.ism.loader.MCContainer;
import de.maggicraft.ism.loader.MCLoaderServer;
import de.maggicraft.ism.world.area.IArea;
import de.maggicraft.ism.world.boundingbox.IBoundingBox;
import de.maggicraft.ism.world.info.IWorldInfoManager;
import de.maggicraft.ism.world.place.IPlaceStructureServer;
import de.maggicraft.ism.world.remove.IRemoveStructureServer;
import de.maggicraft.ism.world.repos.IReposStructureServer;
import de.maggicraft.ism.world.scan.IScanStructureServer;
import de.maggicraft.ism.world.shapes.IPlaceShapesServer;
import de.maggicraft.ism.world.shapes.IShapesTablesServer;
import de.maggicraft.ism.world.util.IMinecraftUtil;
import de.maggicraft.mcommons.initialization.IInitializable;
import de.maggicraft.mcommons.initialization.MLazyExport;
import de.maggicraft.mcommons.lang.MLang;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.MTuple;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMCLoader
implements IInitializable {
    @NotNull
    private static MTuple<Registry, Integer> getRegistryPort() {
        int port = 1099;
        Registry registry = null;
        while (registry == null || port >= 65535) {
            try {
                registry = LocateRegistry.createRegistry(port);
            }
            catch (ExportException pE) {
                ++port;
            }
            catch (RemoteException pE) {
                MCContainer.getLogger().log(pE);
                throw new IllegalArgumentException(pE);
            }
        }
        return new MTuple<Registry, Integer>(registry, port);
    }

    @Override
    public void initialize() throws IllegalStateException {
        this.init();
        MTuple<Registry, Integer> registryPort = AbstractMCLoader.getRegistryPort();
        MCContainer.setRegistry(registryPort.getA());
        try {
            MLazyExport.export(MCContainer.getRegistry(), MCContainer.getMCLoaderServer());
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
        this.initLang();
        this.startISMSide(registryPort.getB());
    }

    private void init() {
        MCContainer.setMCLoaderServer(new MCLoaderServer());
        MCContainer.setWorldInfoManager(this.getWorldInfoManager());
        MCContainer.setArea(this.getArea());
        MCContainer.setBoundingBox(this.getBoundingBox());
        MCContainer.setBlockStateMapper(this.getBlockStateMapper());
        MCContainer.setLoggedManagerMC(this.getLoggedManagerMC());
        MCContainer.setMinecraftUtil(this.getMinecraftUtil());
        MCContainer.setMCLogger(this.getMCLogger());
        MCContainer.setPlaceStructureServer(this.getPlaceStructureServer());
        MCContainer.setReposStructureServer(this.getReposStructureServer());
        MCContainer.setRemoveStructureServer(this.getRemoveStructureServer());
        MCContainer.setScanStructureServer(this.getScanStructureServer());
        MCContainer.setPlaceShapesServer(this.getPlaceShapesServer());
        MCContainer.setShapesTablesServer(this.getShapesTablesServer());
    }

    protected void startISMSide(int pPort) throws IllegalStateException {
        String jarName = MCContainer.getVersionHolder().getCalculatedJarName();
        String folder = MCContainer.APP_PATH.getParentFile().getAbsolutePath();
        if (ISMSideStarter.isISMSideAvailable(folder, jarName)) {
            new Thread(() -> ISMSideStarter.startISMSide(folder, jarName, pPort)).start();
        } else {
            ISMSideStarter.printError(folder, jarName);
        }
    }

    @NotNull
    protected void initLang() {
        String path = "/assets/ism/lang/english_mc.properties";
        URL url = AbstractMCLoader.class.getResource(path);
        if (url == null) {
            this.getMCLogger().warn("lang initialization failed for url \"" + path + '\"');
        } else {
            Optional<PropertyResourceBundle> bundle = MLang.makeBundle(url);
            if (bundle.isPresent()) {
                MLangManager.setLang(new MLang(bundle.get()));
            } else {
                this.getMCLogger().warn((Object)url);
            }
        }
    }

    @NotNull
    protected abstract IArea getArea();

    @NotNull
    protected abstract IBoundingBox getBoundingBox();

    @NotNull
    protected abstract IWorldInfoManager getWorldInfoManager();

    @NotNull
    protected abstract IInitializable getBlockStateMapper();

    @NotNull
    protected abstract IInitializable getLoggedManagerMC();

    @NotNull
    protected abstract IPlaceStructureServer getPlaceStructureServer();

    @NotNull
    protected abstract IReposStructureServer getReposStructureServer();

    @NotNull
    protected abstract IRemoveStructureServer getRemoveStructureServer();

    @NotNull
    protected abstract IScanStructureServer getScanStructureServer();

    @NotNull
    protected abstract IPlaceShapesServer getPlaceShapesServer();

    @NotNull
    protected abstract IShapesTablesServer getShapesTablesServer();

    @NotNull
    protected abstract IMinecraftUtil getMinecraftUtil();

    @NotNull
    protected abstract Logger getMCLogger();
}

