/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.loader;

import de.maggicraft.ism.loader.BlockWrapper;
import de.maggicraft.ism.loader.IBlock;
import de.maggicraft.ism.loader.MBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public final class BlockManager {
    private static final Map<IBlock, Block> BLOCK_MAP = new HashMap<IBlock, Block>(MBlocks.BLOCKS.size());

    private BlockManager() {
    }

    public static void registerBlocks(@NotNull RegistryEvent.Register<Block> pEvent) {
        IForgeRegistry registry = pEvent.getRegistry();
        for (IBlock block : MBlocks.BLOCKS) {
            BlockWrapper blockWrapper = new BlockWrapper(block);
            BLOCK_MAP.put(block, blockWrapper);
            registry.register((IForgeRegistryEntry)blockWrapper);
        }
    }

    public static void registerItemBlocks(@NotNull RegistryEvent.Register<Item> pEvent) {
        IForgeRegistry registry = pEvent.getRegistry();
    }

    @NotNull
    public static Optional<Block> getBlock(@NotNull IBlock pBlock) {
        return Optional.ofNullable(BLOCK_MAP.get(pBlock));
    }
}

