/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.loader;

import de.maggicraft.ism.ISMStarter;
import de.maggicraft.ism.analytics.manager.MAnalyticsManager;
import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.manager.MAnalyticsUtil;
import de.maggicraft.ism.analytics.manager.MGuiTableUtil;
import de.maggicraft.ism.analytics.trackers.TrackFavorite;
import de.maggicraft.ism.analytics.trackers.TrackRemoveProject;
import de.maggicraft.ism.database.DataCreators;
import de.maggicraft.ism.database.DataProjects;
import de.maggicraft.ism.favorites.EFavoriteObservedOperation;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.local.ELocalObserverOperation;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.ism.manager.IISM;
import de.maggicraft.ism.storage.EStorageObserverType;
import de.maggicraft.ism.storage.IStorageProjectBase;
import de.maggicraft.ism.world.logged.ELoggedType;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mcommons.initialization.IInitializable;
import de.maggicraft.mcommons.initialization.MLazy;
import de.maggicraft.mcommons.initialization.MLazyExport;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.MTable;
import de.maggicraft.mgui.comp.MTableUtil;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.schemes.def.MDarkVader;
import de.maggicraft.mgui.schemes.def.MDefaultFonts;
import de.maggicraft.mgui.schemes.def.MDefaultIcons;
import de.maggicraft.mgui.schemes.def.MDefaultMisc;
import de.maggicraft.mgui.schemes.def.MDefaultStyle;
import de.maggicraft.mgui.util.MDebugInfo;
import de.maggicraft.mgui.util.Util;
import java.awt.Dimension;
import java.io.File;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public final class ISMLoader {
    private static final boolean DEBUG_COLOR = false;
    @NotNull
    public static final Set<MLazy> INITS = new HashSet<MLazy>();
    public static final MLazy INIT_MINECRAFT_SIDE;
    public static final MLazy INIT_LOGGED_MANAGER;
    public static final MLazy INIT_FONT_CONSTANTS;
    public static final MLazy INIT_COLOR_CONSTANTS;
    public static final MLazy INIT_ICON_CONSTANTS;
    public static final MLazy INIT_MISC_CONSTANTS;
    public static final MLazy INIT_STYLE_CONSTANTS;
    public static final MLazy INIT_LOGGER;
    public static final MLazy INIT_SETTINGS;
    public static final MLazy INIT_SCAN_CREATORS;
    public static final MLazy INIT_LANG;
    public static final MLazy INIT_CONFIG;
    public static final MLazy INIT_ANALYTICS;
    public static final MLazy INIT_VIEW_MANAGER;
    public static final MLazy INIT_LOCAL_MANAGER;
    public static final MLazy INIT_PROJECTS;
    public static final MLazy INIT_CREATORS;
    public static final MLazy INIT_STORAGE;
    public static final MLazy INIT_PLACED_MANAGER;
    public static final MLazy INIT_PROJECT_LIST_LOADER;
    public static final MLazy INIT_FAVORITES;
    public static final MLazy INIT_UPDATE_MANAGER;
    public static final MLazy IMPORT_MC_SIDE_STATE;
    public static final MLazy IMPORT_BOUNDING_BOX;
    public static final MLazy IMPORT_PLACE_STRUCTURE;
    public static final MLazy IMPORT_REPOS_STRUCTURE;
    public static final MLazy IMPORT_REMOVE_STRUCTURE;
    public static final MLazy IMPORT_WORLD_INFO_MANAGER;
    public static final MLazy IMPORT_AREA;
    public static final MLazy IMPORT_SCAN_STRUCTURE;
    public static final MLazy IMPORT_PLACE_SHAPES;
    public static final MLazy IMPORT_SHAPES_TABLES;
    public static final MLazy IMPORT_ISM_SIDE_STATE;
    public static final MLazy INIT_WINDOW;
    public static final MLazy EXPORT_MC_SIDE_STATE;
    public static final MLazy EXPORT_LOGGER;
    public static final MLazy EXPORT_ANALYTICS_MANAGER;
    public static final MLazy EXPORT_VIEW_MANAGER;
    public static final MLazy EXPORT_SETTINGS;
    public static final MLazy EXPORT_LOGGED_MANAGER;

    public static void init(MLazy ... pInits) {
        for (MLazy init : pInits) {
            init.initLazy();
        }
    }

    private ISMLoader() {
    }

    static {
        ISMContainer.initLocalFunctionality();
        ISMContainer.initMCServerFunctionality();
        ISMContainer.initISMServerFunctionality();
        INIT_MINECRAFT_SIDE = new MLazy(() -> {
            try {
                ISMContainer.getMCLoaderServer().loadMCSide();
            }
            catch (RemoteException pE) {
                ISMContainer.getLogger().log(pE);
            }
        }, "IMCLoaderServer");
        INIT_LOGGED_MANAGER = new MLazy(() -> {
            ISMContainer.getLoggedManager().registerObserver(ELoggedType.LOGGED_IN, () -> {
                IPos pos = ISMContainer.getWorldInfoManager().getPlayerPos();
                int dir = ISMContainer.getWorldInfoManager().getDir();
                ViewManager.VIEW_PLACE_STRUCTURE.setPos(pos, dir);
                ViewManager.VIEW_PLACE_SHAPE.setPos(pos, dir);
                ViewManager.updateView();
                if (CSettings.SETTING_OPEN_WIN.isSelected("world")) {
                    ISMContainer.getStrExplorer().openLazy();
                }
            });
            ISMContainer.getLoggedManager().registerObserver(ELoggedType.LOGGED_OUT, ViewManager::updateView);
        }, "loggedManagerISM");
        INIT_FONT_CONSTANTS = new MLazy(() -> MCon.init(new MDefaultFonts()), "font_constants");
        INIT_COLOR_CONSTANTS = new MLazy(() -> MCon.init(new MDarkVader()), "color_constants");
        INIT_ICON_CONSTANTS = new MLazy(() -> MCon.init(new MDefaultIcons()), "icon_constants", ISMStarter.INIT_ENV);
        INIT_MISC_CONSTANTS = new MLazy(() -> {
            MCon.init(new MDefaultMisc(){

                @Override
                public void initLog() {
                }
            });
            new File(MCon.appFolder(), IISM.PATH_STRS).mkdirs();
        }, "misc_constants", INIT_ICON_CONSTANTS, INIT_COLOR_CONSTANTS, INIT_FONT_CONSTANTS);
        INIT_STYLE_CONSTANTS = new MLazy(() -> {
            MCon.setSchemeStyle(new MDefaultStyle(){

                @Override
                public void styleTable(@NotNull JTable pTable) {
                    if (pTable instanceof MTable) {
                        pTable.setModel(((MTable)pTable).createTableModel());
                        pTable.getTableHeader().setColumnModel(pTable.getColumnModel());
                    }
                    pTable.setDefaultRenderer(String.class, new MTableUtil.MStringCellRenderer(pTable));
                    pTable.setDefaultRenderer(Boolean.class, new MTableUtil.MBooleanCellRenderer());
                    pTable.setDefaultEditor(Boolean.class, new MGuiTableUtil.MBooleanCellEditor(pTable));
                    pTable.setIntercellSpacing(new Dimension(0, 0));
                    pTable.setFont(MCon.fontTableText());
                    pTable.getTableHeader().setFont(MCon.fontTableHeader());
                }
            });
            Util.initBorderSize();
        }, "style_constants", INIT_FONT_CONSTANTS, INIT_COLOR_CONSTANTS, INIT_ICON_CONSTANTS);
        INIT_LOGGER = new MLazy((IInitializable)ISMContainer.getLogger(), "logger", ISMStarter.INIT_ENV);
        INIT_SETTINGS = new MLazy(() -> CSettings.init(new File(MCon.appFolder(), "setting.json")), "settings", INIT_LOGGER);
        INIT_SCAN_CREATORS = new MLazy((IInitializable)ISMContainer.getScanCreatorsManager(), "scan_creators", INIT_LOGGER);
        INIT_LANG = new MLazy(() -> {
            MLangManager.init(MCon.appLangPath(), "english");
            MCon.setDecMark(MLangManager.get("mark"));
        }, "lang", INIT_LOGGER);
        INIT_CONFIG = new MLazy((IInitializable)ISMContainer.getConfigManager(), "config_manager", INIT_LOGGER);
        INIT_ANALYTICS = new MLazy(() -> {
            MAnalyticsSettings.init(new File(MCon.appFolder(), "setting_analytics.json"));
            MAnalyticsManager analytics = MAnalyticsManager.getStd();
            ISMContainer.setAnalyticsManager(analytics);
            analytics.initialize();
            MAnalyticsUtil.initMeasures();
            ISMContainer.getStorageManager().registerObserver(EStorageObserverType.PROJECT_COLLECTION_REMOVED, pStorable -> {
                IStorageProjectBase project = (IStorageProjectBase)pStorable;
                TrackRemoveProject.trackRemoveProject(project.getURL(), project.getPID());
            });
        }, "analytics", INIT_LANG, INIT_CONFIG);
        INIT_VIEW_MANAGER = new MLazy(() -> ISMContainer.setViewManager(new ViewManager()), "viewManager", INIT_STYLE_CONSTANTS);
        INIT_LOCAL_MANAGER = new MLazy(() -> {
            ISMContainer.getLocalManager().initialize();
            ISMContainer.getLocalManager().registerObserver(ELocalObserverOperation.ADD_LOCAL, pILocal -> {
                if (ViewManager.isCurrent(ViewManager.VIEW_LOCAL_STRUCTURES)) {
                    ViewManager.VIEW_LOCAL_STRUCTURES.loadLoc();
                }
            });
        }, "local_manager", INIT_LOGGER);
        INIT_PROJECTS = new MLazy(DataProjects::init, "projects", INIT_LOGGER);
        INIT_CREATORS = new MLazy(DataCreators::init, "creators", INIT_LOGGER);
        INIT_STORAGE = new MLazy((IInitializable)ISMContainer.getStorageManager(), "storage", INIT_PROJECTS);
        INIT_PLACED_MANAGER = new MLazy((IInitializable)ISMContainer.getPlacedManager(), "placed", INIT_LOGGER);
        INIT_PROJECT_LIST_LOADER = new MLazy((IInitializable)ISMContainer.getProjectListLoader(), "project_list_loader", INIT_PROJECTS);
        INIT_FAVORITES = new MLazy(() -> {
            ISMContainer.getFavoritesManager().initialize();
            ISMContainer.getFavoritesManager().registerObserver(EFavoriteObservedOperation.FAVORITE_ADDED, pFavorite -> TrackFavorite.trackFavorite(pFavorite.getURL(), pFavorite.getPID(), true));
            ISMContainer.getFavoritesManager().registerObserver(EFavoriteObservedOperation.FAVORITE_REMOVED, pFavorite -> TrackFavorite.trackFavorite(pFavorite.getURL(), pFavorite.getPID(), false));
        }, "favorites", INIT_PROJECTS);
        INIT_UPDATE_MANAGER = new MLazy((IInitializable)ISMContainer.getUpdateManager(), "update_manager", INIT_ANALYTICS);
        IMPORT_MC_SIDE_STATE = new MLazy((IInitializable)ISMContainer.getMCSideState(), "mcSideState", INIT_LOGGER);
        IMPORT_BOUNDING_BOX = new MLazy((IInitializable)ISMContainer.getBoundingBox(), "boundingBox", INIT_LOGGER);
        IMPORT_PLACE_STRUCTURE = new MLazy((IInitializable)ISMContainer.getPlaceStructure(), "placeStructure", INIT_LOGGER);
        IMPORT_REPOS_STRUCTURE = new MLazy((IInitializable)ISMContainer.getReposStructure(), "reposStructure", INIT_LOGGER);
        IMPORT_REMOVE_STRUCTURE = new MLazy((IInitializable)ISMContainer.getRemoveStructure(), "removeStructure", INIT_LOGGER);
        IMPORT_WORLD_INFO_MANAGER = new MLazy((IInitializable)ISMContainer.getWorldInfoManager(), "worldInfoManager");
        IMPORT_AREA = new MLazy((IInitializable)ISMContainer.getArea(), "area", INIT_LOGGER);
        IMPORT_SCAN_STRUCTURE = new MLazy((IInitializable)ISMContainer.getScanStructure(), "scanner", INIT_LOGGER);
        IMPORT_PLACE_SHAPES = new MLazy((IInitializable)ISMContainer.getPlaceShapes(), "placeShapes", INIT_LOGGER);
        IMPORT_SHAPES_TABLES = new MLazy((IInitializable)ISMContainer.getShapesTables(), "shapesTables", INIT_LOGGER);
        IMPORT_ISM_SIDE_STATE = new MLazy((IInitializable)ISMContainer.getISMSideState(), "shapesTables", INIT_LOGGER);
        INIT_WINDOW = new MLazy(() -> {
            if (CSettings.SETTING_OPEN_WIN.isSelected("start")) {
                MDebugInfo.activate();
                ISMContainer.getStrExplorer().initialize();
                ISMContainer.getStrExplorer().openLazy();
            }
        }, "window", INIT_MISC_CONSTANTS, INIT_STYLE_CONSTANTS, INIT_SETTINGS, INIT_LOCAL_MANAGER, INIT_CREATORS, INIT_STORAGE, INIT_PLACED_MANAGER, INIT_PROJECT_LIST_LOADER, INIT_FAVORITES, INIT_UPDATE_MANAGER, INIT_SCAN_CREATORS, IMPORT_AREA, IMPORT_PLACE_SHAPES, IMPORT_SHAPES_TABLES, IMPORT_REMOVE_STRUCTURE, IMPORT_REPOS_STRUCTURE, IMPORT_PLACE_STRUCTURE, IMPORT_SCAN_STRUCTURE, IMPORT_BOUNDING_BOX, IMPORT_ISM_SIDE_STATE);
        EXPORT_MC_SIDE_STATE = new MLazyExport(ISMContainer.getRegistry(), ISMContainer.getMCSideStateServer(), INIT_LOGGER);
        EXPORT_LOGGER = new MLazyExport(ISMContainer.getRegistry(), ISMContainer.getLoggerServer(), INIT_LOGGER);
        EXPORT_ANALYTICS_MANAGER = new MLazyExport(ISMContainer.getRegistry(), ISMContainer.getAnalyticsServer(), INIT_ANALYTICS);
        EXPORT_VIEW_MANAGER = new MLazyExport(ISMContainer.getRegistry(), ISMContainer.getViewManagerServer(), INIT_VIEW_MANAGER);
        EXPORT_SETTINGS = new MLazyExport(ISMContainer.getRegistry(), ISMContainer.getSettingsServer(), INIT_SETTINGS);
        EXPORT_LOGGED_MANAGER = new MLazyExport(ISMContainer.getRegistry(), ISMContainer.getLoggedManagerServer(), INIT_LOGGED_MANAGER);
        INITS.add(INIT_MINECRAFT_SIDE);
        INITS.add(INIT_FONT_CONSTANTS);
        INITS.add(INIT_COLOR_CONSTANTS);
        INITS.add(INIT_ICON_CONSTANTS);
        INITS.add(INIT_MISC_CONSTANTS);
        INITS.add(INIT_STYLE_CONSTANTS);
        INITS.add(INIT_VIEW_MANAGER);
        INITS.add(INIT_LOGGER);
        INITS.add(INIT_SETTINGS);
        INITS.add(INIT_LANG);
        INITS.add(INIT_ANALYTICS);
        INITS.add(INIT_LOCAL_MANAGER);
        INITS.add(INIT_PROJECTS);
        INITS.add(INIT_CREATORS);
        INITS.add(INIT_STORAGE);
        INITS.add(INIT_PLACED_MANAGER);
        INITS.add(INIT_PROJECT_LIST_LOADER);
        INITS.add(INIT_FAVORITES);
        INITS.add(INIT_UPDATE_MANAGER);
        INITS.add(INIT_WINDOW);
        INITS.add(INIT_CONFIG);
        INITS.add(IMPORT_MC_SIDE_STATE);
        INITS.add(IMPORT_WORLD_INFO_MANAGER);
        INITS.add(IMPORT_PLACE_STRUCTURE);
        INITS.add(IMPORT_REPOS_STRUCTURE);
        INITS.add(IMPORT_REMOVE_STRUCTURE);
        INITS.add(IMPORT_AREA);
        INITS.add(IMPORT_SCAN_STRUCTURE);
        INITS.add(IMPORT_PLACE_SHAPES);
        INITS.add(IMPORT_SHAPES_TABLES);
        INITS.add(IMPORT_BOUNDING_BOX);
        INITS.add(EXPORT_MC_SIDE_STATE);
        INITS.add(EXPORT_ANALYTICS_MANAGER);
        INITS.add(EXPORT_VIEW_MANAGER);
        INITS.add(EXPORT_SETTINGS);
    }
}

