/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.loader;

import de.maggicraft.ism.loader.MCContainer;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.EOSType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class ISMSideStarter {
    private ISMSideStarter() {
    }

    public static void startISMSide(@NotNull String pJarFolder, @NotNull String pJarName, int pPort) {
        MCContainer.getMCLogger().warn("exists");
        String command1 = "cd \"" + pJarFolder + '\"';
        String command2 = "java -jar \"" + pJarName + "\" " + pPort;
        try {
            ISMSideStarter.process(command1, command2);
        }
        catch (IOException | InterruptedException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    public static boolean isISMSideAvailable(@NotNull String pRequiredFolder, @NotNull String pRequiredJar) {
        return new File(pRequiredFolder, pRequiredJar).exists();
    }

    public static void printError(@NotNull String pRequiredFolder, @NotNull String pRequiredJar) throws IllegalStateException {
        String message = MLangManager.rep("log.ismSideUnavailable", pRequiredFolder, pRequiredJar);
        MCContainer.getMCLogger().fatal("fatal: " + message);
        File requiredFile = new File(pRequiredFolder, pRequiredJar);
        throw new IllegalStateException(message, new FileNotFoundException(requiredFile.getAbsolutePath()));
    }

    public static void process(String ... pCommands) throws IOException, InterruptedException {
        Process process = ISMSideStarter.createProcess();
        StreamGobbler processInput = new StreamGobbler(process.getInputStream(), System.out::println);
        StreamGobbler processError = new StreamGobbler(process.getErrorStream(), System.err::println);
        Executors.newSingleThreadExecutor().submit(processInput);
        Executors.newSingleThreadExecutor().submit(processError);
        PrintWriter exec = new PrintWriter(process.getOutputStream());
        for (String command : pCommands) {
            exec.println(command);
        }
        exec.close();
        int exitCode = process.waitFor();
        MCContainer.getLogger().log("exitCode: " + exitCode);
    }

    @NotNull
    private static Process createProcess() throws IOException {
        String command = ISMSideStarter.isWindows() ? "cmd" : "/bin/bash";
        return Runtime.getRuntime().exec(command);
    }

    private static boolean isWindows() {
        return EOSType.getOperatingSystem() == EOSType.OS_WINDOWS;
    }

    private static class StreamGobbler
    implements Runnable {
        @NotNull
        private final InputStream mInputStream;
        @NotNull
        private final Consumer<String> mConsumer;

        public StreamGobbler(@NotNull InputStream pInputStream, @NotNull Consumer<String> pConsumer) {
            this.mInputStream = pInputStream;
            this.mConsumer = pConsumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.mInputStream)).lines().forEach(this.mConsumer);
        }
    }
}

