/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.loader;

import de.maggicraft.ism.loader.IItem;
import de.maggicraft.ism.loader.ItemWrapper;
import de.maggicraft.ism.loader.MItems;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public final class ItemManager {
    private static final Map<IItem, Item> ITEM_MAP = new HashMap<IItem, Item>(MItems.ITEMS.size());

    private ItemManager() {
    }

    public static void registerItems(@NotNull RegistryEvent.Register<Item> pEvent) {
        IForgeRegistry registry = pEvent.getRegistry();
        for (IItem item : MItems.ITEMS) {
            if (item != MItems.ITEM_PLACE && item != MItems.ITEM_EXPLORER) continue;
            ItemWrapper itemWrapper = new ItemWrapper(item);
            ITEM_MAP.put(item, itemWrapper);
            registry.register((IForgeRegistryEntry)itemWrapper);
        }
    }

    @NotNull
    public static Optional<Item> getItem(@NotNull IItem pItem) {
        return Optional.ofNullable(ITEM_MAP.get(pItem));
    }
}

