/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.loader;

import de.maggicraft.ism.loader.IItem;
import de.maggicraft.ism.loader.ItemGroupProvider;
import de.maggicraft.ism.loader.MCContainer;
import de.maggicraft.ism.world.util.MinecraftUtil;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemWrapper
extends Item {
    @NotNull
    private final IItem mWrappedItem;
    private boolean mLeftClicked;

    public ItemWrapper(@NotNull IItem pWrappedItem) {
        super(new Item.Properties().func_200916_a(ItemGroupProvider.TAB));
        this.mWrappedItem = pWrappedItem;
        this.setRegistryName("ism:" + (String)pWrappedItem.getUID());
    }

    public boolean onEntitySwing(@NotNull ItemStack pStack, @NotNull LivingEntity pEntity) {
        if (this.mLeftClicked) {
            this.mWrappedItem.getOnLeftClick().accept(MCContainer.getWorldInfoManager().getPlayerPos());
        }
        this.mLeftClicked = !this.mLeftClicked;
        return false;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World pWorld, @NotNull PlayerEntity pPlayer, @NotNull Hand pHand) {
        if (!pWorld.field_72995_K) {
            this.mWrappedItem.getOnRightClick().accept(MinecraftUtil.getPlayerPos(pPlayer));
        }
        return new ActionResult(ActionResultType.PASS, (Object)pPlayer.func_184586_b(pHand));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MItemWrapper{");
        sb.append("mWrappedItem=").append(this.mWrappedItem);
        sb.append(", mLeftClicked=").append(this.mLeftClicked);
        sb.append('}');
        return sb.toString();
    }

    @NotNull
    public IItem getWrappedItem() {
        return this.mWrappedItem;
    }
}

