/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.loader;

import de.maggicraft.ism.loader.IBlock;
import org.jetbrains.annotations.NotNull;

public class MBlock
implements IBlock {
    public static final Runnable EMPTY_RUNNABLE = () -> {};
    @NotNull
    private final Runnable mOnPlayerDestroy;
    @NotNull
    private final Runnable mOnExplosionDestroy;
    @NotNull
    private final Runnable mOnBlockActivated;
    @NotNull
    private final Runnable mOnBlockPlacedBy;
    @NotNull
    private final String mUID;

    public MBlock(@NotNull String pRawName) {
        this(pRawName, EMPTY_RUNNABLE, EMPTY_RUNNABLE, EMPTY_RUNNABLE, EMPTY_RUNNABLE);
    }

    public MBlock(@NotNull String pRawName, @NotNull Runnable pOnPlayerDestroy, @NotNull Runnable pOnExplosionDestroy, @NotNull Runnable pOnBlockActivated, @NotNull Runnable pOnBlockPlacedBy) {
        this.mOnPlayerDestroy = pOnPlayerDestroy;
        this.mOnExplosionDestroy = pOnExplosionDestroy;
        this.mOnBlockActivated = pOnBlockActivated;
        this.mOnBlockPlacedBy = pOnBlockPlacedBy;
        this.mUID = MBlock.toBlockName(pRawName);
    }

    @NotNull
    private static String toBlockName(@NotNull String pRawName) {
        return "block_" + pRawName.toLowerCase();
    }

    @Override
    @NotNull
    public Runnable onPlayerDestroy() {
        return this.mOnPlayerDestroy;
    }

    @Override
    @NotNull
    public Runnable onExplosionDestroy() {
        return this.mOnExplosionDestroy;
    }

    @Override
    @NotNull
    public Runnable onBlockActivated() {
        return this.mOnBlockActivated;
    }

    @Override
    @NotNull
    public Runnable onBlockPlacedBy() {
        return this.mOnBlockPlacedBy;
    }

    @Override
    @NotNull
    public String getUID() {
        return this.mUID;
    }
}

