/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.loader;

import de.maggicraft.ism.loader.IISMLoaderServer;
import de.maggicraft.ism.loader.IMCLoaderServer;
import de.maggicraft.ism.loader.MCContainer;
import de.maggicraft.ism.loader.MCLoader;
import de.maggicraft.mcommons.initialization.MLazy;
import de.maggicraft.mthread.MasterThread;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public class MCLoaderServer
implements IMCLoaderServer {
    @Override
    public void loadMCSide() {
        try {
            MCContainer.setISMLoaderServer((IISMLoaderServer)MCContainer.getRegistry().lookup("IISMLoaderStub"));
        }
        catch (NotBoundException | RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
        int threadQuantity = Math.min(12, MCLoader.INITS.size());
        MasterThread thread = new MasterThread("initialize ISM-Minecraft-Side", threadQuantity, 5, 0);
        for (MLazy init : MCLoader.INITS) {
            thread.add(init::initLazy);
        }
        thread.start();
    }

    @Override
    public void requiredISMSideStateServer() {
        MCLoader.EXPORT_ISM_SIDE_STATE.initLazy();
    }

    @Override
    public void requiredWorldInfoManagerServer() {
        MCLoader.EXPORT_WORLD_INFO_MANAGER.initLazy();
    }

    @Override
    public void requiredBoundingBoxServer() {
        MCLoader.EXPORT_BOUNDING_BOX.initLazy();
    }

    @Override
    public void requiredPlaceStructureServer() {
        MCLoader.EXPORT_PLACE_STRUCTURE.initLazy();
    }

    @Override
    public void requiredReposStructureServer() {
        MCLoader.EXPORT_REPOS_STRUCTURE.initLazy();
    }

    @Override
    public void requiredRemoveStructureServer() {
        MCLoader.EXPORT_REMOVE_STRUCTURE.initLazy();
    }

    @Override
    public void requiredAreaServer() {
        MCLoader.EXPORT_AREA.initLazy();
    }

    @Override
    public void requiredScanStructureServer() {
        MCLoader.EXPORT_SCAN_STRUCTURE.initLazy();
    }

    @Override
    public void requiredPlaceShapesServer() {
        MCLoader.EXPORT_PLACE_SHAPES.initLazy();
    }

    @Override
    public void requiredShapesTablesServer() {
        MCLoader.EXPORT_SHAPES_TABLES.initLazy();
    }
}

