/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.loader;

import de.maggicraft.ism.analytics.server.EItemTracker;
import de.maggicraft.ism.analytics.server.EItemTrackerLabel;
import de.maggicraft.ism.app_state.EAppState;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.loader.IItem;
import de.maggicraft.ism.loader.MCContainer;
import de.maggicraft.ism.loader.MItem;
import de.maggicraft.ism.world.boundingbox.EBoundingBoxState;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mcommons.lang.MLangManager;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class MItems {
    public static final IItem ITEM_EXPLORER = new MItem("explorer", pPos -> MItems.itemExplorerAction(EItemTrackerLabel.CLICK_LEFT), pPos -> MItems.itemExplorerAction(EItemTrackerLabel.CLICK_RIGHT));
    public static final IItem ITEM_BOUNDING_BOX = new MItem("bounding_box", pPos -> {}, pPos -> {});
    public static final IItem ITEM_PLACE = new MItem("place", pPos -> MItems.itemPlaceAction(pPos.add(0, 1, 0), EItemTrackerLabel.CLICK_LEFT), pPos -> MItems.itemPlaceAction(pPos, EItemTrackerLabel.CLICK_RIGHT));
    public static final IItem ITEM_REPOS = new MItem("repos", pPos -> MItems.displayViewAction(EView.VIEW_REPOS_STRUCTURE, EItemTracker.ITEM_REPOS, EItemTrackerLabel.CLICK_LEFT), pPos -> MItems.displayViewAction(EView.VIEW_REPOS_STRUCTURE, EItemTracker.ITEM_REPOS, EItemTrackerLabel.CLICK_RIGHT));
    public static final IItem ITEM_REMOVE = new MItem("remove", pPos -> MItems.displayViewAction(EView.VIEW_REMOVE_STRUCTURE, EItemTracker.ITEM_REMOVE, EItemTrackerLabel.CLICK_LEFT), pPos -> MItems.displayViewAction(EView.VIEW_REMOVE_STRUCTURE, EItemTracker.ITEM_REMOVE, EItemTrackerLabel.CLICK_RIGHT));
    public static final IItem ITEM_SHAPE = new MItem("shape", pPos -> {
        if (MCContainer.getISMSideState().getState() == EAppState.RUNNING) {
            MCContainer.getViewManager().setPos(EView.VIEW_PLACE_SHAPE, (IPos)pPos, MCContainer.getWorldInfoManager().getDir());
        }
        MItems.displayViewAction(EView.VIEW_PLACE_SHAPE, EItemTracker.ITEM_SHAPE, EItemTrackerLabel.CLICK_LEFT);
    }, pPos -> {
        if (MCContainer.getISMSideState().getState() == EAppState.RUNNING) {
            MCContainer.getViewManager().setPos(EView.VIEW_PLACE_SHAPE, (IPos)pPos, MCContainer.getWorldInfoManager().getDir());
        }
        MItems.displayViewAction(EView.VIEW_PLACE_SHAPE, EItemTracker.ITEM_SHAPE, EItemTrackerLabel.CLICK_RIGHT);
    });
    public static final IItem ITEM_TEST = new MItem("test", pPos -> {}, pPos -> {});
    public static final List<IItem> ITEMS = new LinkedList<IItem>();

    private MItems() {
    }

    private static void itemExplorerAction(@NotNull EItemTrackerLabel pItemClick) {
        if (MCContainer.getISMSideState().getState() == EAppState.RUNNING) {
            MCContainer.getViewManager().openWindowLazy();
            MCContainer.getAnalyticsManager().trackItem(EItemTracker.ITEM_EXPLORER, pItemClick);
        } else {
            MItems.displayErrorMessage();
        }
    }

    private static void itemPlaceAction(@NotNull IPos pPos, @NotNull EItemTrackerLabel pItemClick) {
        if (MCContainer.getISMSideState().getState() == EAppState.RUNNING) {
            MCContainer.getViewManager().setPos(EView.VIEW_PLACE_STRUCTURE, pPos, MCContainer.getWorldInfoManager().getDir());
            MCContainer.getViewManager().displayFrame(EView.VIEW_PLACE_STRUCTURE);
            if (MCContainer.getBoundingBox().getState() == EBoundingBoxState.PLACED) {
                MCContainer.getBoundingBox().remove();
            }
            MCContainer.getAnalyticsManager().trackItem(EItemTracker.ITEM_PLACE, pItemClick);
        } else {
            MItems.displayErrorMessage();
        }
    }

    private static void displayViewAction(@NotNull EView pView, @NotNull EItemTracker pItemTracker, @NotNull EItemTrackerLabel pItemClick) {
        if (MCContainer.getISMSideState().getState() == EAppState.RUNNING) {
            MCContainer.getViewManager().displayFrame(pView);
            MCContainer.getAnalyticsManager().trackItem(pItemTracker, pItemClick);
        } else {
            MItems.displayErrorMessage();
        }
    }

    private static void displayErrorMessage() {
        MCContainer.getMinecraftUtil().chat(MLangManager.get("cha.featureDisabled"));
    }

    static {
        ITEMS.add(ITEM_EXPLORER);
        ITEMS.add(ITEM_BOUNDING_BOX);
        ITEMS.add(ITEM_PLACE);
        ITEMS.add(ITEM_REPOS);
        ITEMS.add(ITEM_REMOVE);
        ITEMS.add(ITEM_SHAPE);
        ITEMS.add(ITEM_TEST);
    }
}

