/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.local;

import de.maggicraft.ism.local.ELocalObserverOperation;
import de.maggicraft.ism.local.ILocal;
import de.maggicraft.ism.local.ILocalManager;
import de.maggicraft.ism.local.MLocal;
import de.maggicraft.ism.local.MLocalUtil;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.StorageCompoundException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.storage.StorageUtil;
import de.maggicraft.mcommons.event.IObserver;
import de.maggicraft.mcommons.filter.types.MFilter;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mioutil.io.MIOUtil;
import de.maggicraft.mioutil.json.IReadableManager;
import de.maggicraft.mioutil.json.IStorableManager;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class LocalManager
implements ILocalManager,
IStorableManager,
IReadableManager {
    public static final String VERSION = "1";
    @NotNull
    public static final String RELATIVE_LOCAL_PATH = "locals" + CCon.SEP;
    @NotNull
    private static final String RELATIVE_LOCAL_FILE = "locals.json";
    @NotNull
    private static final FilenameFilter FILTER_SCHEMATICS = (pDir, pName) -> pName.endsWith(".schematic");
    @NotNull
    private final Map<ELocalObserverOperation, Collection<IObserver<ILocal>>> mObservers = new EnumMap<ELocalObserverOperation, Collection<IObserver<ILocal>>>(ELocalObserverOperation.class);
    private File mFolder = new File(MCon.appFolder(), RELATIVE_LOCAL_PATH);
    private File mFileJSON;
    private List<ILocal> mLocals;

    public LocalManager() {
        if (!this.mFolder.exists()) {
            this.mFolder.mkdirs();
        }
        this.mFileJSON = new File(MCon.appFolder(), RELATIVE_LOCAL_FILE);
    }

    @Override
    public void initialize() {
        if (this.mFileJSON.exists()) {
            this.read();
        } else {
            this.mLocals = new LinkedList<ILocal>();
        }
        boolean store = this.initFromFiles();
        if (store) {
            this.store();
        }
    }

    @Override
    public void store() {
        MIOUtil.write(this.mFileJSON, this.toJSON().toJSONString());
    }

    private boolean initFromFiles() {
        boolean store = false;
        StorageCompoundException exception = new StorageCompoundException("initFromFiles");
        File[] files = this.mFolder.listFiles(FILTER_SCHEMATICS);
        if (files != null) {
            for (File file : files) {
                try {
                    this.addLocal(file);
                    store = true;
                }
                catch (StorageException pE) {
                    exception.addException(pE);
                }
            }
        }
        if (exception.hasException()) {
            StorageUtil.handleStorageException(exception);
            return true;
        }
        return store;
    }

    @Override
    public void addLocal(@NotNull File pFile) throws StorageException {
        if (!MLocalUtil.isSchematicFile(pFile)) {
            String message = "file \"" + pFile.getAbsolutePath() + "\" has the wrong suffix";
            throw new StorageException(EStorageException.WRONG_SUFFIX, message);
        }
        if (this.containsStr(pFile)) {
            String message = "file \"" + pFile.getAbsolutePath() + "\" is already added";
            throw new StorageException(EStorageException.STRUCTURE_ADDED_TWICE, message);
        }
        MLocal localStr = MLocalUtil.fromFile(pFile, this);
        this.mLocals.add(localStr);
        this.notifyObservers(ELocalObserverOperation.ADD_LOCAL, localStr);
    }

    @Override
    @NotNull
    public File fileLocal(@NotNull String pFileName) {
        String name = MFilter.validateFilename(pFileName);
        return new File(this.mFolder, name + ".schematic");
    }

    public boolean containsStr(@NotNull File pFile) throws StorageException {
        String name = MLocalUtil.removeSuffixes(pFile);
        for (ILocal str : this.mLocals) {
            if (!str.getFileName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void storeHeader(@NotNull JSONObject pJSON) {
        StorableUtil.put(pJSON, (IUniqueID<String>)ELocalManagerKeys.VERSION, VERSION);
    }

    @Override
    public void readHeader(@NotNull JSONObject pJSON) {
        String version = ReadableUtil.getString(pJSON, ELocalManagerKeys.VERSION);
        if (!version.equals(VERSION)) {
            throw new IllegalArgumentException("version \"" + version + "\" not support");
        }
    }

    @Override
    public void readEntities(@NotNull JSONArray pJSONArray) {
        this.mLocals = new ArrayList<ILocal>(pJSONArray.size() + 2);
        for (Object object : pJSONArray) {
            JSONObject json = (JSONObject)object;
            MLocal localStr = new MLocal(json);
            this.mLocals.add(localStr);
        }
    }

    @NotNull
    public List<ILocal> getStorables() {
        return this.mLocals;
    }

    @Override
    @NotNull
    public List<ILocal> getLocals() {
        return this.mLocals;
    }

    @Override
    public File getFolder() {
        return this.mFolder;
    }

    @Override
    public File getFile() {
        return this.mFileJSON;
    }

    @Override
    @NotNull
    public Map<ELocalObserverOperation, Collection<IObserver<ILocal>>> getObservers() {
        return this.mObservers;
    }

    public static enum ELocalManagerKeys implements IUID
    {
        VERSION("vers");

        @NotNull
        private final String mUID;

        private ELocalManagerKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

