/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.local;

import de.maggicraft.ism.local.ILocal;
import de.maggicraft.ism.local.LocalManager;
import de.maggicraft.ism.str.IReadableStructure;
import de.maggicraft.ism.world.util.Dim;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IOffset;
import de.maggicraft.ism.world.util.Offset;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mioutil.json.IStorable;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.io.File;
import java.util.Date;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public class MLocal
implements ILocal,
IStorable {
    @NotNull
    private final String mFileName;
    @NotNull
    private final Date mDateAdded;
    @NotNull
    private final IDim mDim;
    @NotNull
    private final IOffset mOffset;
    private final int mBlocks;
    private int mPlaced;

    public MLocal(@NotNull IReadableStructure pStr, @NotNull String pFileName) {
        this.mFileName = pFileName;
        this.mDateAdded = new Date();
        this.mPlaced = 0;
        this.mBlocks = pStr.getBlocks();
        this.mDim = pStr.getDim();
        this.mOffset = pStr.getOffset();
    }

    public MLocal(@NotNull JSONObject pJSON) {
        this.mFileName = ReadableUtil.getString(pJSON, ELocalKeys.FILE_NAME);
        this.mDateAdded = ReadableUtil.getDate(pJSON, ELocalKeys.DATE_ADDED);
        this.mPlaced = ReadableUtil.getInt(pJSON, ELocalKeys.PLACED);
        this.mBlocks = ReadableUtil.getInt(pJSON, ELocalKeys.BLOCKS);
        this.mDim = new Dim(ReadableUtil.getJSON(pJSON, ELocalKeys.DIM));
        this.mOffset = new Offset(ReadableUtil.getJSON(pJSON, ELocalKeys.OFFSET));
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        MLocal mLocal = (MLocal)pO;
        return this.mBlocks == mLocal.mBlocks && this.mFileName.equals(mLocal.mFileName) && this.mDateAdded.equals(mLocal.mDateAdded) && this.mDim.equals(mLocal.mDim) && this.mOffset.equals(mLocal.mOffset);
    }

    public int hashCode() {
        return Objects.hash(this.mFileName, this.mDateAdded, this.mDim, this.mOffset, this.mBlocks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MLocal{");
        sb.append("mFileName='").append(this.mFileName).append('\'');
        sb.append(", mDateAdded=").append(this.mDateAdded);
        sb.append(", mDim=").append(this.mDim);
        sb.append(", mOffset=").append(this.mOffset);
        sb.append(", mBlocks=").append(this.mBlocks);
        sb.append(", mPlaced=").append(this.mPlaced);
        sb.append('}');
        return sb.toString();
    }

    @Override
    @NotNull
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        StorableUtil.put(json, (IUniqueID<String>)ELocalKeys.FILE_NAME, this.mFileName);
        StorableUtil.put(json, (IUniqueID<String>)ELocalKeys.DATE_ADDED, this.mDateAdded);
        StorableUtil.put(json, (IUniqueID<String>)ELocalKeys.PLACED, this.mPlaced);
        StorableUtil.put(json, (IUniqueID<String>)ELocalKeys.BLOCKS, this.mBlocks);
        StorableUtil.put(json, (IUniqueID<String>)ELocalKeys.DIM, this.mDim.toJSON());
        StorableUtil.put(json, (IUniqueID<String>)ELocalKeys.OFFSET, this.mOffset.toJSON());
        return json;
    }

    @Override
    @NotNull
    public File getFile() {
        return new File(MCon.appFolder(), LocalManager.RELATIVE_LOCAL_PATH + this.mFileName + ".schematic");
    }

    @Override
    @NotNull
    public IDim getDim() {
        return this.mDim;
    }

    @Override
    @NotNull
    public IOffset getOffset() {
        return this.mOffset;
    }

    @Override
    @NotNull
    public String getFileName() {
        return this.mFileName;
    }

    @Override
    @NotNull
    public Date getDateAdded() {
        return this.mDateAdded;
    }

    @Override
    public int getBlocks() {
        return this.mBlocks;
    }

    @Override
    public int getPlaced() {
        return this.mPlaced;
    }

    public static enum ELocalKeys implements IUID
    {
        FILE_NAME("fin"),
        DATE_ADDED("dat"),
        PLACED("pqu"),
        BLOCKS("blk"),
        DIM("dim"),
        OFFSET("off");

        @NotNull
        private final String mUID;

        private ELocalKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

