/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.local;

import de.maggicraft.ism.local.ILocalManager;
import de.maggicraft.ism.local.LocalManager;
import de.maggicraft.ism.local.MLocal;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.str.ReadableStructure;
import de.maggicraft.ism.world.nbt.SchematicUtil;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mioutil.io.MIOUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class MLocalUtil {
    private MLocalUtil() {
    }

    @NotNull
    public static String removeSuffixes(@NotNull File pFile) throws StorageException {
        String name = pFile.getName();
        if (MLocalUtil.isSchematicFile(pFile)) {
            return name.substring(0, name.lastIndexOf(46));
        }
        String message = pFile.getAbsolutePath() + " has the wrong suffix";
        throw new StorageException(EStorageException.WRONG_SUFFIX, message);
    }

    public static boolean isSchematicFile(@NotNull File pFile) {
        return pFile.getName().endsWith(".schematic");
    }

    @NotNull
    public static MLocal fromFile(@NotNull File pFile, @NotNull ILocalManager pLocalManager) throws StorageException {
        if (MLocalUtil.isSchematicFile(pFile)) {
            return MLocalUtil.fromSchematic(pFile);
        }
        String message = pFile.getAbsolutePath() + " has the wrong suffix";
        throw new StorageException(EStorageException.WRONG_SUFFIX, message);
    }

    @NotNull
    public static MLocal fromSchematic(@NotNull File pFile) throws StorageException {
        if (!MLocalUtil.isSchematicFile(pFile)) {
            String message = pFile.getAbsolutePath() + " is no .schematic-file";
            throw new StorageException(EStorageException.WRONG_SUFFIX, message);
        }
        File exportFile = MLocalUtil.exportFile(pFile);
        MIOUtil.copyFile(pFile, exportFile);
        ReadableStructure header = SchematicUtil.toReadableStructure(pFile);
        String fileName = MLocalUtil.removeSuffixes(pFile);
        return new MLocal(header, fileName);
    }

    @NotNull
    public static File exportFile(@NotNull File pFile) throws StorageException {
        String mFileName = MLocalUtil.removeSuffixes(pFile);
        return new File(MCon.appFolder(), LocalManager.RELATIVE_LOCAL_PATH + mFileName + ".schematic");
    }
}

