/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.logger;

import de.maggicraft.ism.analytics.trackers.TrackException;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.loader.ISMLoader;
import de.maggicraft.ism.logger.ILogger;
import de.maggicraft.mcommons.initialization.EInitializableStates;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mlog.MLog;
import de.maggicraft.mlog.MLogImpl;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class Logger
extends MLogImpl
implements ILogger {
    @Override
    public void initialize() {
        this.setDisplayMessages(true);
        this.setOutput(new File(MCon.appFolder(), "log.txt"));
        this.setDisplayJavaVersion(Integer.MAX_VALUE);
        this.setHeader(ISMContainer.getVersionHolder().getISMVersion() + '\t');
        this.getOutput().getParentFile().mkdirs();
        MLog.init(this);
    }

    @Override
    public void log(@NotNull Throwable pStacktrace) {
        super.log(pStacktrace);
        if (ISMLoader.INIT_ANALYTICS.getState() == EInitializableStates.INITIALIZED) {
            TrackException.trackException(pStacktrace, true);
        }
    }

    @Override
    public void log(@NotNull String pText, @NotNull Throwable pStacktrace) {
        super.log(pText, pStacktrace);
        if (ISMLoader.INIT_ANALYTICS.getState() == EInitializableStates.INITIALIZED) {
            TrackException.trackException(pStacktrace, pText, true);
        }
    }

    @Override
    public void logNoAnalytics(@NotNull Throwable pStacktrace) {
        super.log(pStacktrace);
    }

    @Override
    public void logNoAnalytics(@NotNull String pText, @NotNull Throwable pStacktrace) {
        super.log(pText, pStacktrace);
    }
}

