/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.logger;

import de.maggicraft.ism.loader.MCContainer;
import de.maggicraft.ism.logger.ILoggerServer;
import de.maggicraft.ism.logger.ILoggerWrapper;
import de.maggicraft.mlog.ILog;
import de.maggicraft.mlog.MLog;
import de.maggicraft.mlog.MLogImpl;
import java.io.File;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoggerWrapper
implements ILoggerWrapper {
    @Nullable
    private ILoggerServer mRemoteLogger;
    private final ILog mFallbackLogger;

    public LoggerWrapper() {
        File file = new File(MCContainer.APP_PATH, "minecraft_log.txt");
        this.mFallbackLogger = new MLogImpl(file, true);
        MLog.init(this.mFallbackLogger);
    }

    @Override
    public void initialize() {
        try {
            MCContainer.getISMLoaderServer().requiredLoggerServer();
            this.mRemoteLogger = (ILoggerServer)LocateRegistry.getRegistry().lookup("logger");
        }
        catch (NotBoundException | RemoteException pE) {
            this.mFallbackLogger.log(pE);
        }
    }

    @Override
    public void log(@NotNull String pText) {
        try {
            if (this.mRemoteLogger == null) {
                this.mFallbackLogger.log(pText);
            } else {
                this.mRemoteLogger.log("MCSide: " + pText);
            }
            System.err.println(pText);
        }
        catch (RemoteException pE) {
            this.log(pE);
            this.mFallbackLogger.log(pText);
        }
    }

    @Override
    public void log(@NotNull Throwable pStacktrace) {
        try {
            if (this.mRemoteLogger == null) {
                this.mFallbackLogger.log(pStacktrace);
            } else {
                this.mRemoteLogger.log("MCSide: ", pStacktrace);
            }
            pStacktrace.printStackTrace();
        }
        catch (RemoteException pE) {
            this.log(pE);
            this.mFallbackLogger.log(pStacktrace);
        }
    }

    @Override
    public void log(@NotNull String pText, @NotNull Throwable pStacktrace) {
        try {
            if (this.mRemoteLogger == null) {
                this.mFallbackLogger.log(pText, pStacktrace);
            } else {
                this.mRemoteLogger.log("MCSide: " + pText, pStacktrace);
            }
            System.err.println(pText);
            pStacktrace.printStackTrace();
        }
        catch (RemoteException pE) {
            this.log(pE);
            this.mFallbackLogger.log(pText, pStacktrace);
        }
    }

    @Override
    public void log(@NotNull RemoteException pRemoteException) {
        pRemoteException.printStackTrace();
        this.mFallbackLogger.log(pRemoteException);
    }

    @Override
    public void deinitializeRemoteLogger() {
        this.mRemoteLogger = null;
    }
}

