/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.manager;

import de.maggicraft.ism.manager.ESetting;
import de.maggicraft.mcommons.settings.ISetting;
import de.maggicraft.mcommons.settings.MBooleanSetting;
import de.maggicraft.mcommons.settings.MIntegerSetting;
import de.maggicraft.mcommons.settings.MListSetting;
import de.maggicraft.mcommons.settings.MStorableSettings;
import de.maggicraft.mcommons.settings.MTextSetting;
import de.maggicraft.mioutil.json.IUniqueID;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CSettings {
    public static MStorableSettings sSettings;
    @NotNull
    public static final MTextSetting SET_NAME;
    @NotNull
    public static final MListSetting SETTING_COLOR_SCHEME;
    @NotNull
    public static final MListSetting SETTING_LANG;
    @NotNull
    public static final MListSetting SETTING_OPEN_WIN;
    @NotNull
    public static final MListSetting SETTING_DROP_EXPLORER;
    @NotNull
    public static final MListSetting SETTING_MINECRAFT_CLOSED;
    @NotNull
    public static final MIntegerSetting SETTING_RES_QUANTITY;
    @NotNull
    public static final MBooleanSetting SETTING_FLATTEN_AREA;
    @NotNull
    public static final MBooleanSetting SETTING_FLATTEN_REPOS;
    @NotNull
    public static final MBooleanSetting SETTING_DROP_SURVIVAL;
    @NotNull
    public static final MBooleanSetting SETTING_SHOW_TIPS;
    @NotNull
    public static final MBooleanSetting SETTING_VIEW_RES;
    @NotNull
    public static final MBooleanSetting SETTING_VIEW_CRE;
    @NotNull
    public static final MBooleanSetting SETTING_VIEW_STRUCTURES;
    @NotNull
    public static final MBooleanSetting SETTING_VIEW_LOCALS;
    @NotNull
    public static final MBooleanSetting SETTING_VIEW_ADDED;
    @NotNull
    public static final MBooleanSetting SETTING_VIEW_STR_LIST;
    @NotNull
    public static final MBooleanSetting SETTING_SORT_BY_DATE;
    @NotNull
    public static final MBooleanSetting SETTING_WARN_CLOSE_ISM;
    @NotNull
    public static final String MC_CLOSED_ASK = "ask";
    @NotNull
    public static final String MC_CLOSED_KEEP_ISM_OPEN = "keepISMOpen";
    @NotNull
    public static final String MC_CLOSED_CLOSE_ISM = "closeISM";

    private CSettings() {
    }

    public static void init(@NotNull File pFile) {
        sSettings = new MStorableSettings(pFile, CSettings.list());
    }

    @NotNull
    private static List<ISetting> list() {
        LinkedList<ISetting> settings = new LinkedList<ISetting>();
        settings.add(SET_NAME);
        settings.add(SETTING_COLOR_SCHEME);
        settings.add(SETTING_LANG);
        settings.add(SETTING_OPEN_WIN);
        settings.add(SETTING_DROP_EXPLORER);
        settings.add(SETTING_MINECRAFT_CLOSED);
        settings.add(SETTING_RES_QUANTITY);
        settings.add(SETTING_FLATTEN_AREA);
        settings.add(SETTING_FLATTEN_REPOS);
        settings.add(SETTING_DROP_SURVIVAL);
        settings.add(SETTING_SHOW_TIPS);
        settings.add(SETTING_VIEW_RES);
        settings.add(SETTING_VIEW_CRE);
        settings.add(SETTING_VIEW_STRUCTURES);
        settings.add(SETTING_VIEW_LOCALS);
        settings.add(SETTING_VIEW_ADDED);
        settings.add(SETTING_VIEW_STR_LIST);
        settings.add(SETTING_SORT_BY_DATE);
        settings.add(SETTING_WARN_CLOSE_ISM);
        return settings;
    }

    public static MStorableSettings getSettings() {
        return sSettings;
    }

    static {
        SET_NAME = new MTextSetting(() -> "MainFrame", "d");
        String[] colors = new String[]{"DarkVader", "Lightsaber"};
        SETTING_COLOR_SCHEME = new MListSetting(ESetting.SETTING_COLOR_SCHEME, "DarkVader", colors);
        String[] languages = new String[]{"English", "German"};
        SETTING_LANG = new MListSetting(ESetting.SETTING_LANG, "English", languages);
        String[] openWin = new String[]{"start", "world", "never"};
        SETTING_OPEN_WIN = new MListSetting(ESetting.SETTING_OPEN_WIN, "start", openWin);
        String[] dropExplorer = new String[]{"anyGM", "creative", "noGM"};
        SETTING_DROP_EXPLORER = new MListSetting(ESetting.SETTING_DROP_EXPLORER, "anyGM", dropExplorer);
        SETTING_MINECRAFT_CLOSED = new MListSetting(ESetting.SETTING_MINECRAFT_CLOSED, MC_CLOSED_ASK, MC_CLOSED_ASK, MC_CLOSED_KEEP_ISM_OPEN, MC_CLOSED_CLOSE_ISM);
        SETTING_RES_QUANTITY = new MIntegerSetting((IUniqueID<String>)ESetting.SETTING_RES_QUANTITY, 50);
        SETTING_FLATTEN_AREA = new MBooleanSetting((IUniqueID<String>)ESetting.SETTING_FLATTEN_AREA, true);
        SETTING_FLATTEN_REPOS = new MBooleanSetting((IUniqueID<String>)ESetting.SETTING_FLATTEN_REPOS, true);
        SETTING_DROP_SURVIVAL = new MBooleanSetting((IUniqueID<String>)ESetting.SETTING_DROP_SURVIVAL, true);
        SETTING_SHOW_TIPS = new MBooleanSetting((IUniqueID<String>)ESetting.SETTING_SHOW_TIPS, true);
        SETTING_VIEW_RES = new MBooleanSetting((IUniqueID<String>)ESetting.SETTING_VIEW_RES, true);
        SETTING_VIEW_CRE = new MBooleanSetting((IUniqueID<String>)ESetting.SETTING_VIEW_CRE, true);
        SETTING_VIEW_STRUCTURES = new MBooleanSetting((IUniqueID<String>)ESetting.SETTING_VIEW_STRUCTURES, true);
        SETTING_VIEW_LOCALS = new MBooleanSetting((IUniqueID<String>)ESetting.SETTING_VIEW_LOCALS, true);
        SETTING_VIEW_ADDED = new MBooleanSetting((IUniqueID<String>)ESetting.SETTING_VIEW_ADDED, true);
        SETTING_VIEW_STR_LIST = new MBooleanSetting((IUniqueID<String>)ESetting.SETTING_VIEW_PROJECT_LIST, true);
        SETTING_SORT_BY_DATE = new MBooleanSetting((IUniqueID<String>)ESetting.SETTING_SORT_BY_DATE, true);
        SETTING_WARN_CLOSE_ISM = new MBooleanSetting((IUniqueID<String>)ESetting.SETTING_WARN_CLOSE_ISM, false);
    }
}

