/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.manager;

import de.maggicraft.mioutil.json.IUID;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum EMinecraftVersion implements IUID
{
    MC_1_7_10("1.7.10"),
    MC_1_8("1.8"),
    MC_1_8_8("1.8.8"),
    MC_1_8_9("1.8.9"),
    MC_1_9("1.9"),
    MC_1_9_4("1.9.4"),
    MC_1_10("1.10"),
    MC_1_10_2("1.10.2"),
    MC_1_11("1.11"),
    MC_1_11_2("1.11.2"),
    MC_1_12("1.12"),
    MC_1_12_1("1.12.1"),
    MC_1_12_2("1.12.2"),
    MC_1_13_2("1.13.2"),
    MC_1_14_2("1.14.2"),
    MC_1_14_3("1.14.3"),
    MC_1_14_4("1.14.4"),
    MC_1_15("1.15"),
    MC_1_15_1("1.15.1"),
    MC_1_15_2("1.15.2"),
    MC_1_16_1("1.16.1"),
    DEV("Dev1.16.1");

    private static final Map<String, EMinecraftVersion> MINECRAFT_VERSION;
    @NotNull
    private final String mVersionName;

    @NotNull
    public static EMinecraftVersion fromName(@NotNull String pMinecraftVersion) {
        EMinecraftVersion version = MINECRAFT_VERSION.get(pMinecraftVersion);
        if (version == null) {
            throw new IllegalArgumentException("unknown version for name \"" + pMinecraftVersion + '\"');
        }
        return version;
    }

    private EMinecraftVersion(String pVersionName) {
        this.mVersionName = pVersionName;
    }

    @Override
    @NotNull
    public String getUID() {
        return this.mVersionName;
    }

    static {
        MINECRAFT_VERSION = new HashMap<String, EMinecraftVersion>(EMinecraftVersion.values().length);
        for (EMinecraftVersion version : EMinecraftVersion.values()) {
            MINECRAFT_VERSION.put(version.mVersionName, version);
        }
    }
}

