/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.manager;

import de.maggicraft.ism.analytics.trackers.TrackCopyProtection;
import de.maggicraft.ism.analytics.trackers.TrackStart;
import de.maggicraft.ism.gui.MFIllegal;
import de.maggicraft.ism.gui.MFUpdate;
import de.maggicraft.ism.gui.MViewStatus;
import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.manager.IUpdateManager;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mioutil.io.MIOUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class UpdateManager
implements IUpdateManager {
    private String mISMVersion;
    private String mMinecraftVersion;
    private List<String> mRegistered;
    private File mFileReg;
    private String mUrlUpdateLog;
    private String mPath;
    private boolean mLegal;

    public UpdateManager(@NotNull String pISMVersion, @NotNull String pMinecraftVersion) {
        this.mISMVersion = pISMVersion;
        this.mMinecraftVersion = pMinecraftVersion;
    }

    public UpdateManager(@NotNull File pFileReg, @NotNull String pISMVersion, @NotNull String pMinecraftVersion) {
        this.mFileReg = pFileReg;
        this.mISMVersion = pISMVersion;
        this.mMinecraftVersion = pMinecraftVersion;
    }

    public UpdateManager() {
    }

    private static boolean hasUpdate(@NotNull String pLine) {
        char last = pLine.charAt(pLine.length() - 1);
        if (last == 't') {
            return true;
        }
        if (last == 'f') {
            return false;
        }
        throw new IllegalArgumentException("illegal format");
    }

    private static void showIllegalDialog() {
        MFIllegal.openIllegalFrame();
    }

    private static String jarName(@NotNull String pPath) {
        String jar = ".jar!";
        if (pPath.contains(".jar!")) {
            pPath = pPath.substring(0, pPath.indexOf(".jar!") + ".jar!".length());
        }
        if (pPath.contains(CCon.SEP)) {
            pPath = pPath.substring(pPath.lastIndexOf(CCon.SEP));
        }
        return pPath;
    }

    @Override
    public void initialize() {
        if (this.mISMVersion == null) {
            this.mISMVersion = ISMContainer.getVersionHolder().getCombinedVersion();
        }
        if (this.mMinecraftVersion == null) {
            this.mMinecraftVersion = ISMContainer.getVersionHolder().getMinecraftVersion();
        }
        this.initFileReg();
        this.mLegal = this.checkISMVersion();
        TrackStart.trackStart(this.mLegal);
    }

    public UpdateManager initFileReg() {
        this.mFileReg = new File(MCon.appFolder().getParentFile().getParentFile(), "ims.rg");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkISMVersion() {
        StringBuilder sb = new StringBuilder(ISMContainer.getVersionHolder().getCombinedVersion());
        boolean action = false;
        boolean isRegistered = this.isRegistered();
        boolean isOutdated = this.isOutdated();
        boolean isWhitelisted = false;
        boolean isOriginalName = false;
        sb.append("rg: ").append(isRegistered).append(", od: ").append(isOutdated);
        this.mLegal = isRegistered;
        if (isRegistered) {
            if (isOutdated) {
                action = true;
                this.showUpdateDialog();
            }
        } else {
            try {
                action = true;
                isWhitelisted = this.checkIsLegal();
                isOriginalName = this.isOriginalName();
                sb.append(", wl: ").append(isWhitelisted).append(", on: ").append(isOriginalName);
                boolean bl = this.mLegal = isWhitelisted && isOriginalName;
                if (this.mLegal) {
                    if (!isOutdated) {
                        this.register();
                    }
                } else {
                    UpdateManager.showIllegalDialog();
                }
            }
            catch (Exception pE) {
                ISMContainer.getLogger().log(pE);
            }
            finally {
                if (isOutdated && this.mLegal) {
                    this.showUpdateDialog();
                }
            }
        }
        if (action) {
            String desc = sb.toString();
            ISMContainer.getLogger().log(desc);
            TrackCopyProtection.trackCopyProtection(this.mPath, this.mLegal, isRegistered, isOutdated, isWhitelisted, isOriginalName);
        }
        return this.mLegal;
    }

    public boolean isRegistered() {
        if (!this.mFileReg.exists()) {
            return false;
        }
        Optional<String> text = MIOUtil.readCompressedStr(this.mFileReg);
        if (text.isPresent()) {
            try {
                JSONObject json = (JSONObject)new JSONParser().parse(text.get());
                JSONArray msg = (JSONArray)json.get("reg");
                if (msg == null) {
                    return false;
                }
                this.mRegistered = new ArrayList<String>(msg.size());
                for (Object objRegId : msg) {
                    String regId = (String)objRegId;
                    this.mRegistered.add(regId);
                    if (!regId.equals(this.mISMVersion)) continue;
                    return true;
                }
                return false;
            }
            catch (ParseException pE) {
                ISMContainer.getLogger().log(pE);
                return true;
            }
        }
        return true;
    }

    public boolean isOutdated() {
        String url = "https://instant-structures-mod.com/update" + this.mMinecraftVersion + ".txt";
        return SharedUtil.loadResource(url, pInputStream -> {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)pInputStream));
            while ((line = in.readLine()) != null) {
                if (line.startsWith(this.mISMVersion)) {
                    in.close();
                    return UpdateManager.hasUpdate(line);
                }
                if (this.mUrlUpdateLog != null || !line.startsWith("posts")) continue;
                this.mUrlUpdateLog = line;
            }
            in.close();
            return false;
        }, Boolean.valueOf(false));
    }

    public boolean checkIsLegal() {
        String url = "https://instant-structures-mod.com/blacklist.txt";
        return SharedUtil.loadResource(url, pInputStream -> {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)pInputStream));
            while ((line = in.readLine()) != null) {
                if (!line.equals(this.mISMVersion) && !line.equals(this.mISMVersion + " MC-" + this.mMinecraftVersion)) continue;
                in.close();
                pInputStream.close();
                return false;
            }
            return true;
        }, Boolean.valueOf(true));
    }

    private void showUpdateDialog() {
        MViewStatus.showUpdate();
        MFUpdate.setUrlUpdateLog(this.mUrlUpdateLog);
        new MFUpdate();
    }

    public boolean isOriginalName() {
        boolean isOriginalName = false;
        isOriginalName = true;
        String path = UpdateManager.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        this.mPath = UpdateManager.jarName(path);
        return isOriginalName || path.contains(ISMContainer.getVersionHolder().getModID()) && path.contains(this.mISMVersion) && path.contains(this.mMinecraftVersion);
    }

    public void register() {
        JSONObject json = new JSONObject();
        json.put("vers", "1");
        JSONArray list = new JSONArray();
        if (this.mRegistered != null) {
            list.addAll(this.mRegistered);
        }
        if (!list.contains(this.mISMVersion)) {
            list.add(this.mISMVersion);
        }
        json.put("reg", list);
        MIOUtil.write(this.mFileReg, json.toJSONString(), true);
    }

    @Override
    public boolean isLegal() {
        return this.mLegal;
    }

    public String getUrlUpdateLog() {
        return this.mUrlUpdateLog;
    }

    public File getFileReg() {
        return this.mFileReg;
    }
}

