/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.mapper;

import de.maggicraft.ism.mapper.IBlockStateMapper;
import de.maggicraft.ism.mapper.IdMeta;
import de.maggicraft.ism.mapper.UnifiedStateName;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.registry.Registry;
import org.jetbrains.annotations.NotNull;

public final class BlockStateMapper
implements IBlockStateMapper {
    public static final int MAP_SIZE = 4096;
    public BlockState[] mMapping;
    private static final UnifiedStateName[] STATES = new UnifiedStateName[4096];

    @NotNull
    private static BlockState[] createMappingImpl() {
        BlockState[] states = new BlockState[4096];
        Map<BlockState, UnifiedStateName> stateToUnified = BlockStateMapper.stateToUnified();
        Map<UnifiedStateName, IdMeta> unifiedToIdMeta = BlockStateMapper.unifiedToIDMeta();
        for (Map.Entry<BlockState, UnifiedStateName> entry : stateToUnified.entrySet()) {
            int hash;
            BlockState state = entry.getKey();
            UnifiedStateName unified = entry.getValue();
            IdMeta idMeta = unifiedToIdMeta.get(unified);
            if (idMeta == null || states[hash = idMeta.hashCode()] != null) continue;
            states[hash] = state;
        }
        BlockStateMapper.populateAir(states);
        return states;
    }

    private static Map<UnifiedStateName, IdMeta> unifiedToIDMeta() {
        HashMap<UnifiedStateName, IdMeta> map = new HashMap<UnifiedStateName, IdMeta>(1800);
        for (int i = 0; i < STATES.length; ++i) {
            map.put(STATES[i], new IdMeta(BlockStateMapper.getID(i), BlockStateMapper.getMeta(i)));
        }
        return map;
    }

    private static int getID(int pIdMeta) {
        return pIdMeta >> 4;
    }

    private static int getMeta(int pIdMeta) {
        return pIdMeta % 16;
    }

    @NotNull
    private static Map<BlockState, UnifiedStateName> stateToUnified() {
        HashMap<BlockState, UnifiedStateName> map = new HashMap<BlockState, UnifiedStateName>();
        for (Block block : Registry.field_212618_g) {
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                if (state.toString().contains("waterlogged=true")) continue;
                map.put(state, new UnifiedStateName(state.toString()));
            }
        }
        return map;
    }

    private static void populateAir(BlockState[] pStates) {
        for (int i = 0; i < pStates.length; ++i) {
            if (pStates[i] != null) continue;
            pStates[i] = Blocks.field_150350_a.func_176223_P();
        }
    }

    @Override
    public void initialize() {
        this.mMapping = BlockStateMapper.createMappingImpl();
    }

    @Override
    @NotNull
    public BlockState[] getMapping() {
        return this.mMapping;
    }

    static {
        BlockStateMapper.STATES[2805] = UnifiedStateName.create("minecraft:peony[half=lower]");
        BlockStateMapper.STATES[2549] = UnifiedStateName.create("minecraft:lime_terracotta[]");
        BlockStateMapper.STATES[2824] = UnifiedStateName.create("minecraft:white_banner[rotation=8]");
        BlockStateMapper.STATES[1715] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=east,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[465] = UnifiedStateName.create("minecraft:sticky_piston[extended=false,facing=up]");
        BlockStateMapper.STATES[2083] = UnifiedStateName.create("minecraft:ender_chest[facing=south]");
        BlockStateMapper.STATES[2544] = UnifiedStateName.create("minecraft:white_terracotta[]");
        BlockStateMapper.STATES[4042] = UnifiedStateName.create("minecraft:purple_concrete_powder[]");
        BlockStateMapper.STATES[1146] = UnifiedStateName.create("minecraft:iron_door[facing=east,half=upper,hinge=left,open=false,powered=true]");
        BlockStateMapper.STATES[1669] = UnifiedStateName.create("minecraft:pumpkin_stem[age=5]");
        BlockStateMapper.STATES[3255] = UnifiedStateName.create("minecraft:purpur_stairs[facing=north,half=top,shape=straight]");
        BlockStateMapper.STATES[3936] = UnifiedStateName.create("minecraft:blue_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[892] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=12,south=none,west=none]");
        BlockStateMapper.STATES[3144] = UnifiedStateName.create("minecraft:acacia_door[facing=east,half=upper,hinge=left,open=false,powered=false]");
        BlockStateMapper.STATES[2246] = UnifiedStateName.create("minecraft:potted_jungle_sapling[]");
        BlockStateMapper.STATES[1516] = UnifiedStateName.create("minecraft:repeater[delay=4,facing=south,locked=false,powered=true]");
        BlockStateMapper.STATES[1696] = UnifiedStateName.create("minecraft:vine[east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[1550] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=west,half=top,open=true,powered=true]");
        BlockStateMapper.STATES[3141] = UnifiedStateName.create("minecraft:acacia_door[facing=south,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[2950] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=north,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[2823] = UnifiedStateName.create("minecraft:white_banner[rotation=7]");
        BlockStateMapper.STATES[1360] = UnifiedStateName.create("minecraft:oak_fence[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[3665] = UnifiedStateName.create("minecraft:purple_shulker_box[facing=up]");
        BlockStateMapper.STATES[1670] = UnifiedStateName.create("minecraft:pumpkin_stem[age=6]");
        BlockStateMapper.STATES[2656] = UnifiedStateName.create("minecraft:barrier[]");
        BlockStateMapper.STATES[3172] = UnifiedStateName.create("minecraft:end_rod[facing=west]");
        BlockStateMapper.STATES[3923] = UnifiedStateName.create("minecraft:purple_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[1497] = UnifiedStateName.create("minecraft:repeater[delay=3,facing=west,locked=false,powered=false]");
        BlockStateMapper.STATES[1029] = UnifiedStateName.create("minecraft:oak_door[facing=south,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[1936] = UnifiedStateName.create("minecraft:end_stone[]");
        BlockStateMapper.STATES[2474] = UnifiedStateName.create("minecraft:hopper[enabled=false,facing=north]");
        BlockStateMapper.STATES[1424] = UnifiedStateName.create("minecraft:glowstone[]");
        BlockStateMapper.STATES[2106] = UnifiedStateName.create("minecraft:tripwire_hook[attached=false,facing=north,powered=true]");
        BlockStateMapper.STATES[2394] = UnifiedStateName.create("minecraft:comparator[facing=north,mode=compare,powered=false]");
        BlockStateMapper.STATES[3938] = UnifiedStateName.create("minecraft:blue_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[208] = UnifiedStateName.create("minecraft:gravel[]");
        BlockStateMapper.STATES[417] = UnifiedStateName.create("minecraft:red_bed[facing=west,occupied=false,part=foot]");
        BlockStateMapper.STATES[2822] = UnifiedStateName.create("minecraft:white_banner[rotation=6]");
        BlockStateMapper.STATES[2120] = UnifiedStateName.create("minecraft:tripwire[attached=false,disarmed=true,east=false,north=false,powered=false,south=false,west=false]");
        BlockStateMapper.STATES[1671] = UnifiedStateName.create("minecraft:pumpkin_stem[age=7]");
        BlockStateMapper.STATES[2475] = UnifiedStateName.create("minecraft:hopper[enabled=false,facing=south]");
        BlockStateMapper.STATES[477] = UnifiedStateName.create("minecraft:sticky_piston[extended=true,facing=east]");
        BlockStateMapper.STATES[530] = UnifiedStateName.create("minecraft:piston[extended=false,facing=north]");
        BlockStateMapper.STATES[2821] = UnifiedStateName.create("minecraft:white_banner[rotation=5]");
        BlockStateMapper.STATES[3685] = UnifiedStateName.create("minecraft:blue_shulker_box[facing=east]");
        BlockStateMapper.STATES[2752] = UnifiedStateName.create("minecraft:terracotta[]");
        BlockStateMapper.STATES[1712] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=south,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[1588] = UnifiedStateName.create("minecraft:brown_mushroom_block[down=false,east=false,north=false,south=false,up=true,west=true]");
        BlockStateMapper.STATES[2998] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=north,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[2820] = UnifiedStateName.create("minecraft:white_banner[rotation=4]");
        BlockStateMapper.STATES[1648] = UnifiedStateName.create("minecraft:melon[]");
        BlockStateMapper.STATES[2997] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=west,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[2811] = UnifiedStateName.create("minecraft:large_fern[half=upper]");
        BlockStateMapper.STATES[3491] = UnifiedStateName.create("minecraft:observer[facing=south,powered=false]");
        BlockStateMapper.STATES[3987] = UnifiedStateName.create("minecraft:red_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[1587] = UnifiedStateName.create("minecraft:brown_mushroom_block[down=false,east=true,north=true,south=false,up=true,west=false]");
        BlockStateMapper.STATES[2538] = UnifiedStateName.create("minecraft:dropper[facing=north,triggered=true]");
        BlockStateMapper.STATES[4044] = UnifiedStateName.create("minecraft:brown_concrete_powder[]");
        BlockStateMapper.STATES[820] = UnifiedStateName.create("minecraft:fire[age=4,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[2253] = UnifiedStateName.create("minecraft:potted_dark_oak_sapling[]");
        BlockStateMapper.STATES[2244] = UnifiedStateName.create("minecraft:potted_spruce_sapling[]");
        BlockStateMapper.STATES[4001] = UnifiedStateName.create("minecraft:black_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[4083] = UnifiedStateName.create("minecraft:structure_block[mode=data]");
        BlockStateMapper.STATES[3098] = UnifiedStateName.create("minecraft:spruce_door[facing=east,half=upper,hinge=left,open=false,powered=true]");
        BlockStateMapper.STATES[2965] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=west,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[1064] = UnifiedStateName.create("minecraft:rail[shape=north_west]");
        BlockStateMapper.STATES[2819] = UnifiedStateName.create("minecraft:white_banner[rotation=3]");
        BlockStateMapper.STATES[3571] = UnifiedStateName.create("minecraft:yellow_shulker_box[facing=south]");
        BlockStateMapper.STATES[3600] = UnifiedStateName.create("minecraft:pink_shulker_box[facing=down]");
        BlockStateMapper.STATES[2320] = UnifiedStateName.create("minecraft:anvil[facing=south]");
        BlockStateMapper.STATES[2301] = UnifiedStateName.create("minecraft:oak_button[face=floor,facing=south,powered=true]");
        BlockStateMapper.STATES[2942] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=north,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[2082] = UnifiedStateName.create("minecraft:ender_chest[facing=north]");
        BlockStateMapper.STATES[2818] = UnifiedStateName.create("minecraft:white_banner[rotation=2]");
        BlockStateMapper.STATES[3827] = UnifiedStateName.create("minecraft:yellow_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[2341] = UnifiedStateName.create("minecraft:trapped_chest[facing=east,type=single]");
        BlockStateMapper.STATES[1093] = UnifiedStateName.create("minecraft:wall_sign[facing=east]");
        BlockStateMapper.STATES[3733] = UnifiedStateName.create("minecraft:red_shulker_box[facing=east]");
        BlockStateMapper.STATES[2750] = UnifiedStateName.create("minecraft:red_carpet[]");
        BlockStateMapper.STATES[2992] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=south,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[1735] = UnifiedStateName.create("minecraft:brick_stairs[facing=north,half=top,shape=straight]");
        BlockStateMapper.STATES[1537] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=south,half=bottom,open=false,powered=false]");
        BlockStateMapper.STATES[2532] = UnifiedStateName.create("minecraft:dropper[facing=west,triggered=false]");
        BlockStateMapper.STATES[3145] = UnifiedStateName.create("minecraft:acacia_door[facing=east,half=upper,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3873] = UnifiedStateName.create("minecraft:gray_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[3111] = UnifiedStateName.create("minecraft:birch_door[facing=north,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[2817] = UnifiedStateName.create("minecraft:white_banner[rotation=1]");
        BlockStateMapper.STATES[801] = UnifiedStateName.create("minecraft:wall_torch[facing=east]");
        BlockStateMapper.STATES[384] = UnifiedStateName.create("minecraft:sandstone[]");
        BlockStateMapper.STATES[1026] = UnifiedStateName.create("minecraft:oak_door[facing=west,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[2392] = UnifiedStateName.create("minecraft:comparator[facing=south,mode=compare,powered=false]");
        BlockStateMapper.STATES[3669] = UnifiedStateName.create("minecraft:purple_shulker_box[facing=east]");
        BlockStateMapper.STATES[1521] = UnifiedStateName.create("minecraft:orange_stained_glass[]");
        BlockStateMapper.STATES[2322] = UnifiedStateName.create("minecraft:anvil[facing=north]");
        BlockStateMapper.STATES[891] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=11,south=none,west=none]");
        BlockStateMapper.STATES[1591] = UnifiedStateName.create("minecraft:brown_mushroom_block[down=false,east=false,north=false,south=true,up=true,west=true]");
        BlockStateMapper.STATES[2525] = UnifiedStateName.create("minecraft:activator_rail[powered=true,shape=ascending_south]");
        BlockStateMapper.STATES[2356] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=4]");
        BlockStateMapper.STATES[98] = UnifiedStateName.create("minecraft:birch_sapling[stage=0]");
        BlockStateMapper.STATES[2880] = UnifiedStateName.create("minecraft:red_sandstone_stairs[facing=east,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2177] = UnifiedStateName.create("minecraft:jungle_stairs[facing=west,half=bottom,shape=straight]");
        BlockStateMapper.STATES[1025] = UnifiedStateName.create("minecraft:oak_door[facing=south,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[2936] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=south,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[2800] = UnifiedStateName.create("minecraft:sunflower[half=lower]");
        BlockStateMapper.STATES[1220] = UnifiedStateName.create("minecraft:redstone_wall_torch[facing=north,lit=true]");
        BlockStateMapper.STATES[2339] = UnifiedStateName.create("minecraft:trapped_chest[facing=south,type=single]");
        BlockStateMapper.STATES[3536] = UnifiedStateName.create("minecraft:magenta_shulker_box[facing=down]");
        BlockStateMapper.STATES[1616] = UnifiedStateName.create("minecraft:iron_bars[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[893] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=13,south=none,west=none]");
        BlockStateMapper.STATES[2355] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=3]");
        BlockStateMapper.STATES[3520] = UnifiedStateName.create("minecraft:orange_shulker_box[facing=down]");
        BlockStateMapper.STATES[710] = UnifiedStateName.create("minecraft:nether_brick_slab[type=bottom]");
        BlockStateMapper.STATES[1552] = UnifiedStateName.create("minecraft:infested_stone[]");
        BlockStateMapper.STATES[1925] = UnifiedStateName.create("minecraft:end_portal_frame[eye=true,facing=west]");
        BlockStateMapper.STATES[3137] = UnifiedStateName.create("minecraft:acacia_door[facing=south,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[2572] = UnifiedStateName.create("minecraft:brown_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[2358] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=6]");
        BlockStateMapper.STATES[285] = UnifiedStateName.create("minecraft:spruce_wood[]");
        BlockStateMapper.STATES[1377] = UnifiedStateName.create("minecraft:carved_pumpkin[facing=west]");
        BlockStateMapper.STATES[2148] = UnifiedStateName.create("minecraft:spruce_stairs[facing=east,half=top,shape=straight]");
        BlockStateMapper.STATES[378] = UnifiedStateName.create("minecraft:dispenser[facing=north,triggered=true]");
        BlockStateMapper.STATES[2990] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=north,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[640] = UnifiedStateName.create("minecraft:red_mushroom[]");
        BlockStateMapper.STATES[2025] = UnifiedStateName.create("minecraft:spruce_slab[type=top]");
        BlockStateMapper.STATES[3158] = UnifiedStateName.create("minecraft:dark_oak_door[facing=west,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[2357] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=5]");
        BlockStateMapper.STATES[106] = UnifiedStateName.create("minecraft:birch_sapling[stage=1]");
        BlockStateMapper.STATES[2016] = UnifiedStateName.create("minecraft:oak_slab[type=bottom]");
        BlockStateMapper.STATES[2100] = UnifiedStateName.create("minecraft:tripwire_hook[attached=true,facing=south,powered=false]");
        BlockStateMapper.STATES[1608] = UnifiedStateName.create("minecraft:red_mushroom_block[down=false,east=false,north=false,south=true,up=true,west=false]");
        BlockStateMapper.STATES[2200] = UnifiedStateName.create("minecraft:command_block[conditional=true,facing=down]");
        BlockStateMapper.STATES[2531] = UnifiedStateName.create("minecraft:dropper[facing=south,triggered=false]");
        BlockStateMapper.STATES[576] = UnifiedStateName.create("minecraft:moving_piston[facing=down,type=normal]");
        BlockStateMapper.STATES[3652] = UnifiedStateName.create("minecraft:cyan_shulker_box[facing=west]");
        BlockStateMapper.STATES[3130] = UnifiedStateName.create("minecraft:jungle_door[facing=east,half=upper,hinge=left,open=false,powered=true]");
        BlockStateMapper.STATES[2952] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=south,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[2743] = UnifiedStateName.create("minecraft:gray_carpet[]");
        BlockStateMapper.STATES[3537] = UnifiedStateName.create("minecraft:magenta_shulker_box[facing=up]");
        BlockStateMapper.STATES[2560] = UnifiedStateName.create("minecraft:white_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[2360] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=8]");
        BlockStateMapper.STATES[556] = UnifiedStateName.create("minecraft:piston_head[facing=west,short=false,type=sticky]");
        BlockStateMapper.STATES[3589] = UnifiedStateName.create("minecraft:lime_shulker_box[facing=east]");
        BlockStateMapper.STATES[1698] = UnifiedStateName.create("minecraft:vine[east=false,north=false,south=false,up=false,west=true]");
        BlockStateMapper.STATES[3857] = UnifiedStateName.create("minecraft:pink_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[3500] = UnifiedStateName.create("minecraft:observer[facing=west,powered=true]");
        BlockStateMapper.STATES[2724] = UnifiedStateName.create("minecraft:hay_block[axis=x]");
        BlockStateMapper.STATES[2501] = UnifiedStateName.create("minecraft:quartz_stairs[facing=west,half=top,shape=straight]");
        BlockStateMapper.STATES[851] = UnifiedStateName.create("minecraft:oak_stairs[facing=north,half=bottom,shape=outer_right]");
        BlockStateMapper.STATES[2802] = UnifiedStateName.create("minecraft:tall_grass[half=lower]");
        BlockStateMapper.STATES[2359] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=7]");
        BlockStateMapper.STATES[3841] = UnifiedStateName.create("minecraft:lime_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[3570] = UnifiedStateName.create("minecraft:yellow_shulker_box[facing=north]");
        BlockStateMapper.STATES[3697] = UnifiedStateName.create("minecraft:brown_shulker_box[facing=up]");
        BlockStateMapper.STATES[2720] = UnifiedStateName.create("minecraft:hay_block[axis=y]");
        BlockStateMapper.STATES[3092] = UnifiedStateName.create("minecraft:spruce_door[facing=east,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[1878] = UnifiedStateName.create("minecraft:brewing_stand[has_bottle_0=false,has_bottle_1=true,has_bottle_2=true]");
        BlockStateMapper.STATES[2912] = UnifiedStateName.create("minecraft:red_sandstone_slab[type=bottom]");
        BlockStateMapper.STATES[3136] = UnifiedStateName.create("minecraft:acacia_door[facing=east,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[1033] = UnifiedStateName.create("minecraft:oak_door[facing=east,half=upper,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[4037] = UnifiedStateName.create("minecraft:lime_concrete_powder[]");
        BlockStateMapper.STATES[1505] = UnifiedStateName.create("minecraft:repeater[delay=1,facing=west,locked=false,powered=true]");
        BlockStateMapper.STATES[2958] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=north,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[1280] = UnifiedStateName.create("minecraft:snow_block[]");
        BlockStateMapper.STATES[3387] = UnifiedStateName.create("minecraft:chain_command_block[conditional=true,facing=south]");
        BlockStateMapper.STATES[2197] = UnifiedStateName.create("minecraft:command_block[conditional=false,facing=east]");
        BlockStateMapper.STATES[2825] = UnifiedStateName.create("minecraft:white_banner[rotation=9]");
        BlockStateMapper.STATES[944] = UnifiedStateName.create("minecraft:wheat[age=0]");
        BlockStateMapper.STATES[2728] = UnifiedStateName.create("minecraft:hay_block[axis=z]");
        BlockStateMapper.STATES[1145] = UnifiedStateName.create("minecraft:iron_door[facing=east,half=upper,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[2980] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=south,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[2255] = UnifiedStateName.create("minecraft:potted_allium[]");
        BlockStateMapper.STATES[2361] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=9]");
        BlockStateMapper.STATES[287] = UnifiedStateName.create("minecraft:jungle_wood[]");
        BlockStateMapper.STATES[569] = UnifiedStateName.create("minecraft:cyan_wool[]");
        BlockStateMapper.STATES[1078] = UnifiedStateName.create("minecraft:cobblestone_stairs[facing=south,half=top,shape=straight]");
        BlockStateMapper.STATES[4040] = UnifiedStateName.create("minecraft:light_gray_concrete_powder[]");
        BlockStateMapper.STATES[1341] = UnifiedStateName.create("minecraft:sugar_cane[age=13]");
        BlockStateMapper.STATES[2831] = UnifiedStateName.create("minecraft:white_banner[rotation=15]");
        BlockStateMapper.STATES[2145] = UnifiedStateName.create("minecraft:spruce_stairs[facing=west,half=bottom,shape=straight]");
        BlockStateMapper.STATES[945] = UnifiedStateName.create("minecraft:wheat[age=1]");
        BlockStateMapper.STATES[3096] = UnifiedStateName.create("minecraft:spruce_door[facing=east,half=upper,hinge=left,open=false,powered=false]");
        BlockStateMapper.STATES[2741] = UnifiedStateName.create("minecraft:lime_carpet[]");
        BlockStateMapper.STATES[1077] = UnifiedStateName.create("minecraft:cobblestone_stairs[facing=west,half=top,shape=straight]");
        BlockStateMapper.STATES[1020] = UnifiedStateName.create("minecraft:sign[rotation=12]");
        BlockStateMapper.STATES[3986] = UnifiedStateName.create("minecraft:red_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[176] = UnifiedStateName.create("minecraft:lava[level=0]");
        BlockStateMapper.STATES[855] = UnifiedStateName.create("minecraft:oak_stairs[facing=north,half=top,shape=outer_right]");
        BlockStateMapper.STATES[2393] = UnifiedStateName.create("minecraft:comparator[facing=west,mode=compare,powered=false]");
        BlockStateMapper.STATES[2624] = UnifiedStateName.create("minecraft:dark_oak_stairs[facing=east,half=bottom,shape=straight]");
        BlockStateMapper.STATES[1924] = UnifiedStateName.create("minecraft:end_portal_frame[eye=true,facing=south]");
        BlockStateMapper.STATES[1340] = UnifiedStateName.create("minecraft:sugar_cane[age=12]");
        BlockStateMapper.STATES[3699] = UnifiedStateName.create("minecraft:brown_shulker_box[facing=south]");
        BlockStateMapper.STATES[3602] = UnifiedStateName.create("minecraft:pink_shulker_box[facing=north]");
        BlockStateMapper.STATES[3744] = UnifiedStateName.create("minecraft:black_shulker_box[facing=down]");
        BlockStateMapper.STATES[2161] = UnifiedStateName.create("minecraft:birch_stairs[facing=west,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2113] = UnifiedStateName.create("minecraft:tripwire[attached=false,disarmed=false,east=false,north=false,powered=true,south=false,west=false]");
        BlockStateMapper.STATES[3072] = UnifiedStateName.create("minecraft:acacia_fence[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[946] = UnifiedStateName.create("minecraft:wheat[age=2]");
        BlockStateMapper.STATES[380] = UnifiedStateName.create("minecraft:dispenser[facing=west,triggered=true]");
        BlockStateMapper.STATES[1118] = UnifiedStateName.create("minecraft:lever[face=floor,facing=north,powered=true]");
        BlockStateMapper.STATES[1598] = UnifiedStateName.create("minecraft:brown_mushroom_block[down=true,east=true,north=true,south=true,up=true,west=true]");
        BlockStateMapper.STATES[1021] = UnifiedStateName.create("minecraft:sign[rotation=13]");
        BlockStateMapper.STATES[50] = UnifiedStateName.create("minecraft:podzol[snowy=false]");
        BlockStateMapper.STATES[1104] = UnifiedStateName.create("minecraft:lever[face=ceiling,facing=north,powered=false]");
        BlockStateMapper.STATES[1121] = UnifiedStateName.create("minecraft:stone_pressure_plate[powered=true]");
        BlockStateMapper.STATES[803] = UnifiedStateName.create("minecraft:wall_torch[facing=south]");
        BlockStateMapper.STATES[1697] = UnifiedStateName.create("minecraft:vine[east=false,north=false,south=true,up=false,west=false]");
        BlockStateMapper.STATES[2296] = UnifiedStateName.create("minecraft:oak_button[face=ceiling,facing=south,powered=true]");
        BlockStateMapper.STATES[1729] = UnifiedStateName.create("minecraft:brick_stairs[facing=west,half=bottom,shape=straight]");
        BlockStateMapper.STATES[529] = UnifiedStateName.create("minecraft:piston[extended=false,facing=up]");
        BlockStateMapper.STATES[1339] = UnifiedStateName.create("minecraft:sugar_cane[age=11]");
        BlockStateMapper.STATES[2486] = UnifiedStateName.create("minecraft:quartz_pillar[axis=x]");
        BlockStateMapper.STATES[3761] = UnifiedStateName.create("minecraft:white_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[947] = UnifiedStateName.create("minecraft:wheat[age=3]");
        BlockStateMapper.STATES[1018] = UnifiedStateName.create("minecraft:sign[rotation=10]");
        BlockStateMapper.STATES[2738] = UnifiedStateName.create("minecraft:magenta_carpet[]");
        BlockStateMapper.STATES[82] = UnifiedStateName.create("minecraft:birch_planks[]");
        BlockStateMapper.STATES[2121] = UnifiedStateName.create("minecraft:tripwire[attached=false,disarmed=true,east=false,north=false,powered=true,south=false,west=false]");
        BlockStateMapper.STATES[2978] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=north,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[1555] = UnifiedStateName.create("minecraft:infested_mossy_stone_bricks[]");
        BlockStateMapper.STATES[2934] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=north,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[1493] = UnifiedStateName.create("minecraft:repeater[delay=2,facing=west,locked=false,powered=false]");
        BlockStateMapper.STATES[178] = UnifiedStateName.create("minecraft:lava[level=2]");
        BlockStateMapper.STATES[2677] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=south,half=bottom,open=true]");
        BlockStateMapper.STATES[416] = UnifiedStateName.create("minecraft:red_bed[facing=south,occupied=false,part=foot]");
        BlockStateMapper.STATES[1338] = UnifiedStateName.create("minecraft:sugar_cane[age=10]");
        BlockStateMapper.STATES[948] = UnifiedStateName.create("minecraft:wheat[age=4]");
        BlockStateMapper.STATES[896] = UnifiedStateName.create("minecraft:diamond_ore[]");
        BlockStateMapper.STATES[1140] = UnifiedStateName.create("minecraft:iron_door[facing=east,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[1551] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=east,half=top,open=true,powered=true]");
        BlockStateMapper.STATES[2482] = UnifiedStateName.create("minecraft:quartz_pillar[axis=y]");
        BlockStateMapper.STATES[2551] = UnifiedStateName.create("minecraft:gray_terracotta[]");
        BlockStateMapper.STATES[193] = UnifiedStateName.create("minecraft:red_sand[]");
        BlockStateMapper.STATES[1019] = UnifiedStateName.create("minecraft:sign[rotation=11]");
        BlockStateMapper.STATES[177] = UnifiedStateName.create("minecraft:lava[level=1]");
        BlockStateMapper.STATES[890] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=10,south=none,west=none]");
        BlockStateMapper.STATES[889] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=9,south=none,west=none]");
        BlockStateMapper.STATES[2521] = UnifiedStateName.create("minecraft:activator_rail[powered=true,shape=east_west]");
        BlockStateMapper.STATES[1506] = UnifiedStateName.create("minecraft:repeater[delay=1,facing=north,locked=false,powered=true]");
        BlockStateMapper.STATES[2340] = UnifiedStateName.create("minecraft:trapped_chest[facing=west,type=single]");
        BlockStateMapper.STATES[949] = UnifiedStateName.create("minecraft:wheat[age=5]");
        BlockStateMapper.STATES[3568] = UnifiedStateName.create("minecraft:yellow_shulker_box[facing=down]");
        BlockStateMapper.STATES[3524] = UnifiedStateName.create("minecraft:orange_shulker_box[facing=west]");
        BlockStateMapper.STATES[2490] = UnifiedStateName.create("minecraft:quartz_pillar[axis=z]");
        BlockStateMapper.STATES[1241] = UnifiedStateName.create("minecraft:stone_button[face=wall,facing=east,powered=true]");
        BlockStateMapper.STATES[2827] = UnifiedStateName.create("minecraft:white_banner[rotation=11]");
        BlockStateMapper.STATES[2929] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=west,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[2352] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=0]");
        BlockStateMapper.STATES[16] = UnifiedStateName.create("minecraft:stone[]");
        BlockStateMapper.STATES[3649] = UnifiedStateName.create("minecraft:cyan_shulker_box[facing=up]");
        BlockStateMapper.STATES[3603] = UnifiedStateName.create("minecraft:pink_shulker_box[facing=south]");
        BlockStateMapper.STATES[578] = UnifiedStateName.create("minecraft:moving_piston[facing=north,type=normal]");
        BlockStateMapper.STATES[1501] = UnifiedStateName.create("minecraft:repeater[delay=4,facing=west,locked=false,powered=false]");
        BlockStateMapper.STATES[186] = UnifiedStateName.create("minecraft:lava[level=10]");
        BlockStateMapper.STATES[451] = UnifiedStateName.create("minecraft:detector_rail[powered=false,shape=ascending_west]");
        BlockStateMapper.STATES[672] = UnifiedStateName.create("minecraft:iron_block[]");
        BlockStateMapper.STATES[2112] = UnifiedStateName.create("minecraft:tripwire[attached=false,disarmed=false,east=false,north=false,powered=false,south=false,west=false]");
        BlockStateMapper.STATES[581] = UnifiedStateName.create("minecraft:moving_piston[facing=east,type=normal]");
        BlockStateMapper.STATES[3984] = UnifiedStateName.create("minecraft:red_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[2749] = UnifiedStateName.create("minecraft:green_carpet[]");
        BlockStateMapper.STATES[2027] = UnifiedStateName.create("minecraft:jungle_slab[type=top]");
        BlockStateMapper.STATES[950] = UnifiedStateName.create("minecraft:wheat[age=6]");
        BlockStateMapper.STATES[2182] = UnifiedStateName.create("minecraft:jungle_stairs[facing=south,half=top,shape=straight]");
        BlockStateMapper.STATES[3488] = UnifiedStateName.create("minecraft:observer[facing=down,powered=false]");
        BlockStateMapper.STATES[2306] = UnifiedStateName.create("minecraft:skeleton_wall_skull[facing=north]");
        BlockStateMapper.STATES[2828] = UnifiedStateName.create("minecraft:white_banner[rotation=12]");
        BlockStateMapper.STATES[704] = UnifiedStateName.create("minecraft:stone_slab[type=bottom]");
        BlockStateMapper.STATES[2605] = UnifiedStateName.create("minecraft:dark_oak_wood[]");
        BlockStateMapper.STATES[1062] = UnifiedStateName.create("minecraft:rail[shape=south_east]");
        BlockStateMapper.STATES[3147] = UnifiedStateName.create("minecraft:acacia_door[facing=east,half=upper,hinge=right,open=false,powered=true]");
        BlockStateMapper.STATES[4036] = UnifiedStateName.create("minecraft:yellow_concrete_powder[]");
        BlockStateMapper.STATES[2613] = UnifiedStateName.create("minecraft:acacia_stairs[facing=west,half=top,shape=straight]");
        BlockStateMapper.STATES[2085] = UnifiedStateName.create("minecraft:ender_chest[facing=east]");
        BlockStateMapper.STATES[2331] = UnifiedStateName.create("minecraft:damaged_anvil[facing=east]");
        BlockStateMapper.STATES[2829] = UnifiedStateName.create("minecraft:white_banner[rotation=13]");
        BlockStateMapper.STATES[951] = UnifiedStateName.create("minecraft:wheat[age=7]");
        BlockStateMapper.STATES[3523] = UnifiedStateName.create("minecraft:orange_shulker_box[facing=south]");
        BlockStateMapper.STATES[824] = UnifiedStateName.create("minecraft:fire[age=8,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[1022] = UnifiedStateName.create("minecraft:sign[rotation=14]");
        BlockStateMapper.STATES[2524] = UnifiedStateName.create("minecraft:activator_rail[powered=true,shape=ascending_north]");
        BlockStateMapper.STATES[2167] = UnifiedStateName.create("minecraft:birch_stairs[facing=north,half=top,shape=straight]");
        BlockStateMapper.STATES[2885] = UnifiedStateName.create("minecraft:red_sandstone_stairs[facing=west,half=top,shape=straight]");
        BlockStateMapper.STATES[2049] = UnifiedStateName.create("minecraft:sandstone_stairs[facing=west,half=bottom,shape=straight]");
        BlockStateMapper.STATES[4033] = UnifiedStateName.create("minecraft:orange_concrete_powder[]");
        BlockStateMapper.STATES[3698] = UnifiedStateName.create("minecraft:brown_shulker_box[facing=north]");
        BlockStateMapper.STATES[549] = UnifiedStateName.create("minecraft:piston_head[facing=east,short=false,type=normal]");
        BlockStateMapper.STATES[2019] = UnifiedStateName.create("minecraft:jungle_slab[type=bottom]");
        BlockStateMapper.STATES[2354] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=2]");
        BlockStateMapper.STATES[3153] = UnifiedStateName.create("minecraft:dark_oak_door[facing=south,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[1138] = UnifiedStateName.create("minecraft:iron_door[facing=west,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[188] = UnifiedStateName.create("minecraft:lava[level=12]");
        BlockStateMapper.STATES[1724] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=south,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[1110] = UnifiedStateName.create("minecraft:lever[face=floor,facing=north,powered=false]");
        BlockStateMapper.STATES[1632] = UnifiedStateName.create("minecraft:glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[711] = UnifiedStateName.create("minecraft:quartz_slab[type=bottom]");
        BlockStateMapper.STATES[2520] = UnifiedStateName.create("minecraft:activator_rail[powered=true,shape=north_south]");
        BlockStateMapper.STATES[2830] = UnifiedStateName.create("minecraft:white_banner[rotation=14]");
        BlockStateMapper.STATES[1023] = UnifiedStateName.create("minecraft:sign[rotation=15]");
        BlockStateMapper.STATES[1540] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=north,half=bottom,open=true,powered=true]");
        BlockStateMapper.STATES[1141] = UnifiedStateName.create("minecraft:iron_door[facing=south,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[580] = UnifiedStateName.create("minecraft:moving_piston[facing=west,type=normal]");
        BlockStateMapper.STATES[2353] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=1]");
        BlockStateMapper.STATES[3888] = UnifiedStateName.create("minecraft:light_gray_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[3373] = UnifiedStateName.create("minecraft:repeating_command_block[conditional=true,facing=east]");
        BlockStateMapper.STATES[449] = UnifiedStateName.create("minecraft:detector_rail[powered=false,shape=east_west]");
        BlockStateMapper.STATES[1392] = UnifiedStateName.create("minecraft:netherrack[]");
        BlockStateMapper.STATES[2496] = UnifiedStateName.create("minecraft:quartz_stairs[facing=east,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2411] = UnifiedStateName.create("minecraft:comparator[facing=east,mode=compare,powered=true]");
        BlockStateMapper.STATES[187] = UnifiedStateName.create("minecraft:lava[level=11]");
        BlockStateMapper.STATES[421] = UnifiedStateName.create("minecraft:red_bed[facing=west,occupied=true,part=foot]");
        BlockStateMapper.STATES[2308] = UnifiedStateName.create("minecraft:skeleton_wall_skull[facing=west]");
        BlockStateMapper.STATES[2481] = UnifiedStateName.create("minecraft:chiseled_quartz_block[]");
        BlockStateMapper.STATES[3795] = UnifiedStateName.create("minecraft:magenta_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[2816] = UnifiedStateName.create("minecraft:white_banner[rotation=0]");
        BlockStateMapper.STATES[3460] = UnifiedStateName.create("minecraft:bone_block[axis=x]");
        BlockStateMapper.STATES[184] = UnifiedStateName.create("minecraft:lava[level=8]");
        BlockStateMapper.STATES[997] = UnifiedStateName.create("minecraft:furnace[facing=east,lit=true]");
        BlockStateMapper.STATES[190] = UnifiedStateName.create("minecraft:lava[level=14]");
        BlockStateMapper.STATES[2415] = UnifiedStateName.create("minecraft:comparator[facing=east,mode=subtract,powered=true]");
        BlockStateMapper.STATES[273] = UnifiedStateName.create("minecraft:spruce_log[axis=y]");
        BlockStateMapper.STATES[3095] = UnifiedStateName.create("minecraft:spruce_door[facing=north,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[2554] = UnifiedStateName.create("minecraft:purple_terracotta[]");
        BlockStateMapper.STATES[3381] = UnifiedStateName.create("minecraft:chain_command_block[conditional=false,facing=east]");
        BlockStateMapper.STATES[2690] = UnifiedStateName.create("minecraft:dark_prismarine[]");
        BlockStateMapper.STATES[183] = UnifiedStateName.create("minecraft:lava[level=7]");
        BlockStateMapper.STATES[3456] = UnifiedStateName.create("minecraft:bone_block[axis=y]");
        BlockStateMapper.STATES[3379] = UnifiedStateName.create("minecraft:chain_command_block[conditional=false,facing=south]");
        BlockStateMapper.STATES[1722] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=north,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[189] = UnifiedStateName.create("minecraft:lava[level=13]");
        BlockStateMapper.STATES[610] = UnifiedStateName.create("minecraft:allium[]");
        BlockStateMapper.STATES[2864] = UnifiedStateName.create("minecraft:red_sandstone[]");
        BlockStateMapper.STATES[281] = UnifiedStateName.create("minecraft:spruce_log[axis=z]");
        BlockStateMapper.STATES[2809] = UnifiedStateName.create("minecraft:lilac[half=upper]");
        BlockStateMapper.STATES[585] = UnifiedStateName.create("minecraft:moving_piston[facing=up,type=sticky]");
        BlockStateMapper.STATES[895] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=15,south=none,west=none]");
        BlockStateMapper.STATES[2193] = UnifiedStateName.create("minecraft:command_block[conditional=false,facing=up]");
        BlockStateMapper.STATES[3040] = UnifiedStateName.create("minecraft:jungle_fence[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[2183] = UnifiedStateName.create("minecraft:jungle_stairs[facing=north,half=top,shape=straight]");
        BlockStateMapper.STATES[1593] = UnifiedStateName.create("minecraft:brown_mushroom_block[down=false,east=true,north=false,south=true,up=true,west=false]");
        BlockStateMapper.STATES[2904] = UnifiedStateName.create("minecraft:smooth_red_sandstone[]");
        BlockStateMapper.STATES[2096] = UnifiedStateName.create("minecraft:tripwire_hook[attached=false,facing=south,powered=false]");
        BlockStateMapper.STATES[546] = UnifiedStateName.create("minecraft:piston_head[facing=north,short=false,type=normal]");
        BlockStateMapper.STATES[2970] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=north,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[2102] = UnifiedStateName.create("minecraft:tripwire_hook[attached=true,facing=north,powered=false]");
        BlockStateMapper.STATES[2826] = UnifiedStateName.create("minecraft:white_banner[rotation=10]");
        BlockStateMapper.STATES[3378] = UnifiedStateName.create("minecraft:chain_command_block[conditional=false,facing=north]");
        BlockStateMapper.STATES[1554] = UnifiedStateName.create("minecraft:infested_stone_bricks[]");
        BlockStateMapper.STATES[185] = UnifiedStateName.create("minecraft:lava[level=9]");
        BlockStateMapper.STATES[1923] = UnifiedStateName.create("minecraft:end_portal_frame[eye=false,facing=east]");
        BlockStateMapper.STATES[3499] = UnifiedStateName.create("minecraft:observer[facing=south,powered=true]");
        BlockStateMapper.STATES[442] = UnifiedStateName.create("minecraft:powered_rail[powered=true,shape=ascending_east]");
        BlockStateMapper.STATES[4034] = UnifiedStateName.create("minecraft:magenta_concrete_powder[]");
        BlockStateMapper.STATES[191] = UnifiedStateName.create("minecraft:lava[level=15]");
        BlockStateMapper.STATES[277] = UnifiedStateName.create("minecraft:spruce_log[axis=x]");
        BlockStateMapper.STATES[80] = UnifiedStateName.create("minecraft:oak_planks[]");
        BlockStateMapper.STATES[3163] = UnifiedStateName.create("minecraft:dark_oak_door[facing=east,half=upper,hinge=right,open=false,powered=true]");
        BlockStateMapper.STATES[3000] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=south,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[1115] = UnifiedStateName.create("minecraft:lever[face=wall,facing=south,powered=true]");
        BlockStateMapper.STATES[180] = UnifiedStateName.create("minecraft:lava[level=4]");
        BlockStateMapper.STATES[2529] = UnifiedStateName.create("minecraft:dropper[facing=up,triggered=false]");
        BlockStateMapper.STATES[2001] = UnifiedStateName.create("minecraft:spruce_slab[type=double]");
        BlockStateMapper.STATES[1058] = UnifiedStateName.create("minecraft:rail[shape=ascending_east]");
        BlockStateMapper.STATES[540] = UnifiedStateName.create("minecraft:piston[extended=true,facing=west]");
        BlockStateMapper.STATES[437] = UnifiedStateName.create("minecraft:powered_rail[powered=false,shape=ascending_south]");
        BlockStateMapper.STATES[3388] = UnifiedStateName.create("minecraft:chain_command_block[conditional=true,facing=west]");
        BlockStateMapper.STATES[1073] = UnifiedStateName.create("minecraft:cobblestone_stairs[facing=west,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2477] = UnifiedStateName.create("minecraft:hopper[enabled=false,facing=east]");
        BlockStateMapper.STATES[2993] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=west,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[825] = UnifiedStateName.create("minecraft:fire[age=9,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[1732] = UnifiedStateName.create("minecraft:brick_stairs[facing=east,half=top,shape=straight]");
        BlockStateMapper.STATES[2744] = UnifiedStateName.create("minecraft:light_gray_carpet[]");
        BlockStateMapper.STATES[4023] = UnifiedStateName.create("minecraft:gray_concrete[]");
        BlockStateMapper.STATES[179] = UnifiedStateName.create("minecraft:lava[level=3]");
        BlockStateMapper.STATES[2024] = UnifiedStateName.create("minecraft:oak_slab[type=top]");
        BlockStateMapper.STATES[1703] = UnifiedStateName.create("minecraft:vine[east=false,north=true,south=true,up=false,west=true]");
        BlockStateMapper.STATES[1492] = UnifiedStateName.create("minecraft:repeater[delay=2,facing=south,locked=false,powered=false]");
        BlockStateMapper.STATES[1600] = UnifiedStateName.create("minecraft:red_mushroom_block[down=false,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[1343] = UnifiedStateName.create("minecraft:sugar_cane[age=15]");
        BlockStateMapper.STATES[561] = UnifiedStateName.create("minecraft:orange_wool[]");
        BlockStateMapper.STATES[3557] = UnifiedStateName.create("minecraft:light_blue_shulker_box[facing=east]");
        BlockStateMapper.STATES[3464] = UnifiedStateName.create("minecraft:bone_block[axis=z]");
        BlockStateMapper.STATES[182] = UnifiedStateName.create("minecraft:lava[level=6]");
        BlockStateMapper.STATES[474] = UnifiedStateName.create("minecraft:sticky_piston[extended=true,facing=north]");
        BlockStateMapper.STATES[1030] = UnifiedStateName.create("minecraft:oak_door[facing=west,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[1139] = UnifiedStateName.create("minecraft:iron_door[facing=north,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[2247] = UnifiedStateName.create("minecraft:potted_red_mushroom[]");
        BlockStateMapper.STATES[616] = UnifiedStateName.create("minecraft:oxeye_daisy[]");
        BlockStateMapper.STATES[1524] = UnifiedStateName.create("minecraft:yellow_stained_glass[]");
        BlockStateMapper.STATES[4022] = UnifiedStateName.create("minecraft:pink_concrete[]");
        BlockStateMapper.STATES[1342] = UnifiedStateName.create("minecraft:sugar_cane[age=14]");
        BlockStateMapper.STATES[804] = UnifiedStateName.create("minecraft:wall_torch[facing=north]");
        BlockStateMapper.STATES[3138] = UnifiedStateName.create("minecraft:acacia_door[facing=west,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[181] = UnifiedStateName.create("minecraft:lava[level=5]");
        BlockStateMapper.STATES[2307] = UnifiedStateName.create("minecraft:skeleton_wall_skull[facing=south]");
        BlockStateMapper.STATES[2865] = UnifiedStateName.create("minecraft:chiseled_red_sandstone[]");
        BlockStateMapper.STATES[867] = UnifiedStateName.create("minecraft:chest[facing=south,type=single]");
        BlockStateMapper.STATES[2555] = UnifiedStateName.create("minecraft:blue_terracotta[]");
        BlockStateMapper.STATES[706] = UnifiedStateName.create("minecraft:petrified_oak_slab[type=bottom]");
        BlockStateMapper.STATES[1489] = UnifiedStateName.create("minecraft:repeater[delay=1,facing=west,locked=false,powered=false]");
        BlockStateMapper.STATES[2020] = UnifiedStateName.create("minecraft:acacia_slab[type=bottom]");
        BlockStateMapper.STATES[1153] = UnifiedStateName.create("minecraft:oak_pressure_plate[powered=true]");
        BlockStateMapper.STATES[2291] = UnifiedStateName.create("minecraft:oak_button[face=wall,facing=south,powered=false]");
        BlockStateMapper.STATES[2036] = UnifiedStateName.create("minecraft:cocoa[age=1,facing=south]");
        BlockStateMapper.STATES[1605] = UnifiedStateName.create("minecraft:red_mushroom_block[down=false,east=false,north=false,south=false,up=true,west=false]");
        BlockStateMapper.STATES[1511] = UnifiedStateName.create("minecraft:repeater[delay=2,facing=east,locked=false,powered=true]");
        BlockStateMapper.STATES[3128] = UnifiedStateName.create("minecraft:jungle_door[facing=east,half=upper,hinge=left,open=false,powered=false]");
        BlockStateMapper.STATES[2945] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=west,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[2962] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=north,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[693] = UnifiedStateName.create("minecraft:stone_brick_slab[type=double]");
        BlockStateMapper.STATES[149] = UnifiedStateName.create("minecraft:water[level=5]");
        BlockStateMapper.STATES[2427] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=11]");
        BlockStateMapper.STATES[2195] = UnifiedStateName.create("minecraft:command_block[conditional=false,facing=south]");
        BlockStateMapper.STATES[1568] = UnifiedStateName.create("minecraft:stone_bricks[]");
        BlockStateMapper.STATES[827] = UnifiedStateName.create("minecraft:fire[age=11,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[2687] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=east,half=top,open=true]");
        BlockStateMapper.STATES[148] = UnifiedStateName.create("minecraft:water[level=4]");
        BlockStateMapper.STATES[819] = UnifiedStateName.create("minecraft:fire[age=3,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[2378] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=10]");
        BlockStateMapper.STATES[3939] = UnifiedStateName.create("minecraft:blue_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[614] = UnifiedStateName.create("minecraft:white_tulip[]");
        BlockStateMapper.STATES[2428] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=12]");
        BlockStateMapper.STATES[256] = UnifiedStateName.create("minecraft:coal_ore[]");
        BlockStateMapper.STATES[3621] = UnifiedStateName.create("minecraft:gray_shulker_box[facing=east]");
        BlockStateMapper.STATES[1031] = UnifiedStateName.create("minecraft:oak_door[facing=north,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[2038] = UnifiedStateName.create("minecraft:cocoa[age=1,facing=north]");
        BlockStateMapper.STATES[562] = UnifiedStateName.create("minecraft:magenta_wool[]");
        BlockStateMapper.STATES[2615] = UnifiedStateName.create("minecraft:acacia_stairs[facing=north,half=top,shape=straight]");
        BlockStateMapper.STATES[3159] = UnifiedStateName.create("minecraft:dark_oak_door[facing=north,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[147] = UnifiedStateName.create("minecraft:water[level=3]");
        BlockStateMapper.STATES[586] = UnifiedStateName.create("minecraft:moving_piston[facing=north,type=sticky]");
        BlockStateMapper.STATES[3498] = UnifiedStateName.create("minecraft:observer[facing=north,powered=true]");
        BlockStateMapper.STATES[2429] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=13]");
        BlockStateMapper.STATES[3521] = UnifiedStateName.create("minecraft:orange_shulker_box[facing=up]");
        BlockStateMapper.STATES[2951] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=east,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[887] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=7,south=none,west=none]");
        BlockStateMapper.STATES[1510] = UnifiedStateName.create("minecraft:repeater[delay=2,facing=north,locked=false,powered=true]");
        BlockStateMapper.STATES[3108] = UnifiedStateName.create("minecraft:birch_door[facing=east,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[3680] = UnifiedStateName.create("minecraft:blue_shulker_box[facing=down]");
        BlockStateMapper.STATES[608] = UnifiedStateName.create("minecraft:poppy[]");
        BlockStateMapper.STATES[3681] = UnifiedStateName.create("minecraft:blue_shulker_box[facing=up]");
        BlockStateMapper.STATES[805] = UnifiedStateName.create("minecraft:torch[]");
        BlockStateMapper.STATES[146] = UnifiedStateName.create("minecraft:water[level=2]");
        BlockStateMapper.STATES[2688] = UnifiedStateName.create("minecraft:prismarine[]");
        BlockStateMapper.STATES[2430] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=14]");
        BlockStateMapper.STATES[2250] = UnifiedStateName.create("minecraft:potted_dead_bush[]");
        BlockStateMapper.STATES[4029] = UnifiedStateName.create("minecraft:green_concrete[]");
        BlockStateMapper.STATES[472] = UnifiedStateName.create("minecraft:sticky_piston[extended=true,facing=down]");
        BlockStateMapper.STATES[2920] = UnifiedStateName.create("minecraft:red_sandstone_slab[type=top]");
        BlockStateMapper.STATES[153] = UnifiedStateName.create("minecraft:water[level=9]");
        BlockStateMapper.STATES[2021] = UnifiedStateName.create("minecraft:dark_oak_slab[type=bottom]");
        BlockStateMapper.STATES[2028] = UnifiedStateName.create("minecraft:acacia_slab[type=top]");
        BlockStateMapper.STATES[2043] = UnifiedStateName.create("minecraft:cocoa[age=2,facing=east]");
        BlockStateMapper.STATES[2981] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=west,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[2034] = UnifiedStateName.create("minecraft:cocoa[age=0,facing=north]");
        BlockStateMapper.STATES[1952] = UnifiedStateName.create("minecraft:dragon_egg[]");
        BlockStateMapper.STATES[1529] = UnifiedStateName.create("minecraft:cyan_stained_glass[]");
        BlockStateMapper.STATES[768] = UnifiedStateName.create("minecraft:mossy_cobblestone[]");
        BlockStateMapper.STATES[2179] = UnifiedStateName.create("minecraft:jungle_stairs[facing=north,half=bottom,shape=straight]");
        BlockStateMapper.STATES[441] = UnifiedStateName.create("minecraft:powered_rail[powered=true,shape=east_west]");
        BlockStateMapper.STATES[4028] = UnifiedStateName.create("minecraft:brown_concrete[]");
        BlockStateMapper.STATES[3380] = UnifiedStateName.create("minecraft:chain_command_block[conditional=false,facing=west]");
        BlockStateMapper.STATES[2971] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=east,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[3605] = UnifiedStateName.create("minecraft:pink_shulker_box[facing=east]");
        BlockStateMapper.STATES[152] = UnifiedStateName.create("minecraft:water[level=8]");
        BlockStateMapper.STATES[2550] = UnifiedStateName.create("minecraft:pink_terracotta[]");
        BlockStateMapper.STATES[1136] = UnifiedStateName.create("minecraft:iron_door[facing=east,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[2163] = UnifiedStateName.create("minecraft:birch_stairs[facing=north,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2513] = UnifiedStateName.create("minecraft:activator_rail[powered=false,shape=east_west]");
        BlockStateMapper.STATES[456] = UnifiedStateName.create("minecraft:detector_rail[powered=true,shape=north_south]");
        BlockStateMapper.STATES[3097] = UnifiedStateName.create("minecraft:spruce_door[facing=east,half=upper,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[4082] = UnifiedStateName.create("minecraft:structure_block[mode=corner]");
        BlockStateMapper.STATES[460] = UnifiedStateName.create("minecraft:detector_rail[powered=true,shape=ascending_north]");
        BlockStateMapper.STATES[2194] = UnifiedStateName.create("minecraft:command_block[conditional=false,facing=north]");
        BlockStateMapper.STATES[689] = UnifiedStateName.create("minecraft:sandstone_slab[type=double]");
        BlockStateMapper.STATES[2298] = UnifiedStateName.create("minecraft:oak_button[face=wall,facing=west,powered=true]");
        BlockStateMapper.STATES[151] = UnifiedStateName.create("minecraft:water[level=7]");
        BlockStateMapper.STATES[555] = UnifiedStateName.create("minecraft:piston_head[facing=south,short=false,type=sticky]");
        BlockStateMapper.STATES[852] = UnifiedStateName.create("minecraft:oak_stairs[facing=east,half=top,shape=outer_right]");
        BlockStateMapper.STATES[1921] = UnifiedStateName.create("minecraft:end_portal_frame[eye=false,facing=west]");
        BlockStateMapper.STATES[1571] = UnifiedStateName.create("minecraft:chiseled_stone_bricks[]");
        BlockStateMapper.STATES[1243] = UnifiedStateName.create("minecraft:stone_button[face=wall,facing=south,powered=true]");
        BlockStateMapper.STATES[150] = UnifiedStateName.create("minecraft:water[level=6]");
        BlockStateMapper.STATES[692] = UnifiedStateName.create("minecraft:brick_slab[type=double]");
        BlockStateMapper.STATES[2686] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=west,half=top,open=true]");
        BlockStateMapper.STATES[2426] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=10]");
        BlockStateMapper.STATES[2561] = UnifiedStateName.create("minecraft:orange_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[2804] = UnifiedStateName.create("minecraft:rose_bush[half=lower]");
        BlockStateMapper.STATES[1312] = UnifiedStateName.create("minecraft:clay[]");
        BlockStateMapper.STATES[2574] = UnifiedStateName.create("minecraft:red_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[3776] = UnifiedStateName.create("minecraft:orange_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[2866] = UnifiedStateName.create("minecraft:cut_red_sandstone[]");
        BlockStateMapper.STATES[2514] = UnifiedStateName.create("minecraft:activator_rail[powered=false,shape=ascending_east]");
        BlockStateMapper.STATES[3492] = UnifiedStateName.create("minecraft:observer[facing=west,powered=false]");
        BlockStateMapper.STATES[587] = UnifiedStateName.create("minecraft:moving_piston[facing=south,type=sticky]");
        BlockStateMapper.STATES[2149] = UnifiedStateName.create("minecraft:spruce_stairs[facing=west,half=top,shape=straight]");
        BlockStateMapper.STATES[320] = UnifiedStateName.create("minecraft:glass[]");
        BlockStateMapper.STATES[1526] = UnifiedStateName.create("minecraft:pink_stained_glass[]");
        BlockStateMapper.STATES[2954] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=north,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[1027] = UnifiedStateName.create("minecraft:oak_door[facing=north,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3525] = UnifiedStateName.create("minecraft:orange_shulker_box[facing=east]");
        BlockStateMapper.STATES[3093] = UnifiedStateName.create("minecraft:spruce_door[facing=south,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[2836] = UnifiedStateName.create("minecraft:white_wall_banner[facing=west]");
        BlockStateMapper.STATES[2737] = UnifiedStateName.create("minecraft:orange_carpet[]");
        BlockStateMapper.STATES[1874] = UnifiedStateName.create("minecraft:brewing_stand[has_bottle_0=false,has_bottle_1=true,has_bottle_2=false]");
        BlockStateMapper.STATES[2565] = UnifiedStateName.create("minecraft:lime_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[3507] = UnifiedStateName.create("minecraft:white_shulker_box[facing=south]");
        BlockStateMapper.STATES[461] = UnifiedStateName.create("minecraft:detector_rail[powered=true,shape=ascending_south]");
        BlockStateMapper.STATES[1702] = UnifiedStateName.create("minecraft:vine[east=false,north=true,south=false,up=false,west=true]");
        BlockStateMapper.STATES[3249] = UnifiedStateName.create("minecraft:purpur_stairs[facing=west,half=bottom,shape=straight]");
        BlockStateMapper.STATES[3633] = UnifiedStateName.create("minecraft:light_gray_shulker_box[facing=up]");
        BlockStateMapper.STATES[3778] = UnifiedStateName.create("minecraft:orange_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[2383] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=15]");
        BlockStateMapper.STATES[2562] = UnifiedStateName.create("minecraft:magenta_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[3890] = UnifiedStateName.create("minecraft:light_gray_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[3490] = UnifiedStateName.create("minecraft:observer[facing=north,powered=false]");
        BlockStateMapper.STATES[1219] = UnifiedStateName.create("minecraft:redstone_wall_torch[facing=south,lit=true]");
        BlockStateMapper.STATES[2476] = UnifiedStateName.create("minecraft:hopper[enabled=false,facing=west]");
        BlockStateMapper.STATES[3700] = UnifiedStateName.create("minecraft:brown_shulker_box[facing=west]");
        BlockStateMapper.STATES[3169] = UnifiedStateName.create("minecraft:end_rod[facing=up]");
        BlockStateMapper.STATES[994] = UnifiedStateName.create("minecraft:furnace[facing=north,lit=true]");
        BlockStateMapper.STATES[1458] = UnifiedStateName.create("minecraft:jack_o_lantern[facing=north]");
        BlockStateMapper.STATES[2039] = UnifiedStateName.create("minecraft:cocoa[age=1,facing=east]");
        BlockStateMapper.STATES[3363] = UnifiedStateName.create("minecraft:repeating_command_block[conditional=false,facing=south]");
        BlockStateMapper.STATES[2002] = UnifiedStateName.create("minecraft:birch_slab[type=double]");
        BlockStateMapper.STATES[3584] = UnifiedStateName.create("minecraft:lime_shulker_box[facing=down]");
        BlockStateMapper.STATES[3891] = UnifiedStateName.create("minecraft:light_gray_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[707] = UnifiedStateName.create("minecraft:cobblestone_slab[type=bottom]");
        BlockStateMapper.STATES[2098] = UnifiedStateName.create("minecraft:tripwire_hook[attached=false,facing=north,powered=false]");
        BlockStateMapper.STATES[3793] = UnifiedStateName.create("minecraft:magenta_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[422] = UnifiedStateName.create("minecraft:red_bed[facing=north,occupied=true,part=foot]");
        BlockStateMapper.STATES[464] = UnifiedStateName.create("minecraft:sticky_piston[extended=false,facing=down]");
        BlockStateMapper.STATES[2381] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=13]");
        BlockStateMapper.STATES[2944] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=south,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[145] = UnifiedStateName.create("minecraft:water[level=1]");
        BlockStateMapper.STATES[1607] = UnifiedStateName.create("minecraft:red_mushroom_block[down=false,east=false,north=false,south=true,up=true,west=true]");
        BlockStateMapper.STATES[1710] = UnifiedStateName.create("minecraft:vine[east=true,north=true,south=false,up=false,west=true]");
        BlockStateMapper.STATES[296] = UnifiedStateName.create("minecraft:oak_leaves[distance=1,persistent=false]");
        BlockStateMapper.STATES[425] = UnifiedStateName.create("minecraft:red_bed[facing=west,occupied=false,part=head]");
        BlockStateMapper.STATES[2966] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=north,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[2397] = UnifiedStateName.create("minecraft:comparator[facing=west,mode=subtract,powered=false]");
        BlockStateMapper.STATES[2382] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=14]");
        BlockStateMapper.STATES[144] = UnifiedStateName.create("minecraft:water[level=0]");
        BlockStateMapper.STATES[2740] = UnifiedStateName.create("minecraft:yellow_carpet[]");
        BlockStateMapper.STATES[2251] = UnifiedStateName.create("minecraft:potted_fern[]");
        BlockStateMapper.STATES[427] = UnifiedStateName.create("minecraft:red_bed[facing=east,occupied=false,part=head]");
        BlockStateMapper.STATES[459] = UnifiedStateName.create("minecraft:detector_rail[powered=true,shape=ascending_west]");
        BlockStateMapper.STATES[2963] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=east,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[4017] = UnifiedStateName.create("minecraft:orange_concrete[]");
        BlockStateMapper.STATES[1035] = UnifiedStateName.create("minecraft:oak_door[facing=east,half=upper,hinge=right,open=false,powered=true]");
        BlockStateMapper.STATES[584] = UnifiedStateName.create("minecraft:moving_piston[facing=down,type=sticky]");
        BlockStateMapper.STATES[2410] = UnifiedStateName.create("minecraft:comparator[facing=north,mode=compare,powered=true]");
        BlockStateMapper.STATES[2523] = UnifiedStateName.create("minecraft:activator_rail[powered=true,shape=ascending_west]");
        BlockStateMapper.STATES[2379] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=11]");
        BlockStateMapper.STATES[433] = UnifiedStateName.create("minecraft:powered_rail[powered=false,shape=east_west]");
        BlockStateMapper.STATES[1076] = UnifiedStateName.create("minecraft:cobblestone_stairs[facing=east,half=top,shape=straight]");
        BlockStateMapper.STATES[3003] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=east,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[3497] = UnifiedStateName.create("minecraft:observer[facing=up,powered=true]");
        BlockStateMapper.STATES[3090] = UnifiedStateName.create("minecraft:spruce_door[facing=west,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[2567] = UnifiedStateName.create("minecraft:gray_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[2933] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=west,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[1513] = UnifiedStateName.create("minecraft:repeater[delay=3,facing=west,locked=false,powered=true]");
        BlockStateMapper.STATES[1345] = UnifiedStateName.create("minecraft:jukebox[has_record=true]");
        BlockStateMapper.STATES[429] = UnifiedStateName.create("minecraft:red_bed[facing=west,occupied=true,part=head]");
        BlockStateMapper.STATES[2064] = UnifiedStateName.create("minecraft:emerald_ore[]");
        BlockStateMapper.STATES[2330] = UnifiedStateName.create("minecraft:damaged_anvil[facing=north]");
        BlockStateMapper.STATES[1709] = UnifiedStateName.create("minecraft:vine[east=true,north=true,south=true,up=false,west=false]");
        BlockStateMapper.STATES[2380] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=12]");
        BlockStateMapper.STATES[2252] = UnifiedStateName.create("minecraft:potted_acacia_sapling[]");
        BlockStateMapper.STATES[533] = UnifiedStateName.create("minecraft:piston[extended=false,facing=east]");
        BlockStateMapper.STATES[1792] = UnifiedStateName.create("minecraft:nether_bricks[]");
        BlockStateMapper.STATES[1726] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=north,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[3384] = UnifiedStateName.create("minecraft:chain_command_block[conditional=true,facing=down]");
        BlockStateMapper.STATES[2541] = UnifiedStateName.create("minecraft:dropper[facing=east,triggered=true]");
        BlockStateMapper.STATES[292] = UnifiedStateName.create("minecraft:oak_leaves[distance=1,persistent=true]");
        BlockStateMapper.STATES[615] = UnifiedStateName.create("minecraft:pink_tulip[]");
        BlockStateMapper.STATES[1495] = UnifiedStateName.create("minecraft:repeater[delay=2,facing=east,locked=false,powered=false]");
        BlockStateMapper.STATES[3127] = UnifiedStateName.create("minecraft:jungle_door[facing=north,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[575] = UnifiedStateName.create("minecraft:black_wool[]");
        BlockStateMapper.STATES[1808] = UnifiedStateName.create("minecraft:nether_brick_fence[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[2468] = UnifiedStateName.create("minecraft:hopper[enabled=true,facing=west]");
        BlockStateMapper.STATES[2516] = UnifiedStateName.create("minecraft:activator_rail[powered=false,shape=ascending_north]");
        BlockStateMapper.STATES[1541] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=south,half=bottom,open=true,powered=true]");
        BlockStateMapper.STATES[1504] = UnifiedStateName.create("minecraft:repeater[delay=1,facing=south,locked=false,powered=true]");
        BlockStateMapper.STATES[536] = UnifiedStateName.create("minecraft:piston[extended=true,facing=down]");
        BlockStateMapper.STATES[1459] = UnifiedStateName.create("minecraft:jack_o_lantern[facing=east]");
        BlockStateMapper.STATES[435] = UnifiedStateName.create("minecraft:powered_rail[powered=false,shape=ascending_west]");
        BlockStateMapper.STATES[1057] = UnifiedStateName.create("minecraft:rail[shape=east_west]");
        BlockStateMapper.STATES[1105] = UnifiedStateName.create("minecraft:lever[face=wall,facing=east,powered=false]");
        BlockStateMapper.STATES[2801] = UnifiedStateName.create("minecraft:lilac[half=lower]");
        BlockStateMapper.STATES[1535] = UnifiedStateName.create("minecraft:black_stained_glass[]");
        BlockStateMapper.STATES[2941] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=west,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[1016] = UnifiedStateName.create("minecraft:sign[rotation=8]");
        BlockStateMapper.STATES[3572] = UnifiedStateName.create("minecraft:yellow_shulker_box[facing=west]");
        BlockStateMapper.STATES[1336] = UnifiedStateName.create("minecraft:sugar_cane[age=8]");
        BlockStateMapper.STATES[980] = UnifiedStateName.create("minecraft:furnace[facing=west,lit=false]");
        BlockStateMapper.STATES[2327] = UnifiedStateName.create("minecraft:chipped_anvil[facing=east]");
        BlockStateMapper.STATES[419] = UnifiedStateName.create("minecraft:red_bed[facing=east,occupied=false,part=foot]");
        BlockStateMapper.STATES[2736] = UnifiedStateName.create("minecraft:white_carpet[]");
        BlockStateMapper.STATES[1015] = UnifiedStateName.create("minecraft:sign[rotation=7]");
        BlockStateMapper.STATES[2396] = UnifiedStateName.create("minecraft:comparator[facing=south,mode=subtract,powered=false]");
        BlockStateMapper.STATES[1750] = UnifiedStateName.create("minecraft:stone_brick_stairs[facing=south,half=top,shape=straight]");
        BlockStateMapper.STATES[3747] = UnifiedStateName.create("minecraft:black_shulker_box[facing=south]");
        BlockStateMapper.STATES[1335] = UnifiedStateName.create("minecraft:sugar_cane[age=7]");
        BlockStateMapper.STATES[81] = UnifiedStateName.create("minecraft:spruce_planks[]");
        BlockStateMapper.STATES[2947] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=east,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[2568] = UnifiedStateName.create("minecraft:light_gray_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[3666] = UnifiedStateName.create("minecraft:purple_shulker_box[facing=north]");
        BlockStateMapper.STATES[2517] = UnifiedStateName.create("minecraft:activator_rail[powered=false,shape=ascending_south]");
        BlockStateMapper.STATES[2400] = UnifiedStateName.create("minecraft:comparator[facing=south,mode=compare,powered=true]");
        BlockStateMapper.STATES[1875] = UnifiedStateName.create("minecraft:brewing_stand[has_bottle_0=true,has_bottle_1=true,has_bottle_2=false]");
        BlockStateMapper.STATES[1546] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=west,half=top,open=false,powered=false]");
        BlockStateMapper.STATES[712] = UnifiedStateName.create("minecraft:stone_slab[type=top]");
        BlockStateMapper.STATES[1744] = UnifiedStateName.create("minecraft:stone_brick_stairs[facing=east,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2249] = UnifiedStateName.create("minecraft:potted_cactus[]");
        BlockStateMapper.STATES[1106] = UnifiedStateName.create("minecraft:lever[face=wall,facing=west,powered=false]");
        BlockStateMapper.STATES[1045] = UnifiedStateName.create("minecraft:ladder[facing=east]");
        BlockStateMapper.STATES[2005] = UnifiedStateName.create("minecraft:dark_oak_slab[type=double]");
        BlockStateMapper.STATES[104] = UnifiedStateName.create("minecraft:oak_sapling[stage=1]");
        BlockStateMapper.STATES[691] = UnifiedStateName.create("minecraft:cobblestone_slab[type=double]");
        BlockStateMapper.STATES[1719] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=east,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[3129] = UnifiedStateName.create("minecraft:jungle_door[facing=east,half=upper,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3920] = UnifiedStateName.create("minecraft:purple_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[1378] = UnifiedStateName.create("minecraft:carved_pumpkin[facing=north]");
        BlockStateMapper.STATES[1700] = UnifiedStateName.create("minecraft:vine[east=false,north=true,south=false,up=false,west=false]");
        BlockStateMapper.STATES[2018] = UnifiedStateName.create("minecraft:birch_slab[type=bottom]");
        BlockStateMapper.STATES[548] = UnifiedStateName.create("minecraft:piston_head[facing=west,short=false,type=normal]");
        BlockStateMapper.STATES[3288] = UnifiedStateName.create("minecraft:purpur_slab[type=top]");
        BlockStateMapper.STATES[720] = UnifiedStateName.create("minecraft:bricks[]");
        BlockStateMapper.STATES[1017] = UnifiedStateName.create("minecraft:sign[rotation=9]");
        BlockStateMapper.STATES[1984] = UnifiedStateName.create("minecraft:redstone_lamp[lit=true]");
        BlockStateMapper.STATES[1337] = UnifiedStateName.create("minecraft:sugar_cane[age=9]");
        BlockStateMapper.STATES[3810] = UnifiedStateName.create("minecraft:light_blue_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[816] = UnifiedStateName.create("minecraft:fire[age=0,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[1728] = UnifiedStateName.create("minecraft:brick_stairs[facing=east,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2204] = UnifiedStateName.create("minecraft:command_block[conditional=true,facing=west]");
        BlockStateMapper.STATES[3617] = UnifiedStateName.create("minecraft:gray_shulker_box[facing=up]");
        BlockStateMapper.STATES[1137] = UnifiedStateName.create("minecraft:iron_door[facing=south,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[1143] = UnifiedStateName.create("minecraft:iron_door[facing=north,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[2747] = UnifiedStateName.create("minecraft:blue_carpet[]");
        BlockStateMapper.STATES[424] = UnifiedStateName.create("minecraft:red_bed[facing=south,occupied=false,part=head]");
        BlockStateMapper.STATES[457] = UnifiedStateName.create("minecraft:detector_rail[powered=true,shape=east_west]");
        BlockStateMapper.STATES[3125] = UnifiedStateName.create("minecraft:jungle_door[facing=south,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[3971] = UnifiedStateName.create("minecraft:green_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[3509] = UnifiedStateName.create("minecraft:white_shulker_box[facing=east]");
        BlockStateMapper.STATES[373] = UnifiedStateName.create("minecraft:dispenser[facing=east,triggered=false]");
        BlockStateMapper.STATES[881] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=1,south=none,west=none]");
        BlockStateMapper.STATES[1332] = UnifiedStateName.create("minecraft:sugar_cane[age=4]");
        BlockStateMapper.STATES[2943] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=east,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[966] = UnifiedStateName.create("minecraft:farmland[moisture=6]");
        BlockStateMapper.STATES[3905] = UnifiedStateName.create("minecraft:cyan_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[547] = UnifiedStateName.create("minecraft:piston_head[facing=south,short=false,type=normal]");
        BlockStateMapper.STATES[3362] = UnifiedStateName.create("minecraft:repeating_command_block[conditional=false,facing=north]");
        BlockStateMapper.STATES[1032] = UnifiedStateName.create("minecraft:oak_door[facing=east,half=upper,hinge=left,open=false,powered=false]");
        BlockStateMapper.STATES[2896] = UnifiedStateName.create("minecraft:red_sandstone_slab[type=double]");
        BlockStateMapper.STATES[1331] = UnifiedStateName.create("minecraft:sugar_cane[age=3]");
        BlockStateMapper.STATES[1060] = UnifiedStateName.create("minecraft:rail[shape=ascending_north]");
        BlockStateMapper.STATES[588] = UnifiedStateName.create("minecraft:moving_piston[facing=west,type=sticky]");
        BlockStateMapper.STATES[3005] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=west,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[96] = UnifiedStateName.create("minecraft:oak_sapling[stage=0]");
        BlockStateMapper.STATES[1527] = UnifiedStateName.create("minecraft:gray_stained_glass[]");
        BlockStateMapper.STATES[3748] = UnifiedStateName.create("minecraft:black_shulker_box[facing=west]");
        BlockStateMapper.STATES[967] = UnifiedStateName.create("minecraft:farmland[moisture=7]");
        BlockStateMapper.STATES[497] = UnifiedStateName.create("minecraft:grass[]");
        BlockStateMapper.STATES[452] = UnifiedStateName.create("minecraft:detector_rail[powered=false,shape=ascending_north]");
        BlockStateMapper.STATES[713] = UnifiedStateName.create("minecraft:sandstone_slab[type=top]");
        BlockStateMapper.STATES[1609] = UnifiedStateName.create("minecraft:red_mushroom_block[down=false,east=true,north=false,south=true,up=true,west=false]");
        BlockStateMapper.STATES[2577] = UnifiedStateName.create("minecraft:dark_oak_leaves[distance=1,persistent=false]");
        BlockStateMapper.STATES[1512] = UnifiedStateName.create("minecraft:repeater[delay=3,facing=south,locked=false,powered=true]");
        BlockStateMapper.STATES[1548] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=north,half=top,open=true,powered=true]");
        BlockStateMapper.STATES[2882] = UnifiedStateName.create("minecraft:red_sandstone_stairs[facing=south,half=bottom,shape=straight]");
        BlockStateMapper.STATES[3007] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=east,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[1496] = UnifiedStateName.create("minecraft:repeater[delay=3,facing=south,locked=false,powered=false]");
        BlockStateMapper.STATES[1711] = UnifiedStateName.create("minecraft:vine[east=true,north=true,south=true,up=false,west=true]");
        BlockStateMapper.STATES[1334] = UnifiedStateName.create("minecraft:sugar_cane[age=6]");
        BlockStateMapper.STATES[372] = UnifiedStateName.create("minecraft:dispenser[facing=west,triggered=false]");
        BlockStateMapper.STATES[2328] = UnifiedStateName.create("minecraft:damaged_anvil[facing=south]");
        BlockStateMapper.STATES[2948] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=south,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[2573] = UnifiedStateName.create("minecraft:green_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[2628] = UnifiedStateName.create("minecraft:dark_oak_stairs[facing=east,half=top,shape=straight]");
        BlockStateMapper.STATES[430] = UnifiedStateName.create("minecraft:red_bed[facing=north,occupied=true,part=head]");
        BlockStateMapper.STATES[829] = UnifiedStateName.create("minecraft:fire[age=13,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[496] = UnifiedStateName.create("minecraft:dead_bush[]");
        BlockStateMapper.STATES[964] = UnifiedStateName.create("minecraft:farmland[moisture=4]");
        BlockStateMapper.STATES[690] = UnifiedStateName.create("minecraft:petrified_oak_slab[type=double]");
        BlockStateMapper.STATES[3541] = UnifiedStateName.create("minecraft:magenta_shulker_box[facing=east]");
        BlockStateMapper.STATES[817] = UnifiedStateName.create("minecraft:fire[age=1,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[1333] = UnifiedStateName.create("minecraft:sugar_cane[age=5]");
        BlockStateMapper.STATES[965] = UnifiedStateName.create("minecraft:farmland[moisture=5]");
        BlockStateMapper.STATES[1490] = UnifiedStateName.create("minecraft:repeater[delay=1,facing=north,locked=false,powered=false]");
        BlockStateMapper.STATES[3493] = UnifiedStateName.create("minecraft:observer[facing=east,powered=false]");
        BlockStateMapper.STATES[1075] = UnifiedStateName.create("minecraft:cobblestone_stairs[facing=north,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2248] = UnifiedStateName.create("minecraft:potted_brown_mushroom[]");
        BlockStateMapper.STATES[4024] = UnifiedStateName.create("minecraft:light_gray_concrete[]");
        BlockStateMapper.STATES[2964] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=south,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[1008] = UnifiedStateName.create("minecraft:sign[rotation=0]");
        BlockStateMapper.STATES[3553] = UnifiedStateName.create("minecraft:light_blue_shulker_box[facing=up]");
        BlockStateMapper.STATES[3555] = UnifiedStateName.create("minecraft:light_blue_shulker_box[facing=south]");
        BlockStateMapper.STATES[1061] = UnifiedStateName.create("minecraft:rail[shape=ascending_south]");
        BlockStateMapper.STATES[1872] = UnifiedStateName.create("minecraft:brewing_stand[has_bottle_0=false,has_bottle_1=false,has_bottle_2=false]");
        BlockStateMapper.STATES[3712] = UnifiedStateName.create("minecraft:green_shulker_box[facing=down]");
        BlockStateMapper.STATES[557] = UnifiedStateName.create("minecraft:piston_head[facing=east,short=false,type=sticky]");
        BlockStateMapper.STATES[3777] = UnifiedStateName.create("minecraft:orange_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[2580] = UnifiedStateName.create("minecraft:acacia_leaves[distance=1,persistent=true]");
        BlockStateMapper.STATES[962] = UnifiedStateName.create("minecraft:farmland[moisture=2]");
        BlockStateMapper.STATES[3315] = UnifiedStateName.create("minecraft:beetroots[age=3]");
        BlockStateMapper.STATES[3762] = UnifiedStateName.create("minecraft:white_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[611] = UnifiedStateName.create("minecraft:azure_bluet[]");
        BlockStateMapper.STATES[2569] = UnifiedStateName.create("minecraft:cyan_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[3859] = UnifiedStateName.create("minecraft:pink_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[2679] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=east,half=bottom,open=true]");
        BlockStateMapper.STATES[3122] = UnifiedStateName.create("minecraft:jungle_door[facing=west,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3142] = UnifiedStateName.create("minecraft:acacia_door[facing=west,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[963] = UnifiedStateName.create("minecraft:farmland[moisture=3]");
        BlockStateMapper.STATES[1010] = UnifiedStateName.create("minecraft:sign[rotation=2]");
        BlockStateMapper.STATES[1108] = UnifiedStateName.create("minecraft:lever[face=wall,facing=north,powered=false]");
        BlockStateMapper.STATES[3506] = UnifiedStateName.create("minecraft:white_shulker_box[facing=north]");
        BlockStateMapper.STATES[3314] = UnifiedStateName.create("minecraft:beetroots[age=2]");
        BlockStateMapper.STATES[2399] = UnifiedStateName.create("minecraft:comparator[facing=east,mode=subtract,powered=false]");
        BlockStateMapper.STATES[3955] = UnifiedStateName.create("minecraft:brown_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[4016] = UnifiedStateName.create("minecraft:white_concrete[]");
        BlockStateMapper.STATES[2150] = UnifiedStateName.create("minecraft:spruce_stairs[facing=south,half=top,shape=straight]");
        BlockStateMapper.STATES[1570] = UnifiedStateName.create("minecraft:cracked_stone_bricks[]");
        BlockStateMapper.STATES[1109] = UnifiedStateName.create("minecraft:lever[face=floor,facing=east,powered=false]");
        BlockStateMapper.STATES[2610] = UnifiedStateName.create("minecraft:acacia_stairs[facing=south,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2953] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=west,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[960] = UnifiedStateName.create("minecraft:farmland[moisture=0]");
        BlockStateMapper.STATES[1721] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=west,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[1009] = UnifiedStateName.create("minecraft:sign[rotation=1]");
        BlockStateMapper.STATES[3313] = UnifiedStateName.create("minecraft:beetroots[age=1]");
        BlockStateMapper.STATES[2994] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=north,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[83] = UnifiedStateName.create("minecraft:jungle_planks[]");
        BlockStateMapper.STATES[440] = UnifiedStateName.create("minecraft:powered_rail[powered=true,shape=north_south]");
        BlockStateMapper.STATES[290] = UnifiedStateName.create("minecraft:birch_leaves[distance=1,persistent=false]");
        BlockStateMapper.STATES[961] = UnifiedStateName.create("minecraft:farmland[moisture=1]");
        BlockStateMapper.STATES[1829] = UnifiedStateName.create("minecraft:nether_brick_stairs[facing=west,half=top,shape=straight]");
        BlockStateMapper.STATES[467] = UnifiedStateName.create("minecraft:sticky_piston[extended=false,facing=south]");
        BlockStateMapper.STATES[1720] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=south,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[3312] = UnifiedStateName.create("minecraft:beetroots[age=0]");
        BlockStateMapper.STATES[3760] = UnifiedStateName.create("minecraft:white_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[3808] = UnifiedStateName.create("minecraft:light_blue_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[1012] = UnifiedStateName.create("minecraft:sign[rotation=4]");
        BlockStateMapper.STATES[3746] = UnifiedStateName.create("minecraft:black_shulker_box[facing=north]");
        BlockStateMapper.STATES[613] = UnifiedStateName.create("minecraft:orange_tulip[]");
        BlockStateMapper.STATES[4081] = UnifiedStateName.create("minecraft:structure_block[mode=load]");
        BlockStateMapper.STATES[849] = UnifiedStateName.create("minecraft:oak_stairs[facing=west,half=bottom,shape=outer_right]");
        BlockStateMapper.STATES[1376] = UnifiedStateName.create("minecraft:carved_pumpkin[facing=south]");
        BlockStateMapper.STATES[3922] = UnifiedStateName.create("minecraft:purple_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[2685] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=south,half=top,open=true]");
        BlockStateMapper.STATES[2414] = UnifiedStateName.create("minecraft:comparator[facing=north,mode=subtract,powered=true]");
        BlockStateMapper.STATES[2243] = UnifiedStateName.create("minecraft:potted_oak_sapling[]");
        BlockStateMapper.STATES[1117] = UnifiedStateName.create("minecraft:lever[face=floor,facing=east,powered=true]");
        BlockStateMapper.STATES[2675] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=east,half=bottom,open=false]");
        BlockStateMapper.STATES[552] = UnifiedStateName.create("minecraft:piston_head[facing=down,short=false,type=sticky]");
        BlockStateMapper.STATES[1011] = UnifiedStateName.create("minecraft:sign[rotation=3]");
        BlockStateMapper.STATES[3131] = UnifiedStateName.create("minecraft:jungle_door[facing=east,half=upper,hinge=right,open=false,powered=true]");
        BlockStateMapper.STATES[3251] = UnifiedStateName.create("minecraft:purpur_stairs[facing=north,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2144] = UnifiedStateName.create("minecraft:spruce_stairs[facing=east,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2033] = UnifiedStateName.create("minecraft:cocoa[age=0,facing=west]");
        BlockStateMapper.STATES[828] = UnifiedStateName.create("minecraft:fire[age=12,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[3554] = UnifiedStateName.create("minecraft:light_blue_shulker_box[facing=north]");
        BlockStateMapper.STATES[1747] = UnifiedStateName.create("minecraft:stone_brick_stairs[facing=north,half=bottom,shape=straight]");
        BlockStateMapper.STATES[20] = UnifiedStateName.create("minecraft:polished_diorite[]");
        BlockStateMapper.STATES[886] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=6,south=none,west=none]");
        BlockStateMapper.STATES[531] = UnifiedStateName.create("minecraft:piston[extended=false,facing=south]");
        BlockStateMapper.STATES[3552] = UnifiedStateName.create("minecraft:light_blue_shulker_box[facing=down]");
        BlockStateMapper.STATES[2684] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=north,half=top,open=true]");
        BlockStateMapper.STATES[1014] = UnifiedStateName.create("minecraft:sign[rotation=6]");
        BlockStateMapper.STATES[352] = UnifiedStateName.create("minecraft:lapis_block[]");
        BlockStateMapper.STATES[2032] = UnifiedStateName.create("minecraft:cocoa[age=0,facing=south]");
        BlockStateMapper.STATES[432] = UnifiedStateName.create("minecraft:powered_rail[powered=false,shape=north_south]");
        BlockStateMapper.STATES[2546] = UnifiedStateName.create("minecraft:magenta_terracotta[]");
        BlockStateMapper.STATES[473] = UnifiedStateName.create("minecraft:sticky_piston[extended=true,facing=up]");
        BlockStateMapper.STATES[2398] = UnifiedStateName.create("minecraft:comparator[facing=north,mode=subtract,powered=false]");
        BlockStateMapper.STATES[3168] = UnifiedStateName.create("minecraft:end_rod[facing=down]");
        BlockStateMapper.STATES[695] = UnifiedStateName.create("minecraft:quartz_slab[type=double]");
        BlockStateMapper.STATES[1013] = UnifiedStateName.create("minecraft:sign[rotation=5]");
        BlockStateMapper.STATES[574] = UnifiedStateName.create("minecraft:red_wool[]");
        BlockStateMapper.STATES[3371] = UnifiedStateName.create("minecraft:repeating_command_block[conditional=true,facing=south]");
        BlockStateMapper.STATES[705] = UnifiedStateName.create("minecraft:sandstone_slab[type=bottom]");
        BlockStateMapper.STATES[3667] = UnifiedStateName.create("minecraft:purple_shulker_box[facing=south]");
        BlockStateMapper.STATES[3632] = UnifiedStateName.create("minecraft:light_gray_shulker_box[facing=down]");
        BlockStateMapper.STATES[1553] = UnifiedStateName.create("minecraft:infested_cobblestone[]");
        BlockStateMapper.STATES[3985] = UnifiedStateName.create("minecraft:red_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[1500] = UnifiedStateName.create("minecraft:repeater[delay=4,facing=south,locked=false,powered=false]");
        BlockStateMapper.STATES[2592] = UnifiedStateName.create("minecraft:acacia_log[axis=y]");
        BlockStateMapper.STATES[2558] = UnifiedStateName.create("minecraft:red_terracotta[]");
        BlockStateMapper.STATES[1217] = UnifiedStateName.create("minecraft:redstone_wall_torch[facing=east,lit=true]");
        BlockStateMapper.STATES[541] = UnifiedStateName.create("minecraft:piston[extended=true,facing=east]");
        BlockStateMapper.STATES[2859] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=11]");
        BlockStateMapper.STATES[1731] = UnifiedStateName.create("minecraft:brick_stairs[facing=north,half=bottom,shape=straight]");
        BlockStateMapper.STATES[379] = UnifiedStateName.create("minecraft:dispenser[facing=south,triggered=true]");
        BlockStateMapper.STATES[1311] = UnifiedStateName.create("minecraft:cactus[age=15]");
        BlockStateMapper.STATES[1059] = UnifiedStateName.create("minecraft:rail[shape=ascending_west]");
        BlockStateMapper.STATES[2596] = UnifiedStateName.create("minecraft:acacia_log[axis=x]");
        BlockStateMapper.STATES[2960] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=south,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[3588] = UnifiedStateName.create("minecraft:lime_shulker_box[facing=west]");
        BlockStateMapper.STATES[2858] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=10]");
        BlockStateMapper.STATES[3616] = UnifiedStateName.create("minecraft:gray_shulker_box[facing=down]");
        BlockStateMapper.STATES[1065] = UnifiedStateName.create("minecraft:rail[shape=north_east]");
        BlockStateMapper.STATES[426] = UnifiedStateName.create("minecraft:red_bed[facing=north,occupied=false,part=head]");
        BlockStateMapper.STATES[3538] = UnifiedStateName.create("minecraft:magenta_shulker_box[facing=north]");
        BlockStateMapper.STATES[2571] = UnifiedStateName.create("minecraft:blue_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[400] = UnifiedStateName.create("minecraft:note_block[]");
        BlockStateMapper.STATES[4047] = UnifiedStateName.create("minecraft:black_concrete_powder[]");
        BlockStateMapper.STATES[1590] = UnifiedStateName.create("minecraft:brown_mushroom_block[down=false,east=true,north=false,south=false,up=true,west=false]");
        BlockStateMapper.STATES[3650] = UnifiedStateName.create("minecraft:cyan_shulker_box[facing=north]");
        BlockStateMapper.STATES[1531] = UnifiedStateName.create("minecraft:blue_stained_glass[]");
        BlockStateMapper.STATES[1717] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=west,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[1309] = UnifiedStateName.create("minecraft:cactus[age=13]");
        BlockStateMapper.STATES[714] = UnifiedStateName.create("minecraft:petrified_oak_slab[type=top]");
        BlockStateMapper.STATES[802] = UnifiedStateName.create("minecraft:wall_torch[facing=west]");
        BlockStateMapper.STATES[3732] = UnifiedStateName.create("minecraft:red_shulker_box[facing=west]");
        BlockStateMapper.STATES[1091] = UnifiedStateName.create("minecraft:wall_sign[facing=south]");
        BlockStateMapper.STATES[1092] = UnifiedStateName.create("minecraft:wall_sign[facing=west]");
        BlockStateMapper.STATES[2448] = UnifiedStateName.create("minecraft:nether_quartz_ore[]");
        BlockStateMapper.STATES[3146] = UnifiedStateName.create("minecraft:acacia_door[facing=east,half=upper,hinge=left,open=false,powered=true]");
        BlockStateMapper.STATES[2196] = UnifiedStateName.create("minecraft:command_block[conditional=false,facing=west]");
        BlockStateMapper.STATES[466] = UnifiedStateName.create("minecraft:sticky_piston[extended=false,facing=north]");
        BlockStateMapper.STATES[1310] = UnifiedStateName.create("minecraft:cactus[age=14]");
        BlockStateMapper.STATES[850] = UnifiedStateName.create("minecraft:oak_stairs[facing=south,half=bottom,shape=outer_right]");
        BlockStateMapper.STATES[1344] = UnifiedStateName.create("minecraft:jukebox[has_record=false]");
        BlockStateMapper.STATES[2017] = UnifiedStateName.create("minecraft:spruce_slab[type=bottom]");
        BlockStateMapper.STATES[1142] = UnifiedStateName.create("minecraft:iron_door[facing=west,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[4038] = UnifiedStateName.create("minecraft:pink_concrete_powder[]");
        BlockStateMapper.STATES[4046] = UnifiedStateName.create("minecraft:red_concrete_powder[]");
        BlockStateMapper.STATES[2147] = UnifiedStateName.create("minecraft:spruce_stairs[facing=north,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2627] = UnifiedStateName.create("minecraft:dark_oak_stairs[facing=north,half=bottom,shape=straight]");
        BlockStateMapper.STATES[1706] = UnifiedStateName.create("minecraft:vine[east=true,north=false,south=false,up=false,west=true]");
        BlockStateMapper.STATES[2803] = UnifiedStateName.create("minecraft:large_fern[half=lower]");
        BlockStateMapper.STATES[21] = UnifiedStateName.create("minecraft:andesite[]");
        BlockStateMapper.STATES[1547] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=east,half=top,open=false,powered=false]");
        BlockStateMapper.STATES[1034] = UnifiedStateName.create("minecraft:oak_door[facing=east,half=upper,hinge=left,open=false,powered=true]");
        BlockStateMapper.STATES[3184] = UnifiedStateName.create("minecraft:chorus_plant[down=false,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[1307] = UnifiedStateName.create("minecraft:cactus[age=11]");
        BlockStateMapper.STATES[2412] = UnifiedStateName.create("minecraft:comparator[facing=south,mode=subtract,powered=true]");
        BlockStateMapper.STATES[1827] = UnifiedStateName.create("minecraft:nether_brick_stairs[facing=north,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2881] = UnifiedStateName.create("minecraft:red_sandstone_stairs[facing=west,half=bottom,shape=straight]");
        BlockStateMapper.STATES[99] = UnifiedStateName.create("minecraft:jungle_sapling[stage=0]");
        BlockStateMapper.STATES[826] = UnifiedStateName.create("minecraft:fire[age=10,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[3779] = UnifiedStateName.create("minecraft:orange_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[295] = UnifiedStateName.create("minecraft:jungle_leaves[distance=1,persistent=true]");
        BlockStateMapper.STATES[4018] = UnifiedStateName.create("minecraft:magenta_concrete[]");
        BlockStateMapper.STATES[2528] = UnifiedStateName.create("minecraft:dropper[facing=down,triggered=false]");
        BlockStateMapper.STATES[3296] = UnifiedStateName.create("minecraft:end_stone_bricks[]");
        BlockStateMapper.STATES[1028] = UnifiedStateName.create("minecraft:oak_door[facing=east,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[1152] = UnifiedStateName.create("minecraft:oak_pressure_plate[powered=false]");
        BlockStateMapper.STATES[1308] = UnifiedStateName.create("minecraft:cactus[age=12]");
        BlockStateMapper.STATES[624] = UnifiedStateName.create("minecraft:brown_mushroom[]");
        BlockStateMapper.STATES[1221] = UnifiedStateName.create("minecraft:redstone_torch[lit=true]");
        BlockStateMapper.STATES[2224] = UnifiedStateName.create("minecraft:cobblestone_wall[east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[2497] = UnifiedStateName.create("minecraft:quartz_stairs[facing=west,half=bottom,shape=straight]");
        BlockStateMapper.STATES[4080] = UnifiedStateName.create("minecraft:structure_block[mode=save]");
        BlockStateMapper.STATES[107] = UnifiedStateName.create("minecraft:jungle_sapling[stage=1]");
        BlockStateMapper.STATES[2097] = UnifiedStateName.create("minecraft:tripwire_hook[attached=false,facing=west,powered=false]");
        BlockStateMapper.STATES[3120] = UnifiedStateName.create("minecraft:jungle_door[facing=east,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3157] = UnifiedStateName.create("minecraft:dark_oak_door[facing=south,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[3370] = UnifiedStateName.create("minecraft:repeating_command_block[conditional=true,facing=north]");
        BlockStateMapper.STATES[2961] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=west,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[1090] = UnifiedStateName.create("minecraft:wall_sign[facing=north]");
        BlockStateMapper.STATES[1927] = UnifiedStateName.create("minecraft:end_portal_frame[eye=true,facing=east]");
        BlockStateMapper.STATES[3501] = UnifiedStateName.create("minecraft:observer[facing=east,powered=true]");
        BlockStateMapper.STATES[589] = UnifiedStateName.create("minecraft:moving_piston[facing=east,type=sticky]");
        BlockStateMapper.STATES[385] = UnifiedStateName.create("minecraft:chiseled_sandstone[]");
        BlockStateMapper.STATES[2600] = UnifiedStateName.create("minecraft:acacia_log[axis=z]");
        BlockStateMapper.STATES[2768] = UnifiedStateName.create("minecraft:coal_block[]");
        BlockStateMapper.STATES[2050] = UnifiedStateName.create("minecraft:sandstone_stairs[facing=south,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2982] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=north,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[1264] = UnifiedStateName.create("minecraft:ice[]");
        BlockStateMapper.STATES[1716] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=south,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[2548] = UnifiedStateName.create("minecraft:yellow_terracotta[]");
        BlockStateMapper.STATES[1168] = UnifiedStateName.create("minecraft:redstone_ore[lit=false]");
        BlockStateMapper.STATES[1306] = UnifiedStateName.create("minecraft:cactus[age=10]");
        BlockStateMapper.STATES[4043] = UnifiedStateName.create("minecraft:blue_concrete_powder[]");
        BlockStateMapper.STATES[2886] = UnifiedStateName.create("minecraft:red_sandstone_stairs[facing=south,half=top,shape=straight]");
        BlockStateMapper.STATES[476] = UnifiedStateName.create("minecraft:sticky_piston[extended=true,facing=west]");
        BlockStateMapper.STATES[2166] = UnifiedStateName.create("minecraft:birch_stairs[facing=south,half=top,shape=straight]");
        BlockStateMapper.STATES[3089] = UnifiedStateName.create("minecraft:spruce_door[facing=south,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3714] = UnifiedStateName.create("minecraft:green_shulker_box[facing=north]");
        BlockStateMapper.STATES[1603] = UnifiedStateName.create("minecraft:red_mushroom_block[down=false,east=true,north=true,south=false,up=true,west=false]");
        BlockStateMapper.STATES[4000] = UnifiedStateName.create("minecraft:black_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[1328] = UnifiedStateName.create("minecraft:sugar_cane[age=0]");
        BlockStateMapper.STATES[386] = UnifiedStateName.create("minecraft:cut_sandstone[]");
        BlockStateMapper.STATES[3115] = UnifiedStateName.create("minecraft:birch_door[facing=east,half=upper,hinge=right,open=false,powered=true]");
        BlockStateMapper.STATES[2939] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=east,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[3875] = UnifiedStateName.create("minecraft:gray_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[4003] = UnifiedStateName.create("minecraft:black_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[1237] = UnifiedStateName.create("minecraft:stone_button[face=floor,facing=east,powered=false]");
        BlockStateMapper.STATES[2955] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=east,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[1509] = UnifiedStateName.create("minecraft:repeater[delay=2,facing=west,locked=false,powered=true]");
        BlockStateMapper.STATES[1725] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=west,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[2466] = UnifiedStateName.create("minecraft:hopper[enabled=true,facing=north]");
        BlockStateMapper.STATES[3105] = UnifiedStateName.create("minecraft:birch_door[facing=south,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3126] = UnifiedStateName.create("minecraft:jungle_door[facing=west,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[2813] = UnifiedStateName.create("minecraft:peony[half=upper]");
        BlockStateMapper.STATES[450] = UnifiedStateName.create("minecraft:detector_rail[powered=false,shape=ascending_east]");
        BlockStateMapper.STATES[1503] = UnifiedStateName.create("minecraft:repeater[delay=4,facing=east,locked=false,powered=false]");
        BlockStateMapper.STATES[3253] = UnifiedStateName.create("minecraft:purpur_stairs[facing=west,half=top,shape=straight]");
        BlockStateMapper.STATES[1733] = UnifiedStateName.create("minecraft:brick_stairs[facing=west,half=top,shape=straight]");
        BlockStateMapper.STATES[1877] = UnifiedStateName.create("minecraft:brewing_stand[has_bottle_0=true,has_bottle_1=false,has_bottle_2=true]");
        BlockStateMapper.STATES[105] = UnifiedStateName.create("minecraft:spruce_sapling[stage=1]");
        BlockStateMapper.STATES[1330] = UnifiedStateName.create("minecraft:sugar_cane[age=2]");
        BlockStateMapper.STATES[1707] = UnifiedStateName.create("minecraft:vine[east=true,north=false,south=true,up=false,west=true]");
        BlockStateMapper.STATES[3668] = UnifiedStateName.create("minecraft:purple_shulker_box[facing=west]");
        BlockStateMapper.STATES[2413] = UnifiedStateName.create("minecraft:comparator[facing=west,mode=subtract,powered=true]");
        BlockStateMapper.STATES[3619] = UnifiedStateName.create("minecraft:gray_shulker_box[facing=south]");
        BlockStateMapper.STATES[563] = UnifiedStateName.create("minecraft:light_blue_wool[]");
        BlockStateMapper.STATES[1604] = UnifiedStateName.create("minecraft:red_mushroom_block[down=false,east=false,north=false,south=false,up=true,west=true]");
        BlockStateMapper.STATES[2052] = UnifiedStateName.create("minecraft:sandstone_stairs[facing=east,half=top,shape=straight]");
        BlockStateMapper.STATES[3556] = UnifiedStateName.create("minecraft:light_blue_shulker_box[facing=west]");
        BlockStateMapper.STATES[0] = UnifiedStateName.create("minecraft:air[]");
        BlockStateMapper.STATES[1072] = UnifiedStateName.create("minecraft:cobblestone_stairs[facing=east,half=bottom,shape=straight]");
        BlockStateMapper.STATES[97] = UnifiedStateName.create("minecraft:spruce_sapling[stage=0]");
        BlockStateMapper.STATES[1329] = UnifiedStateName.create("minecraft:sugar_cane[age=1]");
        BlockStateMapper.STATES[1825] = UnifiedStateName.create("minecraft:nether_brick_stairs[facing=west,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2467] = UnifiedStateName.create("minecraft:hopper[enabled=true,facing=south]");
        BlockStateMapper.STATES[717] = UnifiedStateName.create("minecraft:stone_brick_slab[type=top]");
        BlockStateMapper.STATES[1236] = UnifiedStateName.create("minecraft:stone_button[face=wall,facing=north,powered=false]");
        BlockStateMapper.STATES[3056] = UnifiedStateName.create("minecraft:dark_oak_fence[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[2988] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=south,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[2051] = UnifiedStateName.create("minecraft:sandstone_stairs[facing=north,half=bottom,shape=straight]");
        BlockStateMapper.STATES[3729] = UnifiedStateName.create("minecraft:red_shulker_box[facing=up]");
        BlockStateMapper.STATES[3161] = UnifiedStateName.create("minecraft:dark_oak_door[facing=east,half=upper,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[736] = UnifiedStateName.create("minecraft:tnt[unstable=false]");
        BlockStateMapper.STATES[469] = UnifiedStateName.create("minecraft:sticky_piston[extended=false,facing=east]");
        BlockStateMapper.STATES[1499] = UnifiedStateName.create("minecraft:repeater[delay=3,facing=east,locked=false,powered=false]");
        BlockStateMapper.STATES[2245] = UnifiedStateName.create("minecraft:potted_birch_sapling[]");
        BlockStateMapper.STATES[1699] = UnifiedStateName.create("minecraft:vine[east=false,north=false,south=true,up=false,west=true]");
        BlockStateMapper.STATES[2338] = UnifiedStateName.create("minecraft:trapped_chest[facing=north,type=single]");
        BlockStateMapper.STATES[2863] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=15]");
        BlockStateMapper.STATES[3539] = UnifiedStateName.create("minecraft:magenta_shulker_box[facing=south]");
        BlockStateMapper.STATES[3651] = UnifiedStateName.create("minecraft:cyan_shulker_box[facing=south]");
        BlockStateMapper.STATES[882] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=2,south=none,west=none]");
        BlockStateMapper.STATES[3684] = UnifiedStateName.create("minecraft:blue_shulker_box[facing=west]");
        BlockStateMapper.STATES[2938] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=north,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[996] = UnifiedStateName.create("minecraft:furnace[facing=west,lit=true]");
        BlockStateMapper.STATES[3730] = UnifiedStateName.create("minecraft:red_shulker_box[facing=north]");
        BlockStateMapper.STATES[568] = UnifiedStateName.create("minecraft:light_gray_wool[]");
        BlockStateMapper.STATES[3921] = UnifiedStateName.create("minecraft:purple_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[3825] = UnifiedStateName.create("minecraft:yellow_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[1233] = UnifiedStateName.create("minecraft:stone_button[face=wall,facing=east,powered=false]");
        BlockStateMapper.STATES[883] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=3,south=none,west=none]");
        BlockStateMapper.STATES[818] = UnifiedStateName.create("minecraft:fire[age=2,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[2480] = UnifiedStateName.create("minecraft:quartz_block[]");
        BlockStateMapper.STATES[2862] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=14]");
        BlockStateMapper.STATES[1533] = UnifiedStateName.create("minecraft:green_stained_glass[]");
        BlockStateMapper.STATES[3569] = UnifiedStateName.create("minecraft:yellow_shulker_box[facing=up]");
        BlockStateMapper.STATES[1545] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=south,half=top,open=false,powered=false]");
        BlockStateMapper.STATES[1592] = UnifiedStateName.create("minecraft:brown_mushroom_block[down=false,east=false,north=false,south=true,up=true,west=false]");
        BlockStateMapper.STATES[2861] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=13]");
        BlockStateMapper.STATES[3715] = UnifiedStateName.create("minecraft:green_shulker_box[facing=south]");
        BlockStateMapper.STATES[2987] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=east,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[1532] = UnifiedStateName.create("minecraft:brown_stained_glass[]");
        BlockStateMapper.STATES[1614] = UnifiedStateName.create("minecraft:red_mushroom_block[down=true,east=true,north=true,south=true,up=true,west=true]");
        BlockStateMapper.STATES[528] = UnifiedStateName.create("minecraft:piston[extended=false,facing=down]");
        BlockStateMapper.STATES[453] = UnifiedStateName.create("minecraft:detector_rail[powered=false,shape=ascending_south]");
        BlockStateMapper.STATES[3389] = UnifiedStateName.create("minecraft:chain_command_block[conditional=true,facing=east]");
        BlockStateMapper.STATES[2860] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=12]");
        BlockStateMapper.STATES[2201] = UnifiedStateName.create("minecraft:command_block[conditional=true,facing=up]");
        BlockStateMapper.STATES[445] = UnifiedStateName.create("minecraft:powered_rail[powered=true,shape=ascending_south]");
        BlockStateMapper.STATES[3842] = UnifiedStateName.create("minecraft:lime_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[1830] = UnifiedStateName.create("minecraft:nether_brick_stairs[facing=south,half=top,shape=straight]");
        BlockStateMapper.STATES[1234] = UnifiedStateName.create("minecraft:stone_button[face=wall,facing=west,powered=false]");
        BlockStateMapper.STATES[3024] = UnifiedStateName.create("minecraft:birch_fence[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[2576] = UnifiedStateName.create("minecraft:acacia_leaves[distance=1,persistent=false]");
        BlockStateMapper.STATES[2834] = UnifiedStateName.create("minecraft:white_wall_banner[facing=north]");
        BlockStateMapper.STATES[108] = UnifiedStateName.create("minecraft:acacia_sapling[stage=1]");
        BlockStateMapper.STATES[2084] = UnifiedStateName.create("minecraft:ender_chest[facing=west]");
        BlockStateMapper.STATES[3152] = UnifiedStateName.create("minecraft:dark_oak_door[facing=east,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3508] = UnifiedStateName.create("minecraft:white_shulker_box[facing=west]");
        BlockStateMapper.STATES[2225] = UnifiedStateName.create("minecraft:mossy_cobblestone_wall[east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[3006] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=north,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[2109] = UnifiedStateName.create("minecraft:tripwire_hook[attached=true,facing=west,powered=true]");
        BlockStateMapper.STATES[2261] = UnifiedStateName.create("minecraft:carrots[age=5]");
        BlockStateMapper.STATES[100] = UnifiedStateName.create("minecraft:acacia_sapling[stage=0]");
        BlockStateMapper.STATES[868] = UnifiedStateName.create("minecraft:chest[facing=west,type=single]");
        BlockStateMapper.STATES[2748] = UnifiedStateName.create("minecraft:brown_carpet[]");
        BlockStateMapper.STATES[2048] = UnifiedStateName.create("minecraft:sandstone_stairs[facing=east,half=bottom,shape=straight]");
        BlockStateMapper.STATES[1748] = UnifiedStateName.create("minecraft:stone_brick_stairs[facing=east,half=top,shape=straight]");
        BlockStateMapper.STATES[2305] = UnifiedStateName.create("minecraft:skeleton_skull[rotation=4]");
        BlockStateMapper.STATES[3824] = UnifiedStateName.create("minecraft:yellow_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[1202] = UnifiedStateName.create("minecraft:redstone_wall_torch[facing=west,lit=false]");
        BlockStateMapper.STATES[2996] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=south,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[3809] = UnifiedStateName.create("minecraft:light_blue_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[1749] = UnifiedStateName.create("minecraft:stone_brick_stairs[facing=west,half=top,shape=straight]");
        BlockStateMapper.STATES[3969] = UnifiedStateName.create("minecraft:green_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[2260] = UnifiedStateName.create("minecraft:carrots[age=4]");
        BlockStateMapper.STATES[2835] = UnifiedStateName.create("minecraft:white_wall_banner[facing=south]");
        BlockStateMapper.STATES[3360] = UnifiedStateName.create("minecraft:repeating_command_block[conditional=false,facing=down]");
        BlockStateMapper.STATES[423] = UnifiedStateName.create("minecraft:red_bed[facing=east,occupied=true,part=foot]");
        BlockStateMapper.STATES[570] = UnifiedStateName.create("minecraft:purple_wool[]");
        BlockStateMapper.STATES[979] = UnifiedStateName.create("minecraft:furnace[facing=south,lit=false]");
        BlockStateMapper.STATES[1476] = UnifiedStateName.create("minecraft:cake[bites=4]");
        BlockStateMapper.STATES[2676] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=north,half=bottom,open=true]");
        BlockStateMapper.STATES[1112] = UnifiedStateName.create("minecraft:lever[face=ceiling,facing=north,powered=true]");
        BlockStateMapper.STATES[579] = UnifiedStateName.create("minecraft:moving_piston[facing=south,type=normal]");
        BlockStateMapper.STATES[2329] = UnifiedStateName.create("minecraft:damaged_anvil[facing=west]");
        BlockStateMapper.STATES[2263] = UnifiedStateName.create("minecraft:carrots[age=7]");
        BlockStateMapper.STATES[3372] = UnifiedStateName.create("minecraft:repeating_command_block[conditional=true,facing=west]");
        BlockStateMapper.STATES[2395] = UnifiedStateName.create("minecraft:comparator[facing=east,mode=compare,powered=false]");
        BlockStateMapper.STATES[1477] = UnifiedStateName.create("minecraft:cake[bites=5]");
        BlockStateMapper.STATES[1107] = UnifiedStateName.create("minecraft:lever[face=wall,facing=south,powered=false]");
        BlockStateMapper.STATES[3369] = UnifiedStateName.create("minecraft:repeating_command_block[conditional=true,facing=up]");
        BlockStateMapper.STATES[2105] = UnifiedStateName.create("minecraft:tripwire_hook[attached=false,facing=west,powered=true]");
        BlockStateMapper.STATES[3489] = UnifiedStateName.create("minecraft:observer[facing=up,powered=false]");
        BlockStateMapper.STATES[830] = UnifiedStateName.create("minecraft:fire[age=14,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[2309] = UnifiedStateName.create("minecraft:skeleton_wall_skull[facing=east]");
        BlockStateMapper.STATES[434] = UnifiedStateName.create("minecraft:powered_rail[powered=false,shape=ascending_east]");
        BlockStateMapper.STATES[2674] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=west,half=bottom,open=false]");
        BlockStateMapper.STATES[2629] = UnifiedStateName.create("minecraft:dark_oak_stairs[facing=west,half=top,shape=straight]");
        BlockStateMapper.STATES[2262] = UnifiedStateName.create("minecraft:carrots[age=6]");
        BlockStateMapper.STATES[448] = UnifiedStateName.create("minecraft:detector_rail[powered=false,shape=north_south]");
        BlockStateMapper.STATES[880] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=0,south=none,west=none]");
        BlockStateMapper.STATES[1478] = UnifiedStateName.create("minecraft:cake[bites=6]");
        BlockStateMapper.STATES[2164] = UnifiedStateName.create("minecraft:birch_stairs[facing=east,half=top,shape=straight]");
        BlockStateMapper.STATES[1474] = UnifiedStateName.create("minecraft:cake[bites=2]");
        BlockStateMapper.STATES[3252] = UnifiedStateName.create("minecraft:purpur_stairs[facing=east,half=top,shape=straight]");
        BlockStateMapper.STATES[2256] = UnifiedStateName.create("minecraft:carrots[age=0]");
        BlockStateMapper.STATES[3504] = UnifiedStateName.create("minecraft:white_shulker_box[facing=down]");
        BlockStateMapper.STATES[1043] = UnifiedStateName.create("minecraft:ladder[facing=south]");
        BlockStateMapper.STATES[978] = UnifiedStateName.create("minecraft:furnace[facing=north,lit=false]");
        BlockStateMapper.STATES[3840] = UnifiedStateName.create("minecraft:lime_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[4045] = UnifiedStateName.create("minecraft:green_concrete_powder[]");
        BlockStateMapper.STATES[2324] = UnifiedStateName.create("minecraft:chipped_anvil[facing=south]");
        BlockStateMapper.STATES[1727] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=east,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[1204] = UnifiedStateName.create("minecraft:redstone_wall_torch[facing=north,lit=false]");
        BlockStateMapper.STATES[2299] = UnifiedStateName.create("minecraft:oak_button[face=wall,facing=south,powered=true]");
        BlockStateMapper.STATES[64] = UnifiedStateName.create("minecraft:cobblestone[]");
        BlockStateMapper.STATES[2401] = UnifiedStateName.create("minecraft:comparator[facing=west,mode=compare,powered=true]");
        BlockStateMapper.STATES[3364] = UnifiedStateName.create("minecraft:repeating_command_block[conditional=false,facing=west]");
        BlockStateMapper.STATES[656] = UnifiedStateName.create("minecraft:gold_block[]");
        BlockStateMapper.STATES[280] = UnifiedStateName.create("minecraft:oak_log[axis=z]");
        BlockStateMapper.STATES[1475] = UnifiedStateName.create("minecraft:cake[bites=3]");
        BlockStateMapper.STATES[2556] = UnifiedStateName.create("minecraft:brown_terracotta[]");
        BlockStateMapper.STATES[2304] = UnifiedStateName.create("minecraft:skeleton_skull[rotation=0]");
        BlockStateMapper.STATES[1734] = UnifiedStateName.create("minecraft:brick_stairs[facing=south,half=top,shape=straight]");
        BlockStateMapper.STATES[1245] = UnifiedStateName.create("minecraft:stone_button[face=floor,facing=south,powered=true]");
        BlockStateMapper.STATES[2976] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=south,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[885] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=5,south=none,west=none]");
        BlockStateMapper.STATES[1203] = UnifiedStateName.create("minecraft:redstone_wall_torch[facing=south,lit=false]");
        BlockStateMapper.STATES[3385] = UnifiedStateName.create("minecraft:chain_command_block[conditional=true,facing=up]");
        BlockStateMapper.STATES[995] = UnifiedStateName.create("minecraft:furnace[facing=south,lit=true]");
        BlockStateMapper.STATES[2258] = UnifiedStateName.create("minecraft:carrots[age=2]");
        BlockStateMapper.STATES[2547] = UnifiedStateName.create("minecraft:light_blue_terracotta[]");
        BlockStateMapper.STATES[272] = UnifiedStateName.create("minecraft:oak_log[axis=y]");
        BlockStateMapper.STATES[444] = UnifiedStateName.create("minecraft:powered_rail[powered=true,shape=ascending_north]");
        BlockStateMapper.STATES[371] = UnifiedStateName.create("minecraft:dispenser[facing=south,triggered=false]");
        BlockStateMapper.STATES[1472] = UnifiedStateName.create("minecraft:cake[bites=0]");
        BlockStateMapper.STATES[3872] = UnifiedStateName.create("minecraft:gray_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[2956] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=south,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[2498] = UnifiedStateName.create("minecraft:quartz_stairs[facing=south,half=bottom,shape=straight]");
        BlockStateMapper.STATES[443] = UnifiedStateName.create("minecraft:powered_rail[powered=true,shape=ascending_west]");
        BlockStateMapper.STATES[1569] = UnifiedStateName.create("minecraft:mossy_stone_bricks[]");
        BlockStateMapper.STATES[1922] = UnifiedStateName.create("minecraft:end_portal_frame[eye=false,facing=north]");
        BlockStateMapper.STATES[2625] = UnifiedStateName.create("minecraft:dark_oak_stairs[facing=west,half=bottom,shape=straight]");
        BlockStateMapper.STATES[3731] = UnifiedStateName.create("minecraft:red_shulker_box[facing=south]");
        BlockStateMapper.STATES[2563] = UnifiedStateName.create("minecraft:light_blue_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[1456] = UnifiedStateName.create("minecraft:jack_o_lantern[facing=south]");
        BlockStateMapper.STATES[2259] = UnifiedStateName.create("minecraft:carrots[age=3]");
        BlockStateMapper.STATES[1473] = UnifiedStateName.create("minecraft:cake[bites=1]");
        BlockStateMapper.STATES[2257] = UnifiedStateName.create("minecraft:carrots[age=1]");
        BlockStateMapper.STATES[2930] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=north,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[276] = UnifiedStateName.create("minecraft:oak_log[axis=x]");
        BlockStateMapper.STATES[2110] = UnifiedStateName.create("minecraft:tripwire_hook[attached=true,facing=north,powered=true]");
        BlockStateMapper.STATES[1760] = UnifiedStateName.create("minecraft:mycelium[snowy=false]");
        BlockStateMapper.STATES[3701] = UnifiedStateName.create("minecraft:brown_shulker_box[facing=east]");
        BlockStateMapper.STATES[1776] = UnifiedStateName.create("minecraft:lily_pad[]");
        BlockStateMapper.STATES[1557] = UnifiedStateName.create("minecraft:infested_chiseled_stone_bricks[]");
        BlockStateMapper.STATES[3954] = UnifiedStateName.create("minecraft:brown_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[567] = UnifiedStateName.create("minecraft:gray_wool[]");
        BlockStateMapper.STATES[2689] = UnifiedStateName.create("minecraft:prismarine_bricks[]");
        BlockStateMapper.STATES[2640] = UnifiedStateName.create("minecraft:slime_block[]");
        BlockStateMapper.STATES[3154] = UnifiedStateName.create("minecraft:dark_oak_door[facing=west,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[1920] = UnifiedStateName.create("minecraft:end_portal_frame[eye=false,facing=south]");
        BlockStateMapper.STATES[2545] = UnifiedStateName.create("minecraft:orange_terracotta[]");
        BlockStateMapper.STATES[1147] = UnifiedStateName.create("minecraft:iron_door[facing=east,half=upper,hinge=right,open=false,powered=true]");
        BlockStateMapper.STATES[2053] = UnifiedStateName.create("minecraft:sandstone_stairs[facing=west,half=top,shape=straight]");
        BlockStateMapper.STATES[1240] = UnifiedStateName.create("minecraft:stone_button[face=ceiling,facing=south,powered=true]");
        BlockStateMapper.STATES[2984] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=south,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[2099] = UnifiedStateName.create("minecraft:tripwire_hook[attached=false,facing=east,powered=false]");
        BlockStateMapper.STATES[3618] = UnifiedStateName.create("minecraft:gray_shulker_box[facing=north]");
        BlockStateMapper.STATES[1116] = UnifiedStateName.create("minecraft:lever[face=wall,facing=north,powered=true]");
        BlockStateMapper.STATES[3203] = UnifiedStateName.create("minecraft:chorus_flower[age=3]");
        BlockStateMapper.STATES[3717] = UnifiedStateName.create("minecraft:green_shulker_box[facing=east]");
        BlockStateMapper.STATES[1542] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=west,half=bottom,open=true,powered=true]");
        BlockStateMapper.STATES[3648] = UnifiedStateName.create("minecraft:cyan_shulker_box[facing=down]");
        BlockStateMapper.STATES[2499] = UnifiedStateName.create("minecraft:quartz_stairs[facing=north,half=bottom,shape=straight]");
        BlockStateMapper.STATES[3952] = UnifiedStateName.create("minecraft:brown_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[2326] = UnifiedStateName.create("minecraft:chipped_anvil[facing=north]");
        BlockStateMapper.STATES[2552] = UnifiedStateName.create("minecraft:light_gray_terracotta[]");
        BlockStateMapper.STATES[3843] = UnifiedStateName.create("minecraft:lime_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[2241] = UnifiedStateName.create("minecraft:potted_poppy[]");
        BlockStateMapper.STATES[1042] = UnifiedStateName.create("minecraft:ladder[facing=north]");
        BlockStateMapper.STATES[2503] = UnifiedStateName.create("minecraft:quartz_stairs[facing=north,half=top,shape=straight]");
        BlockStateMapper.STATES[3202] = UnifiedStateName.create("minecraft:chorus_flower[age=2]");
        BlockStateMapper.STATES[2362] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=10]");
        BlockStateMapper.STATES[3328] = UnifiedStateName.create("minecraft:grass_path[]");
        BlockStateMapper.STATES[3377] = UnifiedStateName.create("minecraft:chain_command_block[conditional=false,facing=up]");
        BlockStateMapper.STATES[612] = UnifiedStateName.create("minecraft:red_tulip[]");
        BlockStateMapper.STATES[458] = UnifiedStateName.create("minecraft:detector_rail[powered=true,shape=ascending_east]");
        BlockStateMapper.STATES[553] = UnifiedStateName.create("minecraft:piston_head[facing=up,short=false,type=sticky]");
        BlockStateMapper.STATES[2000] = UnifiedStateName.create("minecraft:oak_slab[type=double]");
        BlockStateMapper.STATES[19] = UnifiedStateName.create("minecraft:diorite[]");
        BlockStateMapper.STATES[4002] = UnifiedStateName.create("minecraft:black_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[3201] = UnifiedStateName.create("minecraft:chorus_flower[age=1]");
        BlockStateMapper.STATES[1730] = UnifiedStateName.create("minecraft:brick_stairs[facing=south,half=bottom,shape=straight]");
        BlockStateMapper.STATES[1585] = UnifiedStateName.create("minecraft:brown_mushroom_block[down=false,east=false,north=true,south=false,up=true,west=true]");
        BlockStateMapper.STATES[1056] = UnifiedStateName.create("minecraft:rail[shape=north_south]");
        BlockStateMapper.STATES[544] = UnifiedStateName.create("minecraft:piston_head[facing=down,short=false,type=normal]");
        BlockStateMapper.STATES[2124] = UnifiedStateName.create("minecraft:tripwire[attached=true,disarmed=true,east=false,north=false,powered=false,south=false,west=false]");
        BlockStateMapper.STATES[4019] = UnifiedStateName.create("minecraft:light_blue_concrete[]");
        BlockStateMapper.STATES[1144] = UnifiedStateName.create("minecraft:iron_door[facing=east,half=upper,hinge=left,open=false,powered=false]");
        BlockStateMapper.STATES[1502] = UnifiedStateName.create("minecraft:repeater[delay=4,facing=north,locked=false,powered=false]");
        BlockStateMapper.STATES[2469] = UnifiedStateName.create("minecraft:hopper[enabled=true,facing=east]");
        BlockStateMapper.STATES[4025] = UnifiedStateName.create("minecraft:cyan_concrete[]");
        BlockStateMapper.STATES[3200] = UnifiedStateName.create("minecraft:chorus_flower[age=0]");
        BlockStateMapper.STATES[696] = UnifiedStateName.create("minecraft:smooth_stone[]");
        BlockStateMapper.STATES[869] = UnifiedStateName.create("minecraft:chest[facing=east,type=single]");
        BlockStateMapper.STATES[2946] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=north,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[3904] = UnifiedStateName.create("minecraft:cyan_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[2240] = UnifiedStateName.create("minecraft:flower_pot[]");
        BlockStateMapper.STATES[1519] = UnifiedStateName.create("minecraft:repeater[delay=4,facing=east,locked=false,powered=true]");
        BlockStateMapper.STATES[2604] = UnifiedStateName.create("minecraft:acacia_wood[]");
        BlockStateMapper.STATES[381] = UnifiedStateName.create("minecraft:dispenser[facing=east,triggered=true]");
        BlockStateMapper.STATES[2631] = UnifiedStateName.create("minecraft:dark_oak_stairs[facing=north,half=top,shape=straight]");
        BlockStateMapper.STATES[2432] = UnifiedStateName.create("minecraft:redstone_block[]");
        BlockStateMapper.STATES[2810] = UnifiedStateName.create("minecraft:tall_grass[half=upper]");
        BlockStateMapper.STATES[3745] = UnifiedStateName.create("minecraft:black_shulker_box[facing=up]");
        BlockStateMapper.STATES[1235] = UnifiedStateName.create("minecraft:stone_button[face=wall,facing=south,powered=false]");
        BlockStateMapper.STATES[1826] = UnifiedStateName.create("minecraft:nether_brick_stairs[facing=south,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2431] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=15]");
        BlockStateMapper.STATES[3110] = UnifiedStateName.create("minecraft:birch_door[facing=west,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[2977] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=west,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[1745] = UnifiedStateName.create("minecraft:stone_brick_stairs[facing=west,half=bottom,shape=straight]");
        BlockStateMapper.STATES[1184] = UnifiedStateName.create("minecraft:redstone_ore[lit=true]");
        BlockStateMapper.STATES[2365] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=13]");
        BlockStateMapper.STATES[2539] = UnifiedStateName.create("minecraft:dropper[facing=south,triggered=true]");
        BlockStateMapper.STATES[3156] = UnifiedStateName.create("minecraft:dark_oak_door[facing=east,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[3173] = UnifiedStateName.create("minecraft:end_rod[facing=east]");
        BlockStateMapper.STATES[2673] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=south,half=bottom,open=false]");
        BlockStateMapper.STATES[1518] = UnifiedStateName.create("minecraft:repeater[delay=4,facing=north,locked=false,powered=true]");
        BlockStateMapper.STATES[3874] = UnifiedStateName.create("minecraft:gray_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[2312] = UnifiedStateName.create("minecraft:skeleton_skull[rotation=8]");
        BlockStateMapper.STATES[694] = UnifiedStateName.create("minecraft:nether_brick_slab[type=double]");
        BlockStateMapper.STATES[1584] = UnifiedStateName.create("minecraft:brown_mushroom_block[down=false,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[2366] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=14]");
        BlockStateMapper.STATES[3906] = UnifiedStateName.create("minecraft:cyan_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[1515] = UnifiedStateName.create("minecraft:repeater[delay=3,facing=east,locked=false,powered=true]");
        BlockStateMapper.STATES[1514] = UnifiedStateName.create("minecraft:repeater[delay=3,facing=north,locked=false,powered=true]");
        BlockStateMapper.STATES[3637] = UnifiedStateName.create("minecraft:light_gray_shulker_box[facing=east]");
        BlockStateMapper.STATES[1507] = UnifiedStateName.create("minecraft:repeater[delay=1,facing=east,locked=false,powered=true]");
        BlockStateMapper.STATES[866] = UnifiedStateName.create("minecraft:chest[facing=north,type=single]");
        BlockStateMapper.STATES[3121] = UnifiedStateName.create("minecraft:jungle_door[facing=south,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3205] = UnifiedStateName.create("minecraft:chorus_flower[age=5]");
        BlockStateMapper.STATES[2055] = UnifiedStateName.create("minecraft:sandstone_stairs[facing=north,half=top,shape=straight]");
        BlockStateMapper.STATES[1379] = UnifiedStateName.create("minecraft:carved_pumpkin[facing=east]");
        BlockStateMapper.STATES[2608] = UnifiedStateName.create("minecraft:acacia_stairs[facing=east,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2363] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=11]");
        BlockStateMapper.STATES[848] = UnifiedStateName.create("minecraft:oak_stairs[facing=east,half=bottom,shape=outer_right]");
        BlockStateMapper.STATES[2180] = UnifiedStateName.create("minecraft:jungle_stairs[facing=east,half=top,shape=straight]");
        BlockStateMapper.STATES[1079] = UnifiedStateName.create("minecraft:cobblestone_stairs[facing=north,half=top,shape=straight]");
        BlockStateMapper.STATES[1523] = UnifiedStateName.create("minecraft:light_blue_stained_glass[]");
        BlockStateMapper.STATES[1831] = UnifiedStateName.create("minecraft:nether_brick_stairs[facing=north,half=top,shape=straight]");
        BlockStateMapper.STATES[3204] = UnifiedStateName.create("minecraft:chorus_flower[age=4]");
        BlockStateMapper.STATES[831] = UnifiedStateName.create("minecraft:fire[age=15,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[2974] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=north,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[2364] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=12]");
        BlockStateMapper.STATES[2108] = UnifiedStateName.create("minecraft:tripwire_hook[attached=true,facing=south,powered=true]");
        BlockStateMapper.STATES[3604] = UnifiedStateName.create("minecraft:pink_shulker_box[facing=west]");
        BlockStateMapper.STATES[1683] = UnifiedStateName.create("minecraft:melon_stem[age=3]");
        BlockStateMapper.STATES[2850] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=2]");
        BlockStateMapper.STATES[4026] = UnifiedStateName.create("minecraft:purple_concrete[]");
        BlockStateMapper.STATES[3114] = UnifiedStateName.create("minecraft:birch_door[facing=east,half=upper,hinge=left,open=false,powered=true]");
        BlockStateMapper.STATES[609] = UnifiedStateName.create("minecraft:blue_orchid[]");
        BlockStateMapper.STATES[3393] = UnifiedStateName.create("minecraft:frosted_ice[age=1]");
        BlockStateMapper.STATES[2597] = UnifiedStateName.create("minecraft:dark_oak_log[axis=x]");
        BlockStateMapper.STATES[274] = UnifiedStateName.create("minecraft:birch_log[axis=y]");
        BlockStateMapper.STATES[853] = UnifiedStateName.create("minecraft:oak_stairs[facing=west,half=top,shape=outer_right]");
        BlockStateMapper.STATES[2040] = UnifiedStateName.create("minecraft:cocoa[age=2,facing=south]");
        BlockStateMapper.STATES[1201] = UnifiedStateName.create("minecraft:redstone_wall_torch[facing=east,lit=false]");
        BlockStateMapper.STATES[566] = UnifiedStateName.create("minecraft:pink_wool[]");
        BlockStateMapper.STATES[1684] = UnifiedStateName.create("minecraft:melon_stem[age=4]");
        BlockStateMapper.STATES[3143] = UnifiedStateName.create("minecraft:acacia_door[facing=north,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[565] = UnifiedStateName.create("minecraft:lime_wool[]");
        BlockStateMapper.STATES[1682] = UnifiedStateName.create("minecraft:melon_stem[age=2]");
        BlockStateMapper.STATES[3585] = UnifiedStateName.create("minecraft:lime_shulker_box[facing=up]");
        BlockStateMapper.STATES[2851] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=3]");
        BlockStateMapper.STATES[369] = UnifiedStateName.create("minecraft:dispenser[facing=up,triggered=false]");
        BlockStateMapper.STATES[2533] = UnifiedStateName.create("minecraft:dropper[facing=east,triggered=false]");
        BlockStateMapper.STATES[2041] = UnifiedStateName.create("minecraft:cocoa[age=2,facing=west]");
        BlockStateMapper.STATES[84] = UnifiedStateName.create("minecraft:acacia_planks[]");
        BlockStateMapper.STATES[1714] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=north,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[1586] = UnifiedStateName.create("minecraft:brown_mushroom_block[down=false,east=false,north=true,south=false,up=true,west=false]");
        BlockStateMapper.STATES[1442] = UnifiedStateName.create("minecraft:nether_portal[axis=z]");
        BlockStateMapper.STATES[2593] = UnifiedStateName.create("minecraft:dark_oak_log[axis=y]");
        BlockStateMapper.STATES[3394] = UnifiedStateName.create("minecraft:frosted_ice[age=2]");
        BlockStateMapper.STATES[3792] = UnifiedStateName.create("minecraft:magenta_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[1751] = UnifiedStateName.create("minecraft:stone_brick_stairs[facing=north,half=top,shape=straight]");
        BlockStateMapper.STATES[4020] = UnifiedStateName.create("minecraft:yellow_concrete[]");
        BlockStateMapper.STATES[282] = UnifiedStateName.create("minecraft:birch_log[axis=z]");
        BlockStateMapper.STATES[1681] = UnifiedStateName.create("minecraft:melon_stem[age=1]");
        BlockStateMapper.STATES[1491] = UnifiedStateName.create("minecraft:repeater[delay=1,facing=east,locked=false,powered=false]");
        BlockStateMapper.STATES[2848] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=0]");
        BlockStateMapper.STATES[1876] = UnifiedStateName.create("minecraft:brewing_stand[has_bottle_0=false,has_bottle_1=false,has_bottle_2=true]");
        BlockStateMapper.STATES[17] = UnifiedStateName.create("minecraft:granite[]");
        BlockStateMapper.STATES[4035] = UnifiedStateName.create("minecraft:light_blue_concrete_powder[]");
        BlockStateMapper.STATES[159] = UnifiedStateName.create("minecraft:water[level=15]");
        BlockStateMapper.STATES[532] = UnifiedStateName.create("minecraft:piston[extended=false,facing=west]");
        BlockStateMapper.STATES[2522] = UnifiedStateName.create("minecraft:activator_rail[powered=true,shape=ascending_east]");
        BlockStateMapper.STATES[240] = UnifiedStateName.create("minecraft:iron_ore[]");
        BlockStateMapper.STATES[3395] = UnifiedStateName.create("minecraft:frosted_ice[age=3]");
        BlockStateMapper.STATES[1602] = UnifiedStateName.create("minecraft:red_mushroom_block[down=false,east=false,north=true,south=false,up=true,west=false]");
        BlockStateMapper.STATES[2367] = UnifiedStateName.create("minecraft:light_weighted_pressure_plate[power=15]");
        BlockStateMapper.STATES[2932] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=south,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[3160] = UnifiedStateName.create("minecraft:dark_oak_door[facing=east,half=upper,hinge=left,open=false,powered=false]");
        BlockStateMapper.STATES[3106] = UnifiedStateName.create("minecraft:birch_door[facing=west,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[2935] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=east,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[1680] = UnifiedStateName.create("minecraft:melon_stem[age=0]");
        BlockStateMapper.STATES[2849] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=1]");
        BlockStateMapper.STATES[3601] = UnifiedStateName.create("minecraft:pink_shulker_box[facing=up]");
        BlockStateMapper.STATES[2989] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=west,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[2323] = UnifiedStateName.create("minecraft:anvil[facing=east]");
        BlockStateMapper.STATES[475] = UnifiedStateName.create("minecraft:sticky_piston[extended=true,facing=south]");
        BlockStateMapper.STATES[1539] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=east,half=bottom,open=false,powered=false]");
        BlockStateMapper.STATES[1494] = UnifiedStateName.create("minecraft:repeater[delay=2,facing=north,locked=false,powered=false]");
        BlockStateMapper.STATES[2973] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=west,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[278] = UnifiedStateName.create("minecraft:birch_log[axis=x]");
        BlockStateMapper.STATES[2564] = UnifiedStateName.create("minecraft:yellow_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[1441] = UnifiedStateName.create("minecraft:nether_portal[axis=x]");
        BlockStateMapper.STATES[3113] = UnifiedStateName.create("minecraft:birch_door[facing=east,half=upper,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[1723] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=east,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[2536] = UnifiedStateName.create("minecraft:dropper[facing=down,triggered=true]");
        BlockStateMapper.STATES[2854] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=6]");
        BlockStateMapper.STATES[49] = UnifiedStateName.create("minecraft:coarse_dirt[]");
        BlockStateMapper.STATES[545] = UnifiedStateName.create("minecraft:piston_head[facing=up,short=false,type=normal]");
        BlockStateMapper.STATES[3408] = UnifiedStateName.create("minecraft:magma_block[]");
        BlockStateMapper.STATES[224] = UnifiedStateName.create("minecraft:gold_ore[]");
        BlockStateMapper.STATES[157] = UnifiedStateName.create("minecraft:water[level=13]");
        BlockStateMapper.STATES[3716] = UnifiedStateName.create("minecraft:green_shulker_box[facing=west]");
        BlockStateMapper.STATES[2975] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=east,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[2680] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=north,half=top,open=false]");
        BlockStateMapper.STATES[2515] = UnifiedStateName.create("minecraft:activator_rail[powered=false,shape=ascending_west]");
        BlockStateMapper.STATES[1408] = UnifiedStateName.create("minecraft:soul_sand[]");
        BlockStateMapper.STATES[3109] = UnifiedStateName.create("minecraft:birch_door[facing=south,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[2681] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=south,half=top,open=false]");
        BlockStateMapper.STATES[2042] = UnifiedStateName.create("minecraft:cocoa[age=2,facing=north]");
        BlockStateMapper.STATES[428] = UnifiedStateName.create("minecraft:red_bed[facing=south,occupied=true,part=head]");
        BlockStateMapper.STATES[370] = UnifiedStateName.create("minecraft:dispenser[facing=north,triggered=false]");
        BlockStateMapper.STATES[3170] = UnifiedStateName.create("minecraft:end_rod[facing=north]");
        BlockStateMapper.STATES[85] = UnifiedStateName.create("minecraft:dark_oak_planks[]");
        BlockStateMapper.STATES[2855] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=7]");
        BlockStateMapper.STATES[3139] = UnifiedStateName.create("minecraft:acacia_door[facing=north,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3496] = UnifiedStateName.create("minecraft:observer[facing=down,powered=true]");
        BlockStateMapper.STATES[2037] = UnifiedStateName.create("minecraft:cocoa[age=1,facing=west]");
        BlockStateMapper.STATES[158] = UnifiedStateName.create("minecraft:water[level=14]");
        BlockStateMapper.STATES[32] = UnifiedStateName.create("minecraft:grass_block[snowy=false]");
        BlockStateMapper.STATES[1687] = UnifiedStateName.create("minecraft:melon_stem[age=7]");
        BlockStateMapper.STATES[2502] = UnifiedStateName.create("minecraft:quartz_stairs[facing=south,half=top,shape=straight]");
        BlockStateMapper.STATES[2852] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=4]");
        BlockStateMapper.STATES[3858] = UnifiedStateName.create("minecraft:pink_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[2117] = UnifiedStateName.create("minecraft:tripwire[attached=true,disarmed=false,east=false,north=false,powered=true,south=false,west=false]");
        BlockStateMapper.STATES[2004] = UnifiedStateName.create("minecraft:acacia_slab[type=double]");
        BlockStateMapper.STATES[2116] = UnifiedStateName.create("minecraft:tripwire[attached=true,disarmed=false,east=false,north=false,powered=false,south=false,west=false]");
        BlockStateMapper.STATES[2321] = UnifiedStateName.create("minecraft:anvil[facing=west]");
        BlockStateMapper.STATES[155] = UnifiedStateName.create("minecraft:water[level=11]");
        BlockStateMapper.STATES[3728] = UnifiedStateName.create("minecraft:red_shulker_box[facing=down]");
        BlockStateMapper.STATES[1856] = UnifiedStateName.create("minecraft:enchanting_table[]");
        BlockStateMapper.STATES[436] = UnifiedStateName.create("minecraft:powered_rail[powered=false,shape=ascending_north]");
        BlockStateMapper.STATES[1543] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=east,half=bottom,open=true,powered=true]");
        BlockStateMapper.STATES[112] = UnifiedStateName.create("minecraft:bedrock[]");
        BlockStateMapper.STATES[1686] = UnifiedStateName.create("minecraft:melon_stem[age=6]");
        BlockStateMapper.STATES[2853] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=5]");
        BlockStateMapper.STATES[1968] = UnifiedStateName.create("minecraft:redstone_lamp[lit=false]");
        BlockStateMapper.STATES[3099] = UnifiedStateName.create("minecraft:spruce_door[facing=east,half=upper,hinge=right,open=false,powered=true]");
        BlockStateMapper.STATES[304] = UnifiedStateName.create("minecraft:sponge[]");
        BlockStateMapper.STATES[156] = UnifiedStateName.create("minecraft:water[level=12]");
        BlockStateMapper.STATES[1828] = UnifiedStateName.create("minecraft:nether_brick_stairs[facing=east,half=top,shape=straight]");
        BlockStateMapper.STATES[3664] = UnifiedStateName.create("minecraft:purple_shulker_box[facing=down]");
        BlockStateMapper.STATES[3392] = UnifiedStateName.create("minecraft:frosted_ice[age=0]");
        BlockStateMapper.STATES[3248] = UnifiedStateName.create("minecraft:purpur_stairs[facing=east,half=bottom,shape=straight]");
        BlockStateMapper.STATES[1685] = UnifiedStateName.create("minecraft:melon_stem[age=5]");
        BlockStateMapper.STATES[3794] = UnifiedStateName.create("minecraft:magenta_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[1840] = UnifiedStateName.create("minecraft:nether_wart[age=0]");
        BlockStateMapper.STATES[2275] = UnifiedStateName.create("minecraft:potatoes[age=3]");
        BlockStateMapper.STATES[2035] = UnifiedStateName.create("minecraft:cocoa[age=0,facing=east]");
        BlockStateMapper.STATES[2026] = UnifiedStateName.create("minecraft:birch_slab[type=top]");
        BlockStateMapper.STATES[2612] = UnifiedStateName.create("minecraft:acacia_stairs[facing=east,half=top,shape=straight]");
        BlockStateMapper.STATES[2300] = UnifiedStateName.create("minecraft:oak_button[face=wall,facing=north,powered=true]");
        BlockStateMapper.STATES[697] = UnifiedStateName.create("minecraft:smooth_sandstone[]");
        BlockStateMapper.STATES[3522] = UnifiedStateName.create("minecraft:orange_shulker_box[facing=north]");
        BlockStateMapper.STATES[3856] = UnifiedStateName.create("minecraft:pink_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[3094] = UnifiedStateName.create("minecraft:spruce_door[facing=west,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[18] = UnifiedStateName.create("minecraft:polished_granite[]");
        BlockStateMapper.STATES[1250] = UnifiedStateName.create("minecraft:snow[layers=3]");
        BlockStateMapper.STATES[1522] = UnifiedStateName.create("minecraft:magenta_stained_glass[]");
        BlockStateMapper.STATES[294] = UnifiedStateName.create("minecraft:birch_leaves[distance=1,persistent=true]");
        BlockStateMapper.STATES[1538] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=west,half=bottom,open=false,powered=false]");
        BlockStateMapper.STATES[2276] = UnifiedStateName.create("minecraft:potatoes[age=4]");
        BlockStateMapper.STATES[1520] = UnifiedStateName.create("minecraft:white_stained_glass[]");
        BlockStateMapper.STATES[305] = UnifiedStateName.create("minecraft:wet_sponge[]");
        BlockStateMapper.STATES[2274] = UnifiedStateName.create("minecraft:potatoes[age=2]");
        BlockStateMapper.STATES[1589] = UnifiedStateName.create("minecraft:brown_mushroom_block[down=false,east=false,north=false,south=false,up=true,west=false]");
        BlockStateMapper.STATES[564] = UnifiedStateName.create("minecraft:yellow_wool[]");
        BlockStateMapper.STATES[708] = UnifiedStateName.create("minecraft:brick_slab[type=bottom]");
        BlockStateMapper.STATES[3162] = UnifiedStateName.create("minecraft:dark_oak_door[facing=east,half=upper,hinge=left,open=false,powered=true]");
        BlockStateMapper.STATES[154] = UnifiedStateName.create("minecraft:water[level=10]");
        BlockStateMapper.STATES[2609] = UnifiedStateName.create("minecraft:acacia_stairs[facing=west,half=bottom,shape=straight]");
        BlockStateMapper.STATES[3634] = UnifiedStateName.create("minecraft:light_gray_shulker_box[facing=north]");
        BlockStateMapper.STATES[377] = UnifiedStateName.create("minecraft:dispenser[facing=up,triggered=true]");
        BlockStateMapper.STATES[3104] = UnifiedStateName.create("minecraft:birch_door[facing=east,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3240] = UnifiedStateName.create("minecraft:purpur_pillar[axis=z]");
        BlockStateMapper.STATES[3091] = UnifiedStateName.create("minecraft:spruce_door[facing=north,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3232] = UnifiedStateName.create("minecraft:purpur_pillar[axis=y]");
        BlockStateMapper.STATES[2151] = UnifiedStateName.create("minecraft:spruce_stairs[facing=north,half=top,shape=straight]");
        BlockStateMapper.STATES[1251] = UnifiedStateName.create("minecraft:snow[layers=4]");
        BlockStateMapper.STATES[3344] = UnifiedStateName.create("minecraft:end_gateway[]");
        BlockStateMapper.STATES[2273] = UnifiedStateName.create("minecraft:potatoes[age=1]");
        BlockStateMapper.STATES[1119] = UnifiedStateName.create("minecraft:lever[face=ceiling,facing=east,powered=true]");
        BlockStateMapper.STATES[716] = UnifiedStateName.create("minecraft:brick_slab[type=top]");
        BlockStateMapper.STATES[2746] = UnifiedStateName.create("minecraft:purple_carpet[]");
        BlockStateMapper.STATES[709] = UnifiedStateName.create("minecraft:stone_brick_slab[type=bottom]");
        BlockStateMapper.STATES[2957] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=west,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[3636] = UnifiedStateName.create("minecraft:light_gray_shulker_box[facing=west]");
        BlockStateMapper.STATES[3171] = UnifiedStateName.create("minecraft:end_rod[facing=south]");
        BlockStateMapper.STATES[1248] = UnifiedStateName.create("minecraft:snow[layers=1]");
        BlockStateMapper.STATES[832] = UnifiedStateName.create("minecraft:spawner[]");
        BlockStateMapper.STATES[2181] = UnifiedStateName.create("minecraft:jungle_stairs[facing=west,half=top,shape=straight]");
        BlockStateMapper.STATES[2557] = UnifiedStateName.create("minecraft:green_terracotta[]");
        BlockStateMapper.STATES[1508] = UnifiedStateName.create("minecraft:repeater[delay=2,facing=south,locked=false,powered=true]");
        BlockStateMapper.STATES[2272] = UnifiedStateName.create("minecraft:potatoes[age=0]");
        BlockStateMapper.STATES[2742] = UnifiedStateName.create("minecraft:pink_carpet[]");
        BlockStateMapper.STATES[3004] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=south,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[821] = UnifiedStateName.create("minecraft:fire[age=5,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[718] = UnifiedStateName.create("minecraft:nether_brick_slab[type=top]");
        BlockStateMapper.STATES[3586] = UnifiedStateName.create("minecraft:lime_shulker_box[facing=north]");
        BlockStateMapper.STATES[1114] = UnifiedStateName.create("minecraft:lever[face=wall,facing=west,powered=true]");
        BlockStateMapper.STATES[2162] = UnifiedStateName.create("minecraft:birch_stairs[facing=south,half=bottom,shape=straight]");
        BlockStateMapper.STATES[3682] = UnifiedStateName.create("minecraft:blue_shulker_box[facing=north]");
        BlockStateMapper.STATES[1249] = UnifiedStateName.create("minecraft:snow[layers=2]");
        BlockStateMapper.STATES[2205] = UnifiedStateName.create("minecraft:command_block[conditional=true,facing=east]");
        BlockStateMapper.STATES[1517] = UnifiedStateName.create("minecraft:repeater[delay=4,facing=west,locked=false,powered=true]");
        BlockStateMapper.STATES[703] = UnifiedStateName.create("minecraft:smooth_quartz[]");
        BlockStateMapper.STATES[928] = UnifiedStateName.create("minecraft:crafting_table[]");
        BlockStateMapper.STATES[737] = UnifiedStateName.create("minecraft:tnt[unstable=true]");
        BlockStateMapper.STATES[2242] = UnifiedStateName.create("minecraft:potted_dandelion[]");
        BlockStateMapper.STATES[1254] = UnifiedStateName.create("minecraft:snow[layers=7]");
        BlockStateMapper.STATES[1120] = UnifiedStateName.create("minecraft:stone_pressure_plate[powered=false]");
        BlockStateMapper.STATES[1701] = UnifiedStateName.create("minecraft:vine[east=false,north=true,south=true,up=false,west=false]");
        BlockStateMapper.STATES[2111] = UnifiedStateName.create("minecraft:tripwire_hook[attached=true,facing=east,powered=true]");
        BlockStateMapper.STATES[1843] = UnifiedStateName.create("minecraft:nether_wart[age=3]");
        BlockStateMapper.STATES[2986] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=north,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[3970] = UnifiedStateName.create("minecraft:green_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[3620] = UnifiedStateName.create("minecraft:gray_shulker_box[facing=west]");
        BlockStateMapper.STATES[4031] = UnifiedStateName.create("minecraft:black_concrete[]");
        BlockStateMapper.STATES[2959] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=east,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[1549] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=south,half=top,open=true,powered=true]");
        BlockStateMapper.STATES[2325] = UnifiedStateName.create("minecraft:chipped_anvil[facing=west]");
        BlockStateMapper.STATES[3937] = UnifiedStateName.create("minecraft:blue_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[2575] = UnifiedStateName.create("minecraft:black_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[1255] = UnifiedStateName.create("minecraft:snow[layers=8]");
        BlockStateMapper.STATES[1873] = UnifiedStateName.create("minecraft:brewing_stand[has_bottle_0=true,has_bottle_1=false,has_bottle_2=false]");
        BlockStateMapper.STATES[1205] = UnifiedStateName.create("minecraft:redstone_torch[lit=false]");
        BlockStateMapper.STATES[2297] = UnifiedStateName.create("minecraft:oak_button[face=wall,facing=east,powered=true]");
        BlockStateMapper.STATES[1842] = UnifiedStateName.create("minecraft:nether_wart[age=2]");
        BlockStateMapper.STATES[2293] = UnifiedStateName.create("minecraft:oak_button[face=floor,facing=east,powered=false]");
        BlockStateMapper.STATES[3140] = UnifiedStateName.create("minecraft:acacia_door[facing=east,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[3107] = UnifiedStateName.create("minecraft:birch_door[facing=north,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[2530] = UnifiedStateName.create("minecraft:dropper[facing=north,triggered=false]");
        BlockStateMapper.STATES[3236] = UnifiedStateName.create("minecraft:purpur_pillar[axis=x]");
        BlockStateMapper.STATES[2160] = UnifiedStateName.create("minecraft:birch_stairs[facing=east,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2178] = UnifiedStateName.create("minecraft:jungle_stairs[facing=south,half=bottom,shape=straight]");
        BlockStateMapper.STATES[3505] = UnifiedStateName.create("minecraft:white_shulker_box[facing=up]");
        BlockStateMapper.STATES[1252] = UnifiedStateName.create("minecraft:snow[layers=5]");
        BlockStateMapper.STATES[2678] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=west,half=bottom,open=true]");
        BlockStateMapper.STATES[688] = UnifiedStateName.create("minecraft:stone_slab[type=double]");
        BlockStateMapper.STATES[3280] = UnifiedStateName.create("minecraft:purpur_slab[type=bottom]");
        BlockStateMapper.STATES[1528] = UnifiedStateName.create("minecraft:light_gray_stained_glass[]");
        BlockStateMapper.STATES[284] = UnifiedStateName.create("minecraft:oak_wood[]");
        BlockStateMapper.STATES[1841] = UnifiedStateName.create("minecraft:nether_wart[age=1]");
        BlockStateMapper.STATES[2630] = UnifiedStateName.create("minecraft:dark_oak_stairs[facing=south,half=top,shape=straight]");
        BlockStateMapper.STATES[2581] = UnifiedStateName.create("minecraft:dark_oak_leaves[distance=1,persistent=true]");
        BlockStateMapper.STATES[2292] = UnifiedStateName.create("minecraft:oak_button[face=wall,facing=north,powered=false]");
        BlockStateMapper.STATES[854] = UnifiedStateName.create("minecraft:oak_stairs[facing=south,half=top,shape=outer_right]");
        BlockStateMapper.STATES[2745] = UnifiedStateName.create("minecraft:cyan_carpet[]");
        BlockStateMapper.STATES[2192] = UnifiedStateName.create("minecraft:command_block[conditional=false,facing=down]");
        BlockStateMapper.STATES[2940] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=south,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[1718] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=north,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[2784] = UnifiedStateName.create("minecraft:packed_ice[]");
        BlockStateMapper.STATES[2512] = UnifiedStateName.create("minecraft:activator_rail[powered=false,shape=north_south]");
        BlockStateMapper.STATES[2054] = UnifiedStateName.create("minecraft:sandstone_stairs[facing=south,half=top,shape=straight]");
        BlockStateMapper.STATES[1253] = UnifiedStateName.create("minecraft:snow[layers=6]");
        BlockStateMapper.STATES[2570] = UnifiedStateName.create("minecraft:purple_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[2566] = UnifiedStateName.create("minecraft:pink_stained_glass_pane[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[3365] = UnifiedStateName.create("minecraft:repeating_command_block[conditional=false,facing=east]");
        BlockStateMapper.STATES[719] = UnifiedStateName.create("minecraft:quartz_slab[type=top]");
        BlockStateMapper.STATES[1536] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=north,half=bottom,open=false,powered=false]");
        BlockStateMapper.STATES[101] = UnifiedStateName.create("minecraft:dark_oak_sapling[stage=0]");
        BlockStateMapper.STATES[554] = UnifiedStateName.create("minecraft:piston_head[facing=north,short=false,type=sticky]");
        BlockStateMapper.STATES[3749] = UnifiedStateName.create("minecraft:black_shulker_box[facing=east]");
        BlockStateMapper.STATES[2614] = UnifiedStateName.create("minecraft:acacia_stairs[facing=south,half=top,shape=straight]");
        BlockStateMapper.STATES[109] = UnifiedStateName.create("minecraft:dark_oak_sapling[stage=1]");
        BlockStateMapper.STATES[4027] = UnifiedStateName.create("minecraft:blue_concrete[]");
        BlockStateMapper.STATES[894] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=14,south=none,west=none]");
        BlockStateMapper.STATES[1708] = UnifiedStateName.create("minecraft:vine[east=true,north=true,south=false,up=false,west=false]");
        BlockStateMapper.STATES[3811] = UnifiedStateName.create("minecraft:light_blue_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[1904] = UnifiedStateName.create("minecraft:end_portal[]");
        BlockStateMapper.STATES[2128] = UnifiedStateName.create("minecraft:emerald_block[]");
        BlockStateMapper.STATES[3002] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=north,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[3008] = UnifiedStateName.create("minecraft:spruce_fence[east=false,north=false,south=false,west=false]");
        BlockStateMapper.STATES[1457] = UnifiedStateName.create("minecraft:jack_o_lantern[facing=west]");
        BlockStateMapper.STATES[2376] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=8]");
        BlockStateMapper.STATES[2968] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=south,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[2808] = UnifiedStateName.create("minecraft:sunflower[half=upper]");
        BlockStateMapper.STATES[1705] = UnifiedStateName.create("minecraft:vine[east=true,north=false,south=true,up=false,west=false]");
        BlockStateMapper.STATES[2553] = UnifiedStateName.create("minecraft:cyan_terracotta[]");
        BlockStateMapper.STATES[1926] = UnifiedStateName.create("minecraft:end_portal_frame[eye=true,facing=north]");
        BlockStateMapper.STATES[823] = UnifiedStateName.create("minecraft:fire[age=7,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[2208] = UnifiedStateName.create("minecraft:beacon[]");
        BlockStateMapper.STATES[2672] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=north,half=bottom,open=false]");
        BlockStateMapper.STATES[2377] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=9]");
        BlockStateMapper.STATES[3826] = UnifiedStateName.create("minecraft:yellow_glazed_terracotta[facing=north]");
        BlockStateMapper.STATES[1113] = UnifiedStateName.create("minecraft:lever[face=wall,facing=east,powered=true]");
        BlockStateMapper.STATES[480] = UnifiedStateName.create("minecraft:cobweb[]");
        BlockStateMapper.STATES[2969] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=west,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[2289] = UnifiedStateName.create("minecraft:oak_button[face=wall,facing=east,powered=false]");
        BlockStateMapper.STATES[2559] = UnifiedStateName.create("minecraft:black_terracotta[]");
        BlockStateMapper.STATES[1713] = UnifiedStateName.create("minecraft:oak_fence_gate[facing=west,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[2884] = UnifiedStateName.create("minecraft:red_sandstone_stairs[facing=east,half=top,shape=straight]");
        BlockStateMapper.STATES[2983] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=east,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[2979] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=east,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[3440] = UnifiedStateName.create("minecraft:red_nether_bricks[]");
        BlockStateMapper.STATES[1232] = UnifiedStateName.create("minecraft:stone_button[face=ceiling,facing=east,powered=false]");
        BlockStateMapper.STATES[1879] = UnifiedStateName.create("minecraft:brewing_stand[has_bottle_0=true,has_bottle_1=true,has_bottle_2=true]");
        BlockStateMapper.STATES[2972] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=south,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[2418] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=2]");
        BlockStateMapper.STATES[3635] = UnifiedStateName.create("minecraft:light_gray_shulker_box[facing=south]");
        BlockStateMapper.STATES[293] = UnifiedStateName.create("minecraft:spruce_leaves[distance=1,persistent=true]");
        BlockStateMapper.STATES[3250] = UnifiedStateName.create("minecraft:purpur_stairs[facing=south,half=bottom,shape=straight]");
        BlockStateMapper.STATES[3254] = UnifiedStateName.create("minecraft:purpur_stairs[facing=south,half=top,shape=straight]");
        BlockStateMapper.STATES[2837] = UnifiedStateName.create("minecraft:white_wall_banner[facing=east]");
        BlockStateMapper.STATES[3587] = UnifiedStateName.create("minecraft:lime_shulker_box[facing=south]");
        BlockStateMapper.STATES[2949] = UnifiedStateName.create("minecraft:birch_fence_gate[facing=west,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[1305] = UnifiedStateName.create("minecraft:cactus[age=9]");
        BlockStateMapper.STATES[2419] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=3]");
        BlockStateMapper.STATES[2288] = UnifiedStateName.create("minecraft:oak_button[face=ceiling,facing=east,powered=false]");
        BlockStateMapper.STATES[884] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=4,south=none,west=none]");
        BlockStateMapper.STATES[286] = UnifiedStateName.create("minecraft:birch_wood[]");
        BlockStateMapper.STATES[571] = UnifiedStateName.create("minecraft:blue_wool[]");
        BlockStateMapper.STATES[2995] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=east,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[4032] = UnifiedStateName.create("minecraft:white_concrete_powder[]");
        BlockStateMapper.STATES[279] = UnifiedStateName.create("minecraft:jungle_log[axis=x]");
        BlockStateMapper.STATES[2704] = UnifiedStateName.create("minecraft:sea_lantern[]");
        BlockStateMapper.STATES[3573] = UnifiedStateName.create("minecraft:yellow_shulker_box[facing=east]");
        BlockStateMapper.STATES[3763] = UnifiedStateName.create("minecraft:white_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[572] = UnifiedStateName.create("minecraft:brown_wool[]");
        BlockStateMapper.STATES[2279] = UnifiedStateName.create("minecraft:potatoes[age=7]");
        BlockStateMapper.STATES[1024] = UnifiedStateName.create("minecraft:oak_door[facing=east,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[1304] = UnifiedStateName.create("minecraft:cactus[age=8]");
        BlockStateMapper.STATES[192] = UnifiedStateName.create("minecraft:sand[]");
        BlockStateMapper.STATES[3889] = UnifiedStateName.create("minecraft:light_gray_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[2416] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=0]");
        BlockStateMapper.STATES[1530] = UnifiedStateName.create("minecraft:purple_stained_glass[]");
        BlockStateMapper.STATES[2165] = UnifiedStateName.create("minecraft:birch_stairs[facing=west,half=top,shape=straight]");
        BlockStateMapper.STATES[275] = UnifiedStateName.create("minecraft:jungle_log[axis=y]");
        BlockStateMapper.STATES[3953] = UnifiedStateName.create("minecraft:brown_glazed_terracotta[facing=west]");
        BlockStateMapper.STATES[1594] = UnifiedStateName.create("minecraft:mushroom_stem[down=false,east=true,north=true,south=true,up=false,west=true]");
        BlockStateMapper.STATES[1063] = UnifiedStateName.create("minecraft:rail[shape=south_west]");
        BlockStateMapper.STATES[2812] = UnifiedStateName.create("minecraft:rose_bush[half=upper]");
        BlockStateMapper.STATES[1111] = UnifiedStateName.create("minecraft:lever[face=ceiling,facing=east,powered=false]");
        BlockStateMapper.STATES[3386] = UnifiedStateName.create("minecraft:chain_command_block[conditional=true,facing=north]");
        BlockStateMapper.STATES[2101] = UnifiedStateName.create("minecraft:tripwire_hook[attached=true,facing=west,powered=false]");
        BlockStateMapper.STATES[2278] = UnifiedStateName.create("minecraft:potatoes[age=6]");
        BlockStateMapper.STATES[3696] = UnifiedStateName.create("minecraft:brown_shulker_box[facing=down]");
        BlockStateMapper.STATES[1303] = UnifiedStateName.create("minecraft:cactus[age=7]");
        BlockStateMapper.STATES[3264] = UnifiedStateName.create("minecraft:purpur_slab[type=double]");
        BlockStateMapper.STATES[2254] = UnifiedStateName.create("minecraft:potted_blue_orchid[]");
        BlockStateMapper.STATES[1525] = UnifiedStateName.create("minecraft:lime_stained_glass[]");
        BlockStateMapper.STATES[2739] = UnifiedStateName.create("minecraft:light_blue_carpet[]");
        BlockStateMapper.STATES[2417] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=1]");
        BlockStateMapper.STATES[888] = UnifiedStateName.create("minecraft:redstone_wire[east=none,north=none,power=8,south=none,west=none]");
        BlockStateMapper.STATES[2999] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=east,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[3907] = UnifiedStateName.create("minecraft:cyan_glazed_terracotta[facing=east]");
        BlockStateMapper.STATES[283] = UnifiedStateName.create("minecraft:jungle_log[axis=z]");
        BlockStateMapper.STATES[2887] = UnifiedStateName.create("minecraft:red_sandstone_stairs[facing=north,half=top,shape=straight]");
        BlockStateMapper.STATES[1599] = UnifiedStateName.create("minecraft:mushroom_stem[down=true,east=true,north=true,south=true,up=true,west=true]");
        BlockStateMapper.STATES[2277] = UnifiedStateName.create("minecraft:potatoes[age=5]");
        BlockStateMapper.STATES[3368] = UnifiedStateName.create("minecraft:repeating_command_block[conditional=true,facing=down]");
        BlockStateMapper.STATES[1302] = UnifiedStateName.create("minecraft:cactus[age=6]");
        BlockStateMapper.STATES[2928] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=south,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[2500] = UnifiedStateName.create("minecraft:quartz_stairs[facing=east,half=top,shape=straight]");
        BlockStateMapper.STATES[1824] = UnifiedStateName.create("minecraft:nether_brick_stairs[facing=east,half=bottom,shape=straight]");
        BlockStateMapper.STATES[4021] = UnifiedStateName.create("minecraft:lime_concrete[]");
        BlockStateMapper.STATES[468] = UnifiedStateName.create("minecraft:sticky_piston[extended=false,facing=west]");
        BlockStateMapper.STATES[592] = UnifiedStateName.create("minecraft:dandelion[]");
        BlockStateMapper.STATES[2422] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=6]");
        BlockStateMapper.STATES[2370] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=2]");
        BlockStateMapper.STATES[368] = UnifiedStateName.create("minecraft:dispenser[facing=down,triggered=false]");
        BlockStateMapper.STATES[2937] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=west,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[3155] = UnifiedStateName.create("minecraft:dark_oak_door[facing=north,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3653] = UnifiedStateName.create("minecraft:cyan_shulker_box[facing=east]");
        BlockStateMapper.STATES[3968] = UnifiedStateName.create("minecraft:green_glazed_terracotta[facing=south]");
        BlockStateMapper.STATES[2991] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=east,in_wall=false,open=true,powered=true]");
        BlockStateMapper.STATES[537] = UnifiedStateName.create("minecraft:piston[extended=true,facing=up]");
        BlockStateMapper.STATES[1889] = UnifiedStateName.create("minecraft:cauldron[level=1]");
        BlockStateMapper.STATES[1556] = UnifiedStateName.create("minecraft:infested_cracked_stone_bricks[]");
        BlockStateMapper.STATES[2203] = UnifiedStateName.create("minecraft:command_block[conditional=true,facing=south]");
        BlockStateMapper.STATES[1301] = UnifiedStateName.create("minecraft:cactus[age=5]");
        BlockStateMapper.STATES[3376] = UnifiedStateName.create("minecraft:chain_command_block[conditional=false,facing=down]");
        BlockStateMapper.STATES[376] = UnifiedStateName.create("minecraft:dispenser[facing=down,triggered=true]");
        BlockStateMapper.STATES[3683] = UnifiedStateName.create("minecraft:blue_shulker_box[facing=south]");
        BlockStateMapper.STATES[1890] = UnifiedStateName.create("minecraft:cauldron[level=2]");
        BlockStateMapper.STATES[2371] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=3]");
        BlockStateMapper.STATES[2423] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=7]");
        BlockStateMapper.STATES[539] = UnifiedStateName.create("minecraft:piston[extended=true,facing=south]");
        BlockStateMapper.STATES[1488] = UnifiedStateName.create("minecraft:repeater[delay=1,facing=south,locked=false,powered=false]");
        BlockStateMapper.STATES[22] = UnifiedStateName.create("minecraft:polished_andesite[]");
        BlockStateMapper.STATES[2313] = UnifiedStateName.create("minecraft:skeleton_skull[rotation=12]");
        BlockStateMapper.STATES[1074] = UnifiedStateName.create("minecraft:cobblestone_stairs[facing=south,half=bottom,shape=straight]");
        BlockStateMapper.STATES[752] = UnifiedStateName.create("minecraft:bookshelf[]");
        BlockStateMapper.STATES[3123] = UnifiedStateName.create("minecraft:jungle_door[facing=north,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[48] = UnifiedStateName.create("minecraft:dirt[]");
        BlockStateMapper.STATES[1300] = UnifiedStateName.create("minecraft:cactus[age=4]");
        BlockStateMapper.STATES[1891] = UnifiedStateName.create("minecraft:cauldron[level=3]");
        BlockStateMapper.STATES[291] = UnifiedStateName.create("minecraft:jungle_leaves[distance=1,persistent=false]");
        BlockStateMapper.STATES[3540] = UnifiedStateName.create("minecraft:magenta_shulker_box[facing=west]");
        BlockStateMapper.STATES[2420] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=4]");
        BlockStateMapper.STATES[4030] = UnifiedStateName.create("minecraft:red_concrete[]");
        BlockStateMapper.STATES[2537] = UnifiedStateName.create("minecraft:dropper[facing=up,triggered=true]");
        BlockStateMapper.STATES[3124] = UnifiedStateName.create("minecraft:jungle_door[facing=east,half=lower,hinge=right,open=true,powered=false]");
        BlockStateMapper.STATES[2107] = UnifiedStateName.create("minecraft:tripwire_hook[attached=false,facing=east,powered=true]");
        BlockStateMapper.STATES[418] = UnifiedStateName.create("minecraft:red_bed[facing=north,occupied=false,part=foot]");
        BlockStateMapper.STATES[1534] = UnifiedStateName.create("minecraft:red_stained_glass[]");
        BlockStateMapper.STATES[2029] = UnifiedStateName.create("minecraft:dark_oak_slab[type=top]");
        BlockStateMapper.STATES[336] = UnifiedStateName.create("minecraft:lapis_ore[]");
        BlockStateMapper.STATES[2856] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=8]");
        BlockStateMapper.STATES[715] = UnifiedStateName.create("minecraft:cobblestone_slab[type=top]");
        BlockStateMapper.STATES[573] = UnifiedStateName.create("minecraft:green_wool[]");
        BlockStateMapper.STATES[1664] = UnifiedStateName.create("minecraft:pumpkin_stem[age=0]");
        BlockStateMapper.STATES[3112] = UnifiedStateName.create("minecraft:birch_door[facing=east,half=upper,hinge=left,open=false,powered=false]");
        BlockStateMapper.STATES[784] = UnifiedStateName.create("minecraft:obsidian[]");
        BlockStateMapper.STATES[2421] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=5]");
        BlockStateMapper.STATES[1299] = UnifiedStateName.create("minecraft:cactus[age=3]");
        BlockStateMapper.STATES[2103] = UnifiedStateName.create("minecraft:tripwire_hook[attached=true,facing=east,powered=false]");
        BlockStateMapper.STATES[2369] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=1]");
        BlockStateMapper.STATES[2368] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=0]");
        BlockStateMapper.STATES[1606] = UnifiedStateName.create("minecraft:red_mushroom_block[down=false,east=true,north=false,south=false,up=true,west=false]");
        BlockStateMapper.STATES[2682] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=west,half=top,open=false]");
        BlockStateMapper.STATES[2683] = UnifiedStateName.create("minecraft:iron_trapdoor[facing=east,half=top,open=false]");
        BlockStateMapper.STATES[2751] = UnifiedStateName.create("minecraft:black_carpet[]");
        BlockStateMapper.STATES[2857] = UnifiedStateName.create("minecraft:daylight_detector[inverted=true,power=9]");
        BlockStateMapper.STATES[1746] = UnifiedStateName.create("minecraft:stone_brick_stairs[facing=south,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2967] = UnifiedStateName.create("minecraft:jungle_fence_gate[facing=east,in_wall=false,open=true,powered=false]");
        BlockStateMapper.STATES[2540] = UnifiedStateName.create("minecraft:dropper[facing=west,triggered=true]");
        BlockStateMapper.STATES[577] = UnifiedStateName.create("minecraft:moving_piston[facing=up,type=normal]");
        BlockStateMapper.STATES[2374] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=6]");
        BlockStateMapper.STATES[1665] = UnifiedStateName.create("minecraft:pumpkin_stem[age=1]");
        BlockStateMapper.STATES[1298] = UnifiedStateName.create("minecraft:cactus[age=2]");
        BlockStateMapper.STATES[431] = UnifiedStateName.create("minecraft:red_bed[facing=east,occupied=true,part=head]");
        BlockStateMapper.STATES[2125] = UnifiedStateName.create("minecraft:tripwire[attached=true,disarmed=true,east=false,north=false,powered=true,south=false,west=false]");
        BlockStateMapper.STATES[3472] = UnifiedStateName.create("minecraft:structure_void[]");
        BlockStateMapper.STATES[2104] = UnifiedStateName.create("minecraft:tripwire_hook[attached=false,facing=south,powered=true]");
        BlockStateMapper.STATES[2202] = UnifiedStateName.create("minecraft:command_block[conditional=true,facing=north]");
        BlockStateMapper.STATES[2464] = UnifiedStateName.create("minecraft:hopper[enabled=true,facing=down]");
        BlockStateMapper.STATES[2176] = UnifiedStateName.create("minecraft:jungle_stairs[facing=east,half=bottom,shape=straight]");
        BlockStateMapper.STATES[1218] = UnifiedStateName.create("minecraft:redstone_wall_torch[facing=west,lit=true]");
        BlockStateMapper.STATES[2472] = UnifiedStateName.create("minecraft:hopper[enabled=false,facing=down]");
        BlockStateMapper.STATES[4041] = UnifiedStateName.create("minecraft:cyan_concrete_powder[]");
        BlockStateMapper.STATES[4039] = UnifiedStateName.create("minecraft:gray_concrete_powder[]");
        BlockStateMapper.STATES[2003] = UnifiedStateName.create("minecraft:jungle_slab[type=double]");
        BlockStateMapper.STATES[2375] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=7]");
        BlockStateMapper.STATES[1666] = UnifiedStateName.create("minecraft:pumpkin_stem[age=2]");
        BlockStateMapper.STATES[2931] = UnifiedStateName.create("minecraft:spruce_fence_gate[facing=east,in_wall=false,open=false,powered=false]");
        BlockStateMapper.STATES[3216] = UnifiedStateName.create("minecraft:purpur_block[]");
        BlockStateMapper.STATES[1297] = UnifiedStateName.create("minecraft:cactus[age=1]");
        BlockStateMapper.STATES[3424] = UnifiedStateName.create("minecraft:nether_wart_block[]");
        BlockStateMapper.STATES[2146] = UnifiedStateName.create("minecraft:spruce_stairs[facing=south,half=bottom,shape=straight]");
        BlockStateMapper.STATES[1667] = UnifiedStateName.create("minecraft:pumpkin_stem[age=3]");
        BlockStateMapper.STATES[981] = UnifiedStateName.create("minecraft:furnace[facing=east,lit=false]");
        BlockStateMapper.STATES[2290] = UnifiedStateName.create("minecraft:oak_button[face=wall,facing=west,powered=false]");
        BlockStateMapper.STATES[2372] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=4]");
        BlockStateMapper.STATES[1296] = UnifiedStateName.create("minecraft:cactus[age=0]");
        BlockStateMapper.STATES[2424] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=8]");
        BlockStateMapper.STATES[1044] = UnifiedStateName.create("minecraft:ladder[facing=west]");
        BlockStateMapper.STATES[3001] = UnifiedStateName.create("minecraft:acacia_fence_gate[facing=west,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[498] = UnifiedStateName.create("minecraft:fern[]");
        BlockStateMapper.STATES[3088] = UnifiedStateName.create("minecraft:spruce_door[facing=east,half=lower,hinge=right,open=false,powered=false]");
        BlockStateMapper.STATES[3361] = UnifiedStateName.create("minecraft:repeating_command_block[conditional=false,facing=up]");
        BlockStateMapper.STATES[2601] = UnifiedStateName.create("minecraft:dark_oak_log[axis=z]");
        BlockStateMapper.STATES[560] = UnifiedStateName.create("minecraft:white_wool[]");
        BlockStateMapper.STATES[297] = UnifiedStateName.create("minecraft:spruce_leaves[distance=1,persistent=false]");
        BlockStateMapper.STATES[1242] = UnifiedStateName.create("minecraft:stone_button[face=wall,facing=west,powered=true]");
        BlockStateMapper.STATES[1704] = UnifiedStateName.create("minecraft:vine[east=true,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[2626] = UnifiedStateName.create("minecraft:dark_oak_stairs[facing=south,half=bottom,shape=straight]");
        BlockStateMapper.STATES[1601] = UnifiedStateName.create("minecraft:red_mushroom_block[down=false,east=false,north=true,south=false,up=true,west=true]");
        BlockStateMapper.STATES[1244] = UnifiedStateName.create("minecraft:stone_button[face=wall,facing=north,powered=true]");
        BlockStateMapper.STATES[2611] = UnifiedStateName.create("minecraft:acacia_stairs[facing=north,half=bottom,shape=straight]");
        BlockStateMapper.STATES[538] = UnifiedStateName.create("minecraft:piston[extended=true,facing=north]");
        BlockStateMapper.STATES[822] = UnifiedStateName.create("minecraft:fire[age=6,east=false,north=false,south=false,up=false,west=false]");
        BlockStateMapper.STATES[1668] = UnifiedStateName.create("minecraft:pumpkin_stem[age=4]");
        BlockStateMapper.STATES[2883] = UnifiedStateName.create("minecraft:red_sandstone_stairs[facing=north,half=bottom,shape=straight]");
        BlockStateMapper.STATES[2985] = UnifiedStateName.create("minecraft:dark_oak_fence_gate[facing=west,in_wall=false,open=false,powered=true]");
        BlockStateMapper.STATES[2373] = UnifiedStateName.create("minecraft:heavy_weighted_pressure_plate[power=5]");
        BlockStateMapper.STATES[3713] = UnifiedStateName.create("minecraft:green_shulker_box[facing=up]");
        BlockStateMapper.STATES[2425] = UnifiedStateName.create("minecraft:daylight_detector[inverted=false,power=9]");
        BlockStateMapper.STATES[1498] = UnifiedStateName.create("minecraft:repeater[delay=3,facing=north,locked=false,powered=false]");
        BlockStateMapper.STATES[912] = UnifiedStateName.create("minecraft:diamond_block[]");
        BlockStateMapper.STATES[1888] = UnifiedStateName.create("minecraft:cauldron[level=0]");
        BlockStateMapper.STATES[420] = UnifiedStateName.create("minecraft:red_bed[facing=south,occupied=true,part=foot]");
        BlockStateMapper.STATES[1544] = UnifiedStateName.create("minecraft:oak_trapdoor[facing=north,half=top,open=false,powered=false]");
    }
}

