/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.mapper;

import de.maggicraft.ism.mapper.EDirection;
import de.maggicraft.ism.mapper.EMirror;
import de.maggicraft.ism.mapper.IPosTranslator;
import de.maggicraft.ism.mapper.PosTranslators;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IPos;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class CreateTranslators {
    private static final Map<EDirection, BiFunction<IPos, IDim, IPosTranslator>> DIRECTIONS = new EnumMap<EDirection, BiFunction<IPos, IDim, IPosTranslator>>(EDirection.class);
    private static final Map<EMirror, BiFunction<IPos, IDim, IPosTranslator>> MIRRORS = new EnumMap<EMirror, BiFunction<IPos, IDim, IPosTranslator>>(EMirror.class);

    @NotNull
    public static IPosTranslator createTranslator(@NotNull IPos pPos, @NotNull IDim pDim, @NotNull EDirection pDirection, @NotNull EMirror pMirror) {
        IPosTranslator direction = DIRECTIONS.get(pDirection).apply(pPos, pDim);
        if (pMirror == EMirror.NO_MIRROR) {
            return direction;
        }
        IPosTranslator mirror = MIRRORS.get(pMirror).apply(pPos, pDim);
        return (pPosX, pPosY, pPosZ) -> {
            BlockPos pos = direction.translate(pPosX, pPosY, pPosZ);
            return mirror.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        };
    }

    static {
        DIRECTIONS.put(EDirection.POS_X_POS_Z, PosTranslators::translate);
        DIRECTIONS.put(EDirection.POS_X_NEG_Z, PosTranslators::posXNegZ);
        DIRECTIONS.put(EDirection.NEG_X_POS_Z, PosTranslators::negXPosZ);
        DIRECTIONS.put(EDirection.NEG_X_NEG_Z, PosTranslators::negXNegZ);
        MIRRORS.put(EMirror.NO_MIRROR, (pPos, pDim) -> BlockPos::new);
        MIRRORS.put(EMirror.MIRROR_X, PosTranslators::mirrorX);
        MIRRORS.put(EMirror.MIRROR_Y, PosTranslators::mirrorY);
        MIRRORS.put(EMirror.MIRROR_Z, PosTranslators::mirrorZ);
        MIRRORS.put(EMirror.MIRROR_X_Y, PosTranslators::mirrorXY);
        MIRRORS.put(EMirror.MIRROR_X_Z, PosTranslators::mirrorXZ);
        MIRRORS.put(EMirror.MIRROR_Y_Z, PosTranslators::mirrorYZ);
        MIRRORS.put(EMirror.MIRROR_X_Y_Z, PosTranslators::mirrorXYZ);
    }
}

